/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.web.forms;

import java.io.BufferedReader;
import java.io.StringReader;
import org.bedework.eventreg.bus.FormFields;
import org.bedework.eventreg.common.EventregInvalidNameException;
import org.bedework.eventreg.db.FieldDef;
import org.bedework.eventreg.db.FormDef;
import org.bedework.eventreg.web.AuthAbstractController;
import org.bedework.util.misc.Util;
import org.springframework.web.servlet.ModelAndView;

public class AddFieldController
extends AuthAbstractController {
    public ModelAndView doRequest() throws Throwable {
        try {
            String options;
            if (this.sessMan.getCurrentCalsuite() == null) {
                return this.errorReturn("No calsuite");
            }
            String formName = this.req.getFormName();
            FormDef form = this.sessMan.getFormDef(formName);
            if (form == null) {
                return this.errorReturn("No current form");
            }
            String fieldName = this.req.getName();
            if (fieldName == null) {
                return this.errorReturn("No field name");
            }
            String fieldType = this.req.getType();
            if (fieldType == null) {
                return this.errorReturn("No field type");
            }
            if (!FieldDef.validTypes.contains(fieldType)) {
                return this.errorReturn("Invalid field type: " + fieldType);
            }
            FieldDef field = new FieldDef();
            String group = null;
            if (this.req.groupPresent()) {
                group = this.req.getGroup();
            }
            field.setFormName(formName);
            field.setOwner(form.getOwner());
            field.setName(fieldName);
            field.setType(fieldType);
            field.setLabel(this.req.getLabel());
            field.setValue(this.req.getValue());
            field.setGroup(this.req.getDescription());
            field.setGroup(group);
            field.setRequired(this.req.getRequired());
            field.setOrder(this.req.getOrder());
            field.setDefaultValue(this.req.getDefault());
            field.setMultivalued(this.req.getMulti());
            field.setWidth(this.req.getWidth());
            field.setHeight(this.req.getHeight());
            FormFields ff = new FormFields(form.getFields());
            if (fieldType.equals("option")) {
                if (field.getGroup() == null) {
                    return this.errorReturn("No group set for option: " + fieldName);
                }
                if (ff.getField(field.getGroup()) == null) {
                    return this.errorReturn("No field " + field.getGroup() + " for option: " + fieldName);
                }
            }
            form.addField(field);
            this.sessMan.updateFormDef(form);
            if ((fieldType.equals("select") || fieldType.equals("radio")) && (options = this.req.getOptions()) != null && !this.createOptions(form, field, options)) {
                return this.errorReturn("Bad option for " + fieldName);
            }
            this.sessMan.setCurrentFormName(formName);
            this.sessMan.setMessage("ok");
            return this.objModel(this.getForwardSuccess(), "form", (Object)form, "fields", (Object)ff);
        }
        catch (EventregInvalidNameException eine) {
            return this.errorReturn("Invalid name field");
        }
    }

    private boolean createOptions(FormDef form, FieldDef field, String options) throws Throwable {
        BufferedReader rdr = new BufferedReader(new StringReader(options));
        int i = 100;
        String line = rdr.readLine();
        while (line != null) {
            FieldDef opt = new FieldDef();
            String[] valLabel = line.split("\\|");
            if (valLabel.length < 1) {
                return false;
            }
            String value = Util.checkNull((String)valLabel[0]);
            if (value == null) {
                if (this.debug()) {
                    // empty if block
                }
                return false;
            }
            String label = null;
            if (valLabel.length == 2) {
                label = valLabel[1];
            } else if (valLabel.length > 2) {
                return false;
            }
            opt.setFormName(field.getFormName());
            opt.setOwner(field.getOwner());
            opt.setName(field.getName() + "-" + i);
            opt.setType("option");
            opt.setGroup(field.getName());
            opt.setLabel(label);
            opt.setValue(value);
            opt.setOrder(i);
            opt.setDefaultValue(this.req.getDefault());
            i += 100;
            form.addField(opt);
            line = rdr.readLine();
        }
        rdr.close();
        return true;
    }
}

