/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bedework.eventreg.bus.Request;
import org.bedework.eventreg.bus.SessionManager;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class InitHandlers
extends HandlerInterceptorAdapter
implements Logged {
    private SessionManager sessMan;
    private BwLogger logger = new BwLogger();

    public void setSessionManager(SessionManager sm) {
        this.sessMan = sm;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.debug()) {
            this.debug("init handler Intercepter");
        }
        try {
            if (!this.sessMan.setReq(new Request(request, response))) {
                return false;
            }
            this.sessMan.openDb();
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
        return true;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

