/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.bus;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bedework.eventreg.common.EventregException;
import org.bedework.eventreg.common.EventregInvalidNameException;
import org.bedework.util.misc.Util;
import org.bedework.util.servlet.ReqUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class Request
extends ReqUtil {
    public static final String reqparAdminToken = "atkn";
    public static final String reqparCalsuite = "calsuite";
    public static final String reqparComment = "comment";
    public static final String reqparDescription = "description";
    public static final String reqparHref = "href";
    public static final String reqparNumtickets = "numtickets";
    public static final String reqparRegId = "regid";
    public static final String reqparCSVHeader = "csvheader";
    public static final String reqparEmail = "email";
    public static final String reqparFilename = "fn";
    public static final String reqparLastmod = "lastmod";
    public static final String reqparDefault = "default";
    private static final String reqparFormName = "formName";
    private static final String reqparGroup = "group";
    private static final String reqparName = "name";
    public static final String reqparDisable = "disable";
    public static final String reqparHeight = "height";
    public static final String reqparLabel = "label";
    public static final String reqparMulti = "multi";
    public static final String reqparOrder = "order";
    public static final String reqparRequired = "req";
    public static final String reqparOptions = "options";
    public static final String reqparType = "type";
    public static final String reqparValue = "value";
    public static final String reqparWidth = "width";

    public Request(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
    }

    public int getTicketsRequested() throws Throwable {
        return this.getIntReqPar("numtickets", -1);
    }

    public String getAdminToken() {
        return this.getReqPar("atkn");
    }

    public String getFilename(String def) {
        return this.getReqPar("fn", def);
    }

    public Long getRegistrationId() throws Throwable {
        return this.getLongReqPar("regid", -1L);
    }

    public boolean getCsvHeader() throws Throwable {
        return this.getBooleanReqPar("csvheader", true);
    }

    public String getCalsuite() {
        return this.getReqPar("calsuite");
    }

    public String getComment() {
        return this.getReqPar("comment");
    }

    public String getLastmod() {
        return this.getReqPar("lastmod");
    }

    public String getEmail() {
        return this.getReqPar("email");
    }

    public String getHref() {
        return this.getReqPar("href");
    }

    public boolean getDefault() throws Throwable {
        return this.getBooleanReqPar("default", false);
    }

    public boolean formNamePresent() throws EventregException {
        return Util.checkNull((String)this.getReqPar("formName")) != null;
    }

    public String getFormName() throws EventregException {
        return Request.validName((String)this.getReqPar("formName"));
    }

    public String getName() throws EventregException {
        return Request.validName((String)this.getReqPar("name"));
    }

    public boolean groupPresent() throws EventregException {
        return this.getReqPar("group") != null;
    }

    public String getGroup() throws EventregException {
        return Request.validName((String)this.getReqPar("group"));
    }

    public String getDescription() {
        return this.getReqPar("description");
    }

    public String getHeight() {
        return this.getReqPar("height");
    }

    public String getLabel() {
        return this.getReqPar("label");
    }

    public boolean getDisable() throws Throwable {
        return this.getBooleanReqPar("disable", false);
    }

    public boolean getMulti() throws Throwable {
        return this.getBooleanReqPar("multi", false);
    }

    public int getOrder() throws Throwable {
        return this.getIntReqPar("order", 0);
    }

    public boolean getRequired() throws Throwable {
        return this.getBooleanReqPar("req", false);
    }

    public String getOptions() {
        return this.getReqPar("options");
    }

    public String getType() {
        return this.getReqPar("type");
    }

    public String getValue() {
        return this.getReqPar("value");
    }

    public String getWidth() {
        return this.getReqPar("width");
    }

    public static String validName(String name) throws EventregException {
        if (name == null || name.length() == 0) {
            throw new EventregInvalidNameException(name);
        }
        if (!Character.isLetter(name.charAt(0))) {
            throw new EventregInvalidNameException(name);
        }
        for (int i = 1; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_') continue;
            throw new EventregInvalidNameException(name);
        }
        return name;
    }
}

