/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.bus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.bedework.eventreg.bus.FormFields;
import org.bedework.eventreg.db.Event;
import org.bedework.eventreg.db.FieldDef;
import org.bedework.eventreg.db.FormDef;
import org.bedework.eventreg.db.Registration;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class CSVOutputter
implements Logged,
Iterator<String>,
Iterable<String> {
    private final Event ev;
    private final Set<Registration> regs;
    private final FormDef form;
    private Iterator<Registration> regit;
    private final String fixedHeader = "event,date,time,location,registrationId,userid,ticketsRequested,ticketsAllocated,type,comment,created,lastmod";
    private BwLogger logger = new BwLogger();

    public CSVOutputter(Event ev, FormDef form, Set<Registration> regs) throws Throwable {
        this.ev = ev;
        this.regs = regs;
        this.form = form;
        this.regit = regs.iterator();
    }

    public String getHeader() {
        StringBuilder sb = new StringBuilder("event,date,time,location,registrationId,userid,ticketsRequested,ticketsAllocated,type,comment,created,lastmod");
        if (this.form == null) {
            return sb.toString();
        }
        FormFields ff = new FormFields(this.form.getFields());
        for (FieldDef fd : ff) {
            sb.append(",");
            sb.append(fd.getName());
        }
        return sb.toString();
    }

    @Override
    public boolean hasNext() {
        return this.regit.hasNext();
    }

    @Override
    public String next() {
        if (!this.regit.hasNext()) {
            return null;
        }
        ArrayList<Object> flds = new ArrayList<Object>();
        Registration reg = (Registration)this.regit.next();
        StringBuilder out = new StringBuilder();
        try {
            CSVPrinter csv = new CSVPrinter((Appendable)out, CSVFormat.EXCEL);
            flds.add(reg.getEvSummary());
            flds.add(reg.getEvDate());
            flds.add(reg.getEvTime());
            flds.add(reg.getEvLocation());
            flds.add(reg.getRegistrationId());
            flds.add(reg.getAuthid());
            flds.add(reg.getTicketsRequested());
            flds.add(reg.getNumTickets());
            flds.add(reg.getType());
            flds.add(reg.getComment());
            flds.add(reg.getCreated());
            flds.add(reg.getLastmod());
            if (this.form == null) {
                csv.printRecord(flds.toArray());
                csv.flush();
                csv.close();
                return out.toString();
            }
            FormFields ff = new FormFields(this.form.getFields());
            try {
                Map vals = reg.restoreFormValues();
                for (FieldDef fd : ff) {
                    Object val = vals.get(fd.getName());
                    if (val == null) {
                        flds.add("");
                        continue;
                    }
                    flds.add(val);
                }
            }
            catch (Throwable t) {
                out.append("Exception restoring form values");
            }
            csv.printRecord(flds.toArray());
            csv.flush();
            csv.close();
        }
        catch (Throwable t) {
            return "Exception " + t.getLocalizedMessage();
        }
        return out.toString();
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

