/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.service;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.http.HttpException;
import org.bedework.eventreg.common.BwConnector;
import org.bedework.eventreg.common.EventregException;
import org.bedework.eventreg.db.Event;
import org.bedework.eventreg.db.EventregDb;
import org.bedework.eventreg.db.Registration;
import org.bedework.eventreg.requests.EventChangeRequest;
import org.bedework.eventreg.requests.EventregRequest;
import org.bedework.eventreg.requests.RegistrationAction;
import org.bedework.eventreg.service.EventregProperties;
import org.bedework.eventreg.service.EventregRequestHandler;
import org.bedework.eventreg.service.SvcRequestDelayHandler;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.config.ConfigBase;
import org.bedework.util.http.Headers;
import org.bedework.util.http.PooledHttpClient;
import org.bedework.util.jms.JmsNotificationsHandlerImpl;
import org.bedework.util.jms.NotificationException;
import org.bedework.util.jms.NotificationsHandler;
import org.bedework.util.jms.events.SysEvent;
import org.bedework.util.jms.listeners.JmsSysEventListener;
import org.bedework.util.misc.AbstractProcessorThread;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.Timezones;
import org.bedework.util.xml.XmlEmit;
import org.bedework.util.xml.tagdefs.AppleServerTags;
import org.bedework.util.xml.tagdefs.BedeworkServerTags;
import org.bedework.util.xml.tagdefs.WebdavTags;

public class SvcRequestHandler
extends JmsSysEventListener
implements EventregRequestHandler {
    private final EventregDb db;
    private final EventregProperties props;
    private boolean open;
    protected StringWriter davXmlSw;
    protected XmlEmit davXml;
    protected PooledHttpClient client;
    private final URI bwUri;
    private final NotificationsHandler sender;
    private final SvcRequestDelayHandler delayHandler;
    private static final XcalUtil.TzGetter tzs = Timezones::getTz;
    private final BwConnector cnctr;
    private AbstractProcessorThread processor;

    public SvcRequestHandler(EventregProperties props) throws Throwable {
        this.props = props;
        this.db = new EventregDb();
        this.db.setSysInfo(this.getSysInfo());
        this.delayHandler = new SvcRequestDelayHandler(this, props);
        Timezones.initTimezones((String)this.getSysInfo().getTzsUri());
        this.cnctr = new BwConnector(this.getSysInfo().getWsdlUri(), tzs);
        this.sender = new JmsNotificationsHandlerImpl(props.getActionQueueName(), ConfigBase.toProperties(props.getSyseventsProperties()));
        this.bwUri = new URI(this.getSysInfo().getBwUrl());
    }

    public void action(SysEvent ev) throws NotificationException {
        if (ev == null) {
            return;
        }
        try {
            if (this.debug()) {
                this.debug("handling request: " + ev);
            }
            if (!(ev instanceof EventregRequest)) {
                return;
            }
            EventregRequest req = (EventregRequest)ev;
            boolean ok = false;
            try {
                ok = this.handle(req);
            }
            catch (Throwable t) {
                this.error("Error handling request: " + req);
                this.error(t);
            }
            if (ok) {
                if (this.debug()) {
                    this.debug("Sucess processing message.");
                }
                return;
            }
            if (this.debug()) {
                this.debug("Failed to process message. Adding to delay handler queue");
            }
            this.delayHandler.delay(req);
        }
        catch (Throwable t) {
            throw new NotificationException(t);
        }
    }

    @Override
    public void listen() {
        try {
            this.open(this.props.getActionQueueName(), ConfigBase.toProperties(this.props.getSyseventsProperties()));
            this.process(false);
        }
        catch (Throwable t) {
            this.error(t);
            throw new RuntimeException(t);
        }
    }

    @Override
    public void addRequest(EventregRequest val) throws Throwable {
        this.sender.post((SysEvent)val);
    }

    @Override
    public void close() {
        this.stop();
        super.close();
    }

    AbstractProcessorThread getProcessor() {
        return new Processor("EventregAction", this);
    }

    @Override
    public boolean isRunning() {
        if (this.processor == null) {
            return false;
        }
        if (!this.processor.isAlive()) {
            this.processor = null;
            return false;
        }
        if (this.processor.getRunning()) {
            return true;
        }
        this.processor.interrupt();
        try {
            this.processor.join(5000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.processor.isAlive()) {
            this.processor = null;
            return false;
        }
        this.warn("Processor was unstoppable. Acquiring new processor");
        this.processor = null;
        return false;
    }

    @Override
    public synchronized void start() {
        if (!this.delayHandler.isRunning()) {
            this.delayHandler.start();
        }
        if (this.isRunning()) {
            this.error("Already started");
            return;
        }
        try {
            this.processor = this.getProcessor();
        }
        catch (Throwable t) {
            this.error("Error getting processor");
            this.error(t);
            return;
        }
        this.processor.setRunning(true);
        this.processor.start();
    }

    @Override
    public synchronized void stop() {
        if (this.delayHandler.isRunning()) {
            this.delayHandler.stop();
        }
        if (this.processor == null) {
            this.error("Already stopped");
            return;
        }
        this.info("************************************************************");
        this.info(" * Stopping event reg action processor");
        this.info("************************************************************");
        this.processor.setRunning(false);
        this.processor.interrupt();
        try {
            this.processor.join(20000L);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable t) {
            this.error("Error waiting for processor termination");
            this.error(t);
        }
        this.processor = null;
        this.info("************************************************************");
        this.info(" * Event reg action processor terminated");
        this.info("************************************************************");
    }

    private boolean handle(EventregRequest request) throws Throwable {
        try {
            this.openDb();
            if (request instanceof EventChangeRequest) {
                boolean bl = this.handleChange((EventChangeRequest)request);
                return bl;
            }
            if (request instanceof RegistrationAction) {
                boolean bl = this.handleNewReg((RegistrationAction)request);
                return bl;
            }
            request.discard();
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeDb();
        }
    }

    private boolean handleChange(EventChangeRequest request) throws Throwable {
        String href = request.getHref();
        this.cnctr.flush();
        Event ev = this.cnctr.getEvent(href);
        String status = ev.getStatus();
        if (this.debug()) {
            this.debug("change: status=" + status + " for event " + ev.getSummary());
        }
        if (!"CANCELLED".equalsIgnoreCase(status)) {
            return true;
        }
        List<Registration> regs = this.db.getByEvent(href);
        if (Util.isEmpty(regs)) {
            return true;
        }
        ArrayList<String> principals = new ArrayList<String>();
        ArrayList<Registration> update = new ArrayList<Registration>();
        for (Registration reg : regs) {
            if (reg.getCancelSent()) continue;
            principals.add(reg.getAuthid());
            update.add(reg);
        }
        XmlEmit xml = this.startDavEmit();
        xml.openTag(BedeworkServerTags.eventregCancelled);
        xml.property(WebdavTags.href, href);
        xml.property(AppleServerTags.uid, UUID.randomUUID().toString());
        for (String pr : principals) {
            this.doXmlPrUrl(xml, pr);
        }
        xml.closeTag(BedeworkServerTags.eventregCancelled);
        return this.postXml(this.endDavEmit());
    }

    private boolean handleNewReg(RegistrationAction nr) throws Throwable {
        Registration reg = nr.getReg();
        String href = reg.getHref();
        Event ev = this.cnctr.getEvent(href);
        if (reg.getEmail() != null) {
            this.subscribeNotifications(reg);
        }
        XmlEmit xml = this.startDavEmit();
        xml.openTag(BedeworkServerTags.eventregRegistered);
        xml.property(WebdavTags.href, href);
        xml.property(AppleServerTags.uid, UUID.randomUUID().toString());
        xml.property(BedeworkServerTags.eventregNumTicketsRequested, String.valueOf(reg.getTicketsRequested()));
        xml.property(BedeworkServerTags.eventregNumTickets, String.valueOf(reg.getNumTickets()));
        this.doXmlPrUrl(xml, reg.getAuthid());
        xml.closeTag(BedeworkServerTags.eventregRegistered);
        return this.postXml(this.endDavEmit());
    }

    private void doXmlPrUrl(XmlEmit xml, String pr) {
        xml.openTag(WebdavTags.principalURL);
        if (pr.startsWith("/")) {
            xml.property(WebdavTags.href, pr);
        } else if (pr.startsWith("mailto:")) {
            xml.property(WebdavTags.href, pr);
        } else {
            xml.property(WebdavTags.href, "/principals/users/" + pr);
        }
        xml.closeTag(WebdavTags.principalURL);
    }

    public EventregProperties getSysInfo() {
        return this.props;
    }

    public synchronized void openDb() throws Throwable {
        if (this.db == null) {
            return;
        }
        if (this.open) {
            return;
        }
        this.db.open();
        this.open = true;
    }

    public synchronized boolean closeDb() {
        if (this.db == null) {
            return true;
        }
        this.open = false;
        return this.db.close();
    }

    protected boolean subscribeNotifications(Registration reg) throws Throwable {
        String email = reg.getEmail();
        if (email == null) {
            this.error("No email");
            return false;
        }
        XmlEmit xml = this.startDavEmit();
        xml.openTag(BedeworkServerTags.notifySubscribe);
        xml.openTag(WebdavTags.principalURL);
        xml.property(WebdavTags.href, this.makePrincipal(reg.getAuthid()));
        xml.closeTag(WebdavTags.principalURL);
        xml.property(BedeworkServerTags.action, "add");
        xml.property(BedeworkServerTags.email, email);
        xml.closeTag(BedeworkServerTags.notifySubscribe);
        return this.postXml(this.endDavEmit());
    }

    protected boolean postXml(String xml) throws EventregException {
        try {
            PooledHttpClient.ResponseHolder resp = this.getClient().postXml("", xml);
            return !resp.failed;
        }
        catch (HttpException he) {
            throw new EventregException(he);
        }
    }

    protected String makePrincipal(String id) {
        if (id.startsWith("/")) {
            return id;
        }
        if (id.startsWith("mailto:")) {
            return id;
        }
        return "/principals/users/" + id;
    }

    protected PooledHttpClient getClient() throws EventregException {
        if (this.client != null) {
            return this.client;
        }
        try {
            this.client = new PooledHttpClient(this.bwUri);
            this.client.setHeadersFetcher(this::getAuthHeaders);
            return this.client;
        }
        catch (Throwable t) {
            throw new EventregException(t);
        }
    }

    Headers getAuthHeaders() {
        String id = this.getSysInfo().getBwId();
        String token = this.getSysInfo().getBwToken();
        if (id == null || token == null) {
            return null;
        }
        Headers authheaders = new Headers();
        authheaders.add("X-BEDEWORK-NOTE", id + ":" + token);
        authheaders.add("X-BEDEWORK-EXTENSIONS", "true");
        return authheaders;
    }

    protected XmlEmit startDavEmit() throws EventregException {
        try {
            this.davXmlSw = new StringWriter();
            this.davXml = new XmlEmit();
            this.davXml.startEmit((Writer)this.davXmlSw);
            this.addNamespace(this.davXml);
            return this.davXml;
        }
        catch (Throwable t) {
            throw new EventregException(t);
        }
    }

    protected String endDavEmit() throws EventregException {
        try {
            this.davXml.flush();
            return this.davXmlSw.toString();
        }
        catch (Throwable t) {
            throw new EventregException(t);
        }
    }

    public void addNamespace(XmlEmit xml) throws EventregException {
        try {
            xml.addNs(new XmlEmit.NameSpace("DAV:", "DAV"), true);
            xml.addNs(new XmlEmit.NameSpace("urn:ietf:params:xml:ns:caldav", "C"), true);
            xml.addNs(new XmlEmit.NameSpace("http://apple.com/ns/ical/", "AI"), false);
            xml.addNs(new XmlEmit.NameSpace("http://www.w3.org/2002/12/cal/ical#", "ical"), false);
            xml.addNs(new XmlEmit.NameSpace("http://calendarserver.org/ns/", "CS"), false);
            xml.addNs(new XmlEmit.NameSpace("http://bedeworkcalserver.org/ns/", "BSS"), false);
            xml.addNs(new XmlEmit.NameSpace("http://bedework.org/ns/", "BW"), false);
        }
        catch (Throwable t) {
            throw new EventregException(t);
        }
    }

    private static class Processor
    extends AbstractProcessorThread {
        private final SvcRequestHandler handler;

        public Processor(String name, SvcRequestHandler handler) {
            super(name);
            this.handler = handler;
        }

        public void runInit() {
        }

        public void runProcess() {
            this.handler.listen();
        }

        public void end(String msg) {
        }

        public void close() {
            this.handler.close();
        }
    }
}

