/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.service;

import org.bedework.eventreg.requests.EventregRequest;
import org.bedework.eventreg.service.EventregProperties;
import org.bedework.eventreg.service.SvcRequestHandler;
import org.bedework.util.config.ConfigBase;
import org.bedework.util.jms.JmsNotificationsHandlerImpl;
import org.bedework.util.jms.NotificationException;
import org.bedework.util.jms.NotificationsHandler;
import org.bedework.util.jms.events.SysEvent;
import org.bedework.util.jms.listeners.JmsSysEventListener;
import org.bedework.util.misc.AbstractProcessorThread;
import org.bedework.util.misc.Util;

public class SvcRequestDelayHandler
extends JmsSysEventListener {
    private final EventregProperties props;
    private final SvcRequestHandler handler;
    private final NotificationsHandler sender;
    private AbstractProcessorThread processor;

    public SvcRequestDelayHandler(SvcRequestHandler handler, EventregProperties props) throws Throwable {
        this.props = props;
        this.handler = handler;
        if (props.getDelayMillis() <= 0) {
            this.warn("Bad or unset value for delayMillis: set to 30 seconds");
            props.setDelayMillis(30000);
        }
        this.sender = new JmsNotificationsHandlerImpl(props.getActionDelayQueueName(), ConfigBase.toProperties(props.getSyseventsProperties()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action(SysEvent ev) throws NotificationException {
        if (ev == null) {
            return;
        }
        try {
            if (this.debug()) {
                this.debug("handling delayed request: " + ev);
            }
            if (!(ev instanceof EventregRequest)) {
                return;
            }
            EventregRequest req = (EventregRequest)ev;
            try {
                long waitTime = req.getWaitUntil() - System.currentTimeMillis();
                if (waitTime > 0L) {
                    if (this.debug()) {
                        this.debug("Waiting " + waitTime + " millis");
                    }
                    SvcRequestDelayHandler svcRequestDelayHandler = this;
                    synchronized (svcRequestDelayHandler) {
                        ((Object)((Object)this)).wait(waitTime);
                    }
                }
                this.handler.addRequest(req);
            }
            catch (Throwable t) {
                this.error("Error handling delayed request: " + req);
                this.error(t);
            }
        }
        catch (Throwable t) {
            throw new NotificationException(t);
        }
    }

    public void close() {
        this.stop();
        super.close();
    }

    public boolean delay(EventregRequest req) throws Throwable {
        if (req.getDiscard()) {
            this.warn("Discarding: " + req);
            return false;
        }
        req.incRetries();
        int maxRetries = this.props.getRetries();
        if (maxRetries > 0 && req.getRetries() > maxRetries) {
            this.warn("Discarding - too many retries: " + req);
            return false;
        }
        req.setWaitUntil(System.currentTimeMillis() + (long)this.props.getDelayMillis());
        this.sender.post((SysEvent)req);
        return true;
    }

    public void listen() {
        try {
            this.open(this.props.getActionDelayQueueName(), ConfigBase.toProperties(this.props.getSyseventsProperties()));
            this.process(false);
            if (this.debug()) {
                this.debug("Eventregdelay returned from process");
            }
        }
        catch (Throwable t) {
            if (Util.causeIs((Throwable)t, InterruptedException.class)) {
                this.warn("Received interrupted exception");
            } else {
                this.error(t);
            }
            throw new RuntimeException(t);
        }
    }

    AbstractProcessorThread getProcessor() {
        return new Processor("EventregActionDelay", this);
    }

    public boolean isRunning() {
        if (this.processor == null) {
            return false;
        }
        if (!this.processor.isAlive()) {
            this.processor = null;
            return false;
        }
        if (this.processor.getRunning()) {
            return true;
        }
        this.processor.interrupt();
        try {
            this.processor.join(5000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.processor.isAlive()) {
            this.processor = null;
            return false;
        }
        this.warn("Processor was unstoppable. Acquiring new processor");
        this.processor = null;
        return false;
    }

    public synchronized void start() {
        if (this.isRunning()) {
            this.error("Already started");
            return;
        }
        try {
            this.processor = this.getProcessor();
        }
        catch (Throwable t) {
            this.error("Error getting processor");
            this.error(t);
            return;
        }
        this.processor.setRunning(true);
        this.processor.start();
    }

    public synchronized void stop() {
        if (this.processor == null) {
            this.error("Already stopped");
            return;
        }
        this.info("************************************************************");
        this.info(" * Stopping event reg action delay processor");
        this.info("************************************************************");
        this.processor.setRunning(false);
        this.processor.interrupt();
        try {
            this.processor.join(20000L);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable t) {
            this.error("Error waiting for processor termination");
            this.error(t);
        }
        this.processor = null;
        this.info("************************************************************");
        this.info(" * Event reg action delay processor terminated");
        this.info("************************************************************");
    }

    private static class Processor
    extends AbstractProcessorThread {
        private final SvcRequestDelayHandler handler;

        public Processor(String name, SvcRequestDelayHandler handler) {
            super(name);
            this.handler = handler;
        }

        public void runInit() {
        }

        public void runProcess() {
            this.handler.listen();
        }

        public void end(String msg) {
        }

        public void close() {
            this.handler.close();
        }
    }
}

