/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.db;

import ietf.params.xml.ns.icalendar_2.ArrayOfProperties;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.BasePropertyType;
import ietf.params.xml.ns.icalendar_2.DateDatetimePropertyType;
import ietf.params.xml.ns.icalendar_2.DtstartPropType;
import ietf.params.xml.ns.icalendar_2.IntegerPropertyType;
import ietf.params.xml.ns.icalendar_2.LocationPropType;
import ietf.params.xml.ns.icalendar_2.RecurrenceIdPropType;
import ietf.params.xml.ns.icalendar_2.StatusPropType;
import ietf.params.xml.ns.icalendar_2.SummaryPropType;
import ietf.params.xml.ns.icalendar_2.TextPropertyType;
import ietf.params.xml.ns.icalendar_2.UidPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkMaxTicketsPerUserPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkMaxTicketsPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkRegistrationEndPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkRegistrationStartPropType;
import ietf.params.xml.ns.icalendar_2.XBedeworkWaitListLimitPropType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.timezones.Timezones;

public class Event
implements Comparable<Event> {
    private final BaseComponentType comp;
    private final String href;
    private final XcalUtil.TzGetter tzs;
    private final ArrayOfProperties properties;
    private TextPinfo uid;
    private DateDatetimePinfo recurrenceId;
    private TextPinfo waitListLimit;
    private IntPinfo ticketsAllowed;
    private IntPinfo maxRegistrants;
    private DateDatetimePinfo regEnd;
    private DateDatetimePinfo regStart;
    private TextPinfo location;
    private TextPinfo summary;
    private TextPinfo status;
    private DateDatetimePinfo dtStart;

    public Event(BaseComponentType comp, String href, XcalUtil.TzGetter tzs) {
        this.comp = comp;
        this.href = href;
        this.tzs = tzs;
        this.properties = this.comp.getProperties();
    }

    public String getHref() {
        return this.href;
    }

    public String getUid() throws Throwable {
        if (this.uid == null) {
            this.uid = new TextPinfo();
            this.uid.addProperty((UidPropType)this.findProperty(UidPropType.class));
        }
        return this.uid.getValue();
    }

    public String getRecurrenceId() throws Throwable {
        if (this.recurrenceId == null) {
            this.recurrenceId = new DateDatetimePinfo();
            this.recurrenceId.addProperty((RecurrenceIdPropType)this.findProperty(RecurrenceIdPropType.class));
        }
        return this.recurrenceId.getValue();
    }

    public String getWaitListLimit() {
        if (this.waitListLimit == null) {
            this.waitListLimit = new TextPinfo();
            this.waitListLimit.addProperty((XBedeworkWaitListLimitPropType)this.findProperty(XBedeworkWaitListLimitPropType.class));
        }
        return this.waitListLimit.getValue();
    }

    public int getMaxTicketsPerUser() {
        Integer i;
        if (this.ticketsAllowed == null) {
            this.ticketsAllowed = new IntPinfo();
            this.ticketsAllowed.addProperty((XBedeworkMaxTicketsPerUserPropType)this.findProperty(XBedeworkMaxTicketsPerUserPropType.class));
        }
        if ((i = this.ticketsAllowed.getInt()) == null) {
            return -1;
        }
        return i;
    }

    public int getMaxTickets() {
        Integer i;
        if (this.maxRegistrants == null) {
            this.maxRegistrants = new IntPinfo();
            this.maxRegistrants.addProperty((XBedeworkMaxTicketsPropType)this.findProperty(XBedeworkMaxTicketsPropType.class));
        }
        if ((i = this.maxRegistrants.getInt()) == null) {
            return -1;
        }
        return i;
    }

    public String getRegistrationEnd() throws Throwable {
        XcalUtil.DtTzid dt;
        if (this.regEnd == null) {
            this.regEnd = new DateDatetimePinfo();
            this.regEnd.addProperty((XBedeworkRegistrationEndPropType)this.findProperty(XBedeworkRegistrationEndPropType.class));
        }
        if ((dt = this.regEnd.getDt()) == null) {
            return null;
        }
        return dt.dt;
    }

    public String getRegistrationEndTzid() throws Throwable {
        XcalUtil.DtTzid dt;
        if (this.regEnd == null) {
            this.regEnd = new DateDatetimePinfo();
            this.regEnd.addProperty((XBedeworkRegistrationEndPropType)this.findProperty(XBedeworkRegistrationEndPropType.class));
        }
        if ((dt = this.regEnd.getDt()) == null) {
            return null;
        }
        return dt.tzid;
    }

    public String getRegistrationStart() throws Throwable {
        XcalUtil.DtTzid dt;
        if (this.regStart == null) {
            this.regStart = new DateDatetimePinfo();
            this.regStart.addProperty((XBedeworkRegistrationStartPropType)this.findProperty(XBedeworkRegistrationStartPropType.class));
        }
        if ((dt = this.regStart.getDt()) == null) {
            return null;
        }
        return dt.dt;
    }

    public String getRegistrationStartTzid() throws Throwable {
        XcalUtil.DtTzid dt;
        if (this.regStart == null) {
            this.regStart = new DateDatetimePinfo();
            this.regStart.addProperty((XBedeworkRegistrationStartPropType)this.findProperty(XBedeworkRegistrationStartPropType.class));
        }
        if ((dt = this.regStart.getDt()) == null) {
            return null;
        }
        return dt.tzid;
    }

    public String getLocation() {
        if (this.location == null) {
            this.location = new TextPinfo();
            this.location.addProperty((LocationPropType)this.findProperty(LocationPropType.class));
        }
        return this.location.getValue();
    }

    public String getSummary() {
        if (this.summary == null) {
            this.summary = new TextPinfo();
            this.summary.addProperty((SummaryPropType)this.findProperty(SummaryPropType.class));
        }
        return this.summary.getValue();
    }

    public String getStatus() {
        if (this.status == null) {
            this.status = new TextPinfo();
            this.status.addProperty((StatusPropType)this.findProperty(StatusPropType.class));
        }
        return this.status.getValue();
    }

    public DtstartPropType getDtStartProp() throws Throwable {
        if (this.dtStart == null) {
            this.dtStart = new DateDatetimePinfo();
            this.dtStart.addProperty((DtstartPropType)this.findProperty(DtstartPropType.class));
        }
        return (DtstartPropType)this.dtStart.getProp();
    }

    public String getDate() throws Throwable {
        this.getDtStartProp();
        XcalUtil.DtTzid dt = this.dtStart.getDt();
        if (dt == null) {
            return null;
        }
        return dt.dt.substring(0, 8);
    }

    public String getDateTime() throws Throwable {
        this.getDtStartProp();
        XcalUtil.DtTzid dt = this.dtStart.getDt();
        if (dt == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(dt.dt.substring(0, 8));
        if (!dt.dateOnly) {
            sb.append(" - ");
            sb.append(dt.dt.substring(9));
            if (dt.tzid != null) {
                sb.append(" ");
                sb.append(dt.tzid);
            }
        }
        return sb.toString();
    }

    public String getTime() throws Throwable {
        this.getDtStartProp();
        XcalUtil.DtTzid dt = this.dtStart.getDt();
        if (dt == null || dt.dateOnly) {
            return null;
        }
        return dt.dt.substring(9);
    }

    public String getTzid() throws Throwable {
        this.getDtStartProp();
        XcalUtil.DtTzid dt = this.dtStart.getDt();
        if (dt == null || dt.dateOnly) {
            return null;
        }
        return dt.tzid;
    }

    public String getUtc() throws Throwable {
        this.getDtStartProp();
        return this.dtStart.getValue();
    }

    public Date getDate(String dt, String tz) throws Throwable {
        if (dt == null) {
            return null;
        }
        if (dt.length() == 8) {
            return DateTimeUtil.fromISODate((String)dt);
        }
        if (dt.endsWith("Z")) {
            return DateTimeUtil.fromISODateTimeUTC((String)dt);
        }
        if (tz == null) {
            return DateTimeUtil.fromISODateTime((String)dt);
        }
        return DateTimeUtil.fromISODateTime((String)dt, (TimeZone)Timezones.getTz((String)tz));
    }

    public Date getRegistrationEndDate() throws Throwable {
        if (this.regEnd == null) {
            this.regEnd = new DateDatetimePinfo();
            this.regEnd.addProperty((XBedeworkRegistrationEndPropType)this.findProperty(XBedeworkRegistrationEndPropType.class));
        }
        if (this.regEnd == null) {
            return null;
        }
        XcalUtil.DtTzid dt = this.regEnd.getDt();
        return this.getDate(dt.dt, dt.tzid);
    }

    public Date getRegistrationStartDate() throws Throwable {
        if (this.regStart == null) {
            this.regStart = new DateDatetimePinfo();
            this.regStart.addProperty((XBedeworkRegistrationStartPropType)this.findProperty(XBedeworkRegistrationStartPropType.class));
        }
        if (this.regEnd == null) {
            return null;
        }
        XcalUtil.DtTzid dt = this.regStart.getDt();
        return this.getDate(dt.dt, dt.tzid);
    }

    private BasePropertyType findProperty(Class<? extends BasePropertyType> cl) {
        for (JAXBElement p : this.properties.getBasePropertyOrTzid()) {
            if (!((BasePropertyType)p.getValue()).getClass().equals(cl)) continue;
            return (BasePropertyType)p.getValue();
        }
        return null;
    }

    @Override
    public int compareTo(Event that) {
        try {
            int c = this.getUtc().compareTo(that.getUtc());
            if (c != 0) {
                return c;
            }
            return this.getHref().compareTo(that.getHref());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public int hashCode() {
        return this.getHref().hashCode();
    }

    public boolean equals(Object o) {
        return ((Event)o).getHref().equals(this.getHref());
    }

    private static class TextPinfo
    extends Pinfo<TextPropertyType> {
        private TextPinfo() {
        }

        @Override
        String getValue() {
            TextPropertyType p = (TextPropertyType)this.getProp();
            if (p == null) {
                return null;
            }
            return p.getText();
        }
    }

    private class DateDatetimePinfo
    extends Pinfo<DateDatetimePropertyType> {
        private String utc;
        private XcalUtil.DtTzid dt;

        private DateDatetimePinfo() {
        }

        @Override
        String getValue() throws Throwable {
            if (this.utc != null) {
                return this.utc;
            }
            DateDatetimePropertyType p = (DateDatetimePropertyType)this.getProp();
            if (p == null) {
                return null;
            }
            if (p.getDateTime() != null) {
                this.utc = XcalUtil.getUTC((DateDatetimePropertyType)p, (XcalUtil.TzGetter)Event.this.tzs);
                return this.utc;
            }
            this.utc = XcalUtil.getIcalFormatDateTime((XMLGregorianCalendar)p.getDate()) + "T00:00:00";
            return this.utc;
        }

        XcalUtil.DtTzid getDt() throws Throwable {
            if (this.dt != null) {
                return this.dt;
            }
            DateDatetimePropertyType p = (DateDatetimePropertyType)this.getProp();
            if (p == null) {
                return null;
            }
            if (p.getDateTime() == null) {
                return null;
            }
            this.dt = XcalUtil.getDtTzid((DateDatetimePropertyType)p);
            return this.dt;
        }
    }

    private static class IntPinfo
    extends Pinfo<IntegerPropertyType> {
        private IntPinfo() {
        }

        @Override
        String getValue() {
            IntegerPropertyType p = (IntegerPropertyType)this.getProp();
            if (p == null) {
                return null;
            }
            return String.valueOf(p.getInteger());
        }

        public Integer getInt() {
            IntegerPropertyType p = (IntegerPropertyType)this.getProp();
            if (p == null) {
                return null;
            }
            return p.getInteger().intValue();
        }
    }

    private static abstract class Pinfo<T extends BasePropertyType> {
        List<T> props;

        private Pinfo() {
        }

        void addProperty(T p) {
            this.getProps().add(p);
        }

        List<T> getProps() {
            if (this.props == null) {
                this.props = new ArrayList<T>();
            }
            return this.props;
        }

        int size() {
            return this.getProps().size();
        }

        T getProp() {
            if (this.size() != 1) {
                return null;
            }
            return (T)((BasePropertyType)this.getProps().get(0));
        }

        abstract String getValue() throws Throwable;
    }
}

