/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.common;

import ietf.params.xml.ns.icalendar_2.ArrayOfComponents;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.VcalendarType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.bedework.eventreg.db.Event;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.oasis_open.docs.ws_calendar.ns.soap.CalWsService;
import org.oasis_open.docs.ws_calendar.ns.soap.CalWsServicePortType;
import org.oasis_open.docs.ws_calendar.ns.soap.FetchItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.FetchItemType;
import org.oasis_open.docs.ws_calendar.ns.soap.ObjectFactory;

public class BwConnector
implements Logged {
    private final XcalUtil.TzGetter tzs;
    private final String wsdlUri;
    private final Map<String, Event> events = new HashMap<String, Event>();
    protected ObjectFactory of = new ObjectFactory();
    protected JAXBContext jc;
    private final BwLogger logger = new BwLogger();

    public BwConnector(String wsdlUri, XcalUtil.TzGetter tzs) {
        this.wsdlUri = wsdlUri;
        this.tzs = tzs;
    }

    public void flush() {
        this.events.clear();
    }

    public Event getEvent(String href) {
        Event ev = this.events.get(href);
        if (ev != null) {
            return ev;
        }
        FetchItemResponseType fir = this.fetchItem(href);
        if (fir == null || fir.getIcalendar() == null || fir.getIcalendar().getVcalendar().size() != 1 || ((VcalendarType)fir.getIcalendar().getVcalendar().get(0)).getComponents() == null) {
            return null;
        }
        ArrayOfComponents aoc = ((VcalendarType)fir.getIcalendar().getVcalendar().get(0)).getComponents();
        ArrayList<BaseComponentType> comps = new ArrayList<BaseComponentType>();
        for (JAXBElement comp : aoc.getBaseComponent()) {
            comps.add((BaseComponentType)comp.getValue());
        }
        if (comps.size() != 1) {
            return null;
        }
        ev = new Event((BaseComponentType)comps.get(0), href, this.tzs);
        this.events.put(href, ev);
        return ev;
    }

    public FetchItemResponseType fetchItem(String href) {
        FetchItemType fi = new FetchItemType();
        fi.setHref(href);
        return this.getPort().fetchItem(fi);
    }

    protected CalWsServicePortType getPort() {
        return this.getPort(this.wsdlUri);
    }

    protected CalWsServicePortType getPort(String uri) {
        URL wsURL;
        try {
            wsURL = new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        CalWsService svc = new CalWsService(wsURL, new QName("http://docs.oasis-open.org/ws-calendar/ns/soap", "CalWsService"));
        CalWsServicePortType port = svc.getCalWsPort();
        return port;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

