/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.db;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.bedework.eventreg.common.EventregException;
import org.bedework.eventreg.db.DbItem;
import org.bedework.eventreg.db.Event;
import org.bedework.eventreg.db.SerializableProperties;
import org.bedework.eventreg.db.Ticket;
import org.bedework.util.misc.ToString;

public class Registration
extends DbItem<Registration> {
    private Long registrationId;
    private String authid;
    private String email;
    private String href;
    private int ticketsRequested;
    private String type;
    private String created;
    private String lastmod;
    private String waitqDate;
    private String comment;
    private String message;
    private String formName;
    private String formOwner;
    private String evSummary;
    private String evDate;
    private String evTime;
    private String evLocation;
    private String notificationTimestamp;
    private Set<Ticket> tickets;
    public static final String typeRegistered = "reg";
    public static final String typeHold = "hold";
    private Event event;

    public void setRegistrationId(Long val) {
        this.registrationId = val;
    }

    public Long getRegistrationId() {
        return this.registrationId;
    }

    public void setAuthid(String val) {
        this.authid = val;
    }

    public String getAuthid() {
        return this.authid;
    }

    public void setEmail(String val) {
        this.email = val;
    }

    public String getEmail() {
        return this.email;
    }

    public void setHref(String val) {
        this.href = val;
    }

    public String getHref() {
        return this.href;
    }

    public void setTicketsRequested(int val) {
        this.ticketsRequested = val;
    }

    public int getTicketsRequested() {
        return this.ticketsRequested;
    }

    public void setType(String val) {
        this.type = val;
    }

    public String getType() {
        return this.type;
    }

    public void setCreated(String val) {
        this.created = val;
    }

    public String getCreated() {
        return this.created;
    }

    public void setLastmod(String val) {
        this.lastmod = val;
    }

    public String getLastmod() {
        return this.lastmod;
    }

    public void setWaitqDate(String val) {
        this.waitqDate = val;
    }

    public String getWaitqDate() {
        return this.waitqDate;
    }

    public void setComment(String val) {
        this.comment = val;
    }

    public String getComment() {
        return this.comment;
    }

    public void setMessage(String val) {
        this.message = val;
    }

    public String getMessage() {
        return this.message;
    }

    public void setFormName(String val) {
        this.formName = val;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormOwner(String val) {
        this.formOwner = val;
    }

    public String getFormOwner() {
        return this.formOwner;
    }

    public void setTickets(Set<Ticket> val) {
        this.tickets = val;
    }

    public Set<Ticket> getTickets() {
        return this.tickets;
    }

    public String getEvSummary() {
        return this.evSummary;
    }

    public void setEvSummary(String evSummary) {
        this.evSummary = evSummary;
    }

    public String getEvDate() {
        return this.evDate;
    }

    public void setEvDate(String evDate) {
        this.evDate = evDate;
    }

    public String getEvTime() {
        return this.evTime;
    }

    public void setEvTime(String evTime) {
        this.evTime = evTime;
    }

    public String getEvLocation() {
        return this.evLocation;
    }

    public void setEvLocation(String evLocation) {
        this.evLocation = evLocation;
    }

    public String getNotificationTimestamp() {
        return this.notificationTimestamp;
    }

    public void setNotificationTimestamp(String notificationTimestamp) {
        this.notificationTimestamp = notificationTimestamp;
    }

    public void setCancelSent(boolean val) {
        this.setBoolean("cancelSent", val);
    }

    public boolean getCancelSent() throws EventregException {
        return this.mayBool("cancelSent");
    }

    public void setFormValues(String val) {
        this.setString("formValues", val);
    }

    public String getFormValues() throws EventregException {
        return this.may("formValues");
    }

    public void setEvent(Event val) {
        this.event = val;
    }

    public Event getEvent() {
        return this.event;
    }

    public void saveFormValues(Map vals) throws EventregException {
        SerializableProperties sp = new SerializableProperties();
        sp.init(vals);
        this.setFormValues(sp.asString());
    }

    public Map restoreFormValues() throws EventregException {
        SerializableProperties sp = new SerializableProperties();
        return sp.asMap(this.getFormValues());
    }

    public void setTimestamps() {
        Timestamp sqlDate = new Timestamp(new Date().getTime());
        this.setCreated(sqlDate.toString());
        this.setLastmod(this.getCreated());
        this.setWaitqDate(this.getCreated());
    }

    public void setLastmod() {
        Timestamp sqlDate = new Timestamp(new Date().getTime());
        this.setLastmod(sqlDate.toString());
    }

    public void setWaitqDate() {
        Timestamp sqlDate = new Timestamp(new Date().getTime());
        this.setLastmod(sqlDate.toString());
    }

    @Override
    protected void toStringSegment(ToString ts) {
        try {
            super.toStringSegment(ts);
            ts.append("registrationId", this.getRegistrationId());
            ts.append("authid", (Object)this.getAuthid());
            ts.append("email", (Object)this.getEmail());
            ts.append("href", (Object)this.getHref());
            ts.append("ticketsRequested", this.getTicketsRequested());
            ts.append("type", (Object)this.getType());
            ts.append("created", (Object)this.getCreated());
            ts.append("lastmod", (Object)this.getLastmod());
            ts.append("waitqDate", (Object)this.getWaitqDate());
            ts.append("comment", (Object)this.getComment());
            ts.append("message", (Object)this.getMessage());
            ts.append("numTickets", this.getNumTickets());
            ts.append("cancelSent", this.getCancelSent());
        }
        catch (Throwable t) {
            ts.append("exception", (Object)t.getLocalizedMessage());
        }
    }

    public void addTicket(Ticket val) {
        Set<Ticket> ts = this.getTickets();
        if (ts == null) {
            ts = new TreeSet<Ticket>();
            this.setTickets(ts);
        }
        ts.add(val);
    }

    public void addTicket() {
        Ticket t = new Ticket();
        t.setRegistrationId(this.getRegistrationId());
        t.setAuthid(this.getAuthid());
        t.setHref(this.getHref());
        t.setUuid(UUID.randomUUID().toString());
        t.setCreated(new Timestamp(new Date().getTime()).toString());
        this.addTicket(t);
    }

    public void addTickets(int numTickets) {
        for (int i = 0; i < numTickets; ++i) {
            this.addTicket();
        }
    }

    public void removeTicket(Ticket val) {
        Set<Ticket> ts = this.getTickets();
        if (ts == null) {
            return;
        }
        ts.remove(val);
    }

    public void removeTickets(int numTickets) {
        if (this.getTickets() == null) {
            return;
        }
        for (int i = 0; i < numTickets; ++i) {
            Ticket t = this.getTickets().iterator().next();
            this.getTickets().remove(t);
        }
    }

    public int getNumTickets() {
        Set<Ticket> ts = this.getTickets();
        if (ts == null) {
            return 0;
        }
        return ts.size();
    }

    @Override
    public int compareTo(Registration that) {
        return this.getRegistrationId().compareTo(that.getRegistrationId());
    }

    @Override
    public int hashCode() {
        return this.getRegistrationId().hashCode();
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }
}

