/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.common;

import ietf.params.xml.ns.icalendar_2.ArrayOfComponents;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.VcalendarType;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import org.bedework.eventreg.db.Event;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.oasis_open.docs.ws_calendar.ns.soap.CalWsService;
import org.oasis_open.docs.ws_calendar.ns.soap.CalWsServicePortType;
import org.oasis_open.docs.ws_calendar.ns.soap.FetchItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.FetchItemType;
import org.oasis_open.docs.ws_calendar.ns.soap.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BwConnector
implements Logged {
    private final XcalUtil.TzGetter tzs;
    private static final ietf.params.xml.ns.icalendar_2.ObjectFactory icalOf = new ietf.params.xml.ns.icalendar_2.ObjectFactory();
    private final String wsdlUri;
    private final Map<String, Event> events = new HashMap<String, Event>();
    protected ObjectFactory of = new ObjectFactory();
    protected MessageFactory soapMsgFactory;
    protected JAXBContext jc;
    private BwLogger logger = new BwLogger();

    public BwConnector(String wsdlUri, XcalUtil.TzGetter tzs) {
        this.wsdlUri = wsdlUri;
        this.tzs = tzs;
    }

    public void flush() {
        this.events.clear();
    }

    public Event getEvent(String href) throws Throwable {
        Event ev = this.events.get(href);
        if (ev != null) {
            return ev;
        }
        FetchItemResponseType fir = this.fetchItem(href);
        if (fir == null || fir.getIcalendar() == null || fir.getIcalendar().getVcalendar().size() != 1 || ((VcalendarType)fir.getIcalendar().getVcalendar().get(0)).getComponents() == null) {
            return null;
        }
        ArrayOfComponents aoc = ((VcalendarType)fir.getIcalendar().getVcalendar().get(0)).getComponents();
        ArrayList<Object> comps = new ArrayList<Object>();
        for (JAXBElement comp : aoc.getBaseComponent()) {
            comps.add(comp.getValue());
        }
        if (comps.size() != 1) {
            return null;
        }
        ev = new Event((BaseComponentType)comps.get(0), href, this.tzs);
        this.events.put(href, ev);
        return ev;
    }

    public FetchItemResponseType fetchItem(String href) throws Throwable {
        FetchItemType fi = new FetchItemType();
        fi.setHref(href);
        return this.getPort().fetchItem(fi);
    }

    protected ietf.params.xml.ns.icalendar_2.ObjectFactory getIcalObjectFactory() {
        return icalOf;
    }

    protected CalWsServicePortType getPort() throws Throwable {
        return this.getPort(this.wsdlUri);
    }

    protected CalWsServicePortType getPort(String uri) throws Throwable {
        URL wsURL = new URL(uri);
        CalWsService svc = new CalWsService(wsURL, new QName("http://docs.oasis-open.org/ws-calendar/ns/soap", "CalWsService"));
        CalWsServicePortType port = svc.getCalWsPort();
        return port;
    }

    protected Object unmarshalBody(HttpServletRequest req) throws Throwable {
        SOAPMessage msg = this.getSoapMsgFactory().createMessage(null, (InputStream)req.getInputStream());
        SOAPBody body = msg.getSOAPBody();
        Unmarshaller u = this.getSynchJAXBContext().createUnmarshaller();
        Object o = u.unmarshal(body.getFirstChild());
        if (o instanceof JAXBElement) {
            o = ((JAXBElement)o).getValue();
        }
        return o;
    }

    protected void marshal(Object o, OutputStream out) throws Throwable {
        Marshaller marshaller = this.jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().newDocument();
        SOAPMessage msg = this.soapMsgFactory.createMessage();
        msg.getSOAPBody().addDocument(doc);
        marshaller.marshal(o, (Node)msg.getSOAPBody());
        msg.writeTo(out);
    }

    protected MessageFactory getSoapMsgFactory() throws Throwable {
        if (this.soapMsgFactory == null) {
            this.soapMsgFactory = MessageFactory.newInstance();
        }
        return this.soapMsgFactory;
    }

    JAXBContext getSynchJAXBContext() throws Throwable {
        if (this.jc == null) {
            this.jc = JAXBContext.newInstance((String)"org.bedework.synch.wsmessages:ietf.params.xml.ns.icalendar_2");
        }
        return this.jc;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

