/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.db;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.eventreg.common.EventregException;
import org.bedework.eventreg.db.DbItem;
import org.bedework.eventreg.db.FieldDef;
import org.bedework.util.misc.ToString;

public class FormDef
extends DbItem<FormDef> {
    private String formName;
    private String owner;
    private boolean committed;
    private boolean disabled;
    private String created;
    private String lastmod;
    private String comment;
    private Set<FieldDef> fields;

    public void setFormName(String val) {
        this.formName = val;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setOwner(String val) {
        this.owner = val;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setCommitted(boolean val) {
        this.committed = val;
    }

    public boolean getCommitted() {
        return this.committed;
    }

    public void setDisabled(boolean val) {
        this.disabled = val;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setCreated(String val) {
        this.created = val;
    }

    public String getCreated() {
        return this.created;
    }

    public void setLastmod(String val) {
        this.lastmod = val;
    }

    public String getLastmod() {
        return this.lastmod;
    }

    public void setComment(String val) {
        this.comment = val;
    }

    public String getComment() {
        return this.comment;
    }

    public void setFields(Set<FieldDef> val) {
        this.fields = val;
    }

    public Set<FieldDef> getFields() {
        return this.fields;
    }

    public void setWaitListLimit(String val) throws EventregException {
        String checkVal = val.endsWith("%") ? val.substring(0, val.length() - 1) : val;
        try {
            Integer.valueOf(checkVal);
        }
        catch (Throwable ignored) {
            throw new EventregException("invalid wait list limit" + val);
        }
        this.setString("waitListLimit", val);
    }

    public String getWaitListLimit() throws EventregException {
        return this.may("waitListLimit");
    }

    public void addField(FieldDef val) {
        Set<FieldDef> ts = this.getFields();
        if (ts == null) {
            ts = new TreeSet<FieldDef>();
            this.setFields(ts);
        }
        ts.add(val);
    }

    public void removeField(FieldDef val) {
        Set<FieldDef> ts = this.getFields();
        if (ts == null) {
            return;
        }
        ts.remove(val);
    }

    public void setTimestamps() {
        Timestamp sqlDate = new Timestamp(new Date().getTime());
        this.setCreated(sqlDate.toString());
        this.setLastmod(this.getCreated());
    }

    public void setLastmod() {
        Timestamp sqlDate = new Timestamp(new Date().getTime());
        this.setLastmod(sqlDate.toString());
    }

    @Override
    protected void toStringSegment(ToString ts) {
        try {
            super.toStringSegment(ts);
            ts.append("formName", (Object)this.getFormName());
            ts.append("owner", (Object)this.getOwner());
            ts.append("committed", this.getCommitted());
            ts.append("created", (Object)this.getCreated());
            ts.append("lastmod", (Object)this.getLastmod());
            ts.append("comment", (Object)this.getComment());
        }
        catch (Throwable t) {
            ts.append("exception", (Object)t.getLocalizedMessage());
        }
    }

    @Override
    public int compareTo(FormDef that) {
        int cmp = this.getFormName().compareTo(that.getFormName());
        if (cmp != 0) {
            return cmp;
        }
        return this.getOwner().compareTo(that.getOwner());
    }

    @Override
    public int hashCode() {
        return this.getFormName().hashCode() * this.getOwner().hashCode();
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }
}

