/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.db;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bedework.eventreg.common.EventregException;
import org.bedework.eventreg.db.JsonUtil;

public class SerializableProperties {
    private static final ObjectMapper om = new ObjectMapper();
    protected Map vals;

    protected SerializableProperties() {
    }

    public void init(Map vals) throws EventregException {
        this.vals = vals;
    }

    public void setProperties(String val) throws EventregException {
        this.vals = val == null ? new HashMap() : this.asMap(val);
    }

    @JsonIgnore
    public String getProperties() throws EventregException {
        return this.asString();
    }

    @JsonIgnore
    public Map getVals() {
        if (this.vals == null) {
            this.vals = new HashMap();
        }
        return this.vals;
    }

    protected Map<?, ?> asMap(String val) throws EventregException {
        try {
            this.init((Map)om.readValue(val, Object.class));
            return this.vals;
        }
        catch (Throwable t) {
            throw new EventregException(t);
        }
    }

    protected String asString() throws EventregException {
        StringWriter sw = new StringWriter();
        try {
            om.writeValue((Writer)sw, (Object)this.getVals());
            return sw.toString();
        }
        catch (Throwable t) {
            throw new EventregException(t);
        }
    }

    @JsonIgnore
    protected Map<?, ?> getMap(String name) throws EventregException {
        Object val = this.getVals().get(name);
        if (val == null) {
            throw new EventregException("missing value: " + name);
        }
        try {
            return (Map)val;
        }
        catch (Throwable t) {
            throw new EventregException(t);
        }
    }

    public void setBoolean(String name, Boolean val) {
        this.getVals().put(name, val);
    }

    public void setInt(String name, Integer val) {
        this.getVals().put(name, val);
    }

    public void setString(String name, String val) {
        if (val == null) {
            this.getVals().remove(name);
        } else {
            this.getVals().put(name, val);
        }
    }

    public void setObject(String name, Object val) {
        if (val == null) {
            this.getVals().remove(name);
        } else {
            this.getVals().put(name, val);
        }
    }

    public String must(String name) throws EventregException {
        return JsonUtil.must(name, this.getVals());
    }

    public List<String> mustList(String name) throws EventregException {
        return JsonUtil.mustList(name, this.getVals());
    }

    public String may(String name) throws EventregException {
        return JsonUtil.may(name, this.getVals());
    }

    public List mayList(String name) throws EventregException {
        return JsonUtil.mayList(name, this.getVals());
    }

    public List mayList(String name, Map theVals) throws EventregException {
        return JsonUtil.mayList(name, theVals);
    }

    protected int mayInt(String name) throws EventregException {
        Object val = this.getVals().get(name);
        if (val == null) {
            return 0;
        }
        try {
            return (Integer)val;
        }
        catch (Throwable t) {
            throw new EventregException(t);
        }
    }

    protected boolean mayBool(String name) throws EventregException {
        Object val = this.getVals().get(name);
        if (val == null) {
            return false;
        }
        try {
            return (Boolean)val;
        }
        catch (Throwable t) {
            throw new EventregException(t);
        }
    }
}

