/* ********************************************************************
    Licensed to Jasig under one or more contributor license
    agreements. See the NOTICE file distributed with this work
    for additional information regarding copyright ownership.
    Jasig licenses this file to you under the Apache License,
    Version 2.0 (the "License"); you may not use this file
    except in compliance with the License. You may obtain a
    copy of the License at:

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied. See the License for the
    specific language governing permissions and limitations
    under the License.
*/
package org.bedework.eventreg.db;

import org.bedework.util.misc.ToString;

import java.io.Serializable;

/** Simple base class for database entities
 *
 * @author Mike Douglass
 *
 * @param <T>
 */
public class DbItem<T> extends SerializableProperties
        implements Comparable<T>, Serializable {
  // hibernate
  private Long id;

  // hibernate
  private int seq;

  /** null constructor for hibernate
   *
   */
  public DbItem() {
  }

  /**
   * @param val the id
   */
  public void setId(final Long val) {
    id = val;
  }

  /**
   * @return Long id
   */
  public Long getId() {
    return id;
  }

  /**
   * @return true if this entity is not saved.
   */
  public boolean unsaved() {
    return getId() == null;
  }

  /** Set the seq for this entity
   *
   * @param val    int seq
   */
  public void setSeq(final Integer val) {
    seq = val;
  }

  /** Get the entity seq
   *
   * @return int    the entity seq
   */
  public Integer getSeq() {
    return seq;
  }

  /* ====================================================================
   *                   Convenience methods
   * ==================================================================== */

  /** Add our stuff to the StringBuilder
   *
   * @param ts    StringBuilder for result
   */
  protected void toStringSegment(final ToString ts) {
    ts.append("id", getId());
    ts.append("seq", getSeq());
  }

  /* ====================================================================
   *                   Object methods
   * The following are required for a db object.
   * ==================================================================== */

  /** Make visible
   * @return Object of class T
   */
  @Override
  public Object clone() {
    return null;
  }

  /* (non-Javadoc)
   * @see java.lang.Comparable#compareTo(java.lang.Object)
   */
  @Override
  public int compareTo(final T o) {
    throw new RuntimeException("compareTo must be implemented for a db object");
  }

  @Override
  public int hashCode() {
    throw new RuntimeException("hashcode must be implemented for a db object");
  }

  @SuppressWarnings("unchecked")
  @Override
  public boolean equals(final Object o) {
    if (this == o) {
      return true;
    }

    return compareTo((T)o) == 0;
  }
}
