/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.eventreg.db;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.bedework.eventreg.db.Change;
import org.bedework.eventreg.db.DbItem;
import org.bedework.eventreg.db.FormDef;
import org.bedework.eventreg.db.RegId;
import org.bedework.eventreg.db.Registration;
import org.bedework.eventreg.db.Ticket;
import org.bedework.eventreg.service.EventregProperties;
import org.bedework.util.hibernate.HibException;
import org.bedework.util.hibernate.HibSession;
import org.bedework.util.hibernate.HibSessionFactory;
import org.bedework.util.hibernate.HibSessionImpl;
import org.bedework.util.misc.Logged;

public class EventregDb
extends Logged
implements Serializable {
    private static final int defaultRegidBatchSize = 50;
    private static final AtomicLong nextRegid = new AtomicLong();
    private static long lastRegid = -1L;
    protected boolean open;
    protected Timestamp objTimestamp;
    protected HibSession sess;
    private EventregProperties sysInfo;
    private static final String getWaitingTicketCountQuery = "select sum(ticketsRequested) from " + Registration.class.getName() + " reg where reg.href=:href";
    private final String getWaitingQuery = "from " + Registration.class.getName() + " reg where reg.href=:href and size(reg.tickets) < reg.ticketsRequested order by reg.waitqDate";
    private final String getTicketCountQuery = "select count(*) from " + Ticket.class.getName() + " tkt where tkt.href=:href";
    private static final String getUserTicketCountQuery = "select count(*) from " + Ticket.class.getName() + " tkt where tkt.href=:href and tkt.authid=:user";
    private static final String getCalSuiteFormsQuery = "from " + FormDef.class.getName() + " form where form.owner=:owner";
    private static final String getCalSuiteFormQuery = "from " + FormDef.class.getName() + " form where form.owner=:owner and form.formName=:formName";
    private static final String maxRegistrationIdQuery = "select max(registrationId) from " + Registration.class.getName() + " reg";
    private static final String regIdQuery = "from " + RegId.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextRegistrationId() throws Throwable {
        AtomicLong atomicLong = nextRegid;
        synchronized (atomicLong) {
            int attempts = 0;
            while (lastRegid < 0L || nextRegid.longValue() > lastRegid) {
                IdBatch batch = EventregDb.getIdBatch(this.sysInfo);
                if (batch != null) {
                    nextRegid.set(batch.start);
                    lastRegid = batch.end;
                    break;
                }
                this.warn("Error trying to get regid batch after " + attempts + " tries.");
                long wait = ++attempts * 500;
                this.warn("Retrying in " + wait + " millisecs");
                try {
                    this.wait(wait);
                }
                catch (InterruptedException ie) {
                    return null;
                }
            }
        }
        return nextRegid.getAndIncrement();
    }

    public void setSysInfo(EventregProperties sysInfo) {
        this.sysInfo = sysInfo;
    }

    public boolean open() throws Throwable {
        if (this.isOpen()) {
            return false;
        }
        this.openSession();
        this.open = true;
        return true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean rollback() throws Throwable {
        if (!this.isOpen()) {
            return false;
        }
        this.rollbackTransaction();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        boolean ok = true;
        try {
            this.endTransaction();
        }
        catch (Throwable t) {
            ok = false;
            try {
                this.rollbackTransaction();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.error(t);
        }
        finally {
            try {
                this.closeSession();
            }
            catch (Exception wde1) {
                ok = false;
            }
            this.open = false;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean ignoreErrors) {
        boolean ok = true;
        try {
            this.endTransaction();
        }
        catch (Throwable t) {
            ok = false;
            try {
                this.rollbackTransaction();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!ignoreErrors) {
                this.error(t);
            }
        }
        finally {
            try {
                this.closeSession();
            }
            catch (Exception wde1) {
                ok = false;
            }
            this.open = false;
        }
        return ok;
    }

    public void addChange(Change c) throws Throwable {
        try {
            this.sess.save((Object)c);
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public List<Change> getChanges(String ts) throws Throwable {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("from ");
            sb.append(Change.class.getName());
            sb.append(" chg");
            if (ts != null) {
                sb.append(" where chg.lastmod>:lm");
            }
            sb.append(" order by chg.lastmod");
            this.sess.createQuery(sb.toString());
            if (ts != null) {
                this.sess.setString("lm", ts);
            }
            return this.sess.getList();
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public List<Registration> getAllRegistrations() throws Throwable {
        StringBuilder sb = new StringBuilder();
        sb.append("from ");
        sb.append(Registration.class.getName());
        try {
            this.sess.createQuery(sb.toString());
            return this.sess.getList();
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public Registration getByid(Long id) throws Throwable {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("from ");
            sb.append(Registration.class.getName());
            sb.append(" reg where reg.registrationId=:id");
            this.sess.createQuery(sb.toString());
            this.sess.setLong("id", id.longValue());
            return (Registration)this.sess.getUnique();
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public List<Registration> getByUser(String user) throws Throwable {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("from ");
            sb.append(Registration.class.getName());
            sb.append(" reg where reg.authid=:user");
            sb.append(" and reg.type=:type");
            this.sess.createQuery(sb.toString());
            this.sess.setString("user", user);
            this.sess.setString("type", "reg");
            return this.sess.getList();
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public Registration getUserRegistration(String eventHref, String user) throws Throwable {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("from ");
            sb.append(Registration.class.getName());
            sb.append(" reg where reg.href=:href");
            sb.append(" and reg.authid=:user");
            sb.append(" and reg.type=:type");
            this.sess.createQuery(sb.toString());
            this.sess.setString("href", eventHref);
            this.sess.setString("user", user);
            this.sess.setString("type", "reg");
            return (Registration)this.sess.getUnique();
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public List<Registration> getByEvent(String href) throws Throwable {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("from ");
            sb.append(Registration.class.getName());
            sb.append(" reg where reg.href=:href");
            this.sess.createQuery(sb.toString());
            this.sess.setString("href", href);
            return this.sess.getList();
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public long getRegistrantCount(String eventHref) throws Throwable {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("select count(*) from ");
            sb.append(Registration.class.getName());
            sb.append(" reg where reg.href=:href");
            sb.append(" and reg.type=:type");
            this.sess.createQuery(sb.toString());
            this.sess.setString("href", eventHref);
            this.sess.setString("type", "reg");
            List counts = this.sess.getList();
            long total = 0L;
            for (Long l : counts) {
                total += l.longValue();
            }
            return total;
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public long getRegTicketCount(String eventHref) throws Throwable {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("select size(tickets) from ");
            sb.append(Registration.class.getName());
            sb.append(" reg where reg.href=:href");
            this.sess.createQuery(sb.toString());
            this.sess.setString("href", eventHref);
            List cts = this.sess.getList();
            if (cts == null) {
                return 0L;
            }
            Long ct = 0L;
            for (Integer i : cts) {
                ct = ct + (long)i.intValue();
            }
            return ct;
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public long getWaitingTicketCount(String eventHref) throws Throwable {
        try {
            this.sess.createQuery(getWaitingTicketCountQuery);
            this.sess.setString("href", eventHref);
            Long ct = (Long)this.sess.getUnique();
            if (this.debug) {
                this.debug("Count returned " + ct);
            }
            if (ct == null) {
                return 0L;
            }
            return Math.max(0L, ct - this.getTicketCount(eventHref));
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public List<Registration> getWaiting(String eventHref) throws Throwable {
        try {
            this.sess.createQuery(this.getWaitingQuery);
            this.sess.setString("href", eventHref);
            return this.sess.getList();
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public long getTicketCount(String eventHref) throws Throwable {
        try {
            this.sess.createQuery(this.getTicketCountQuery);
            this.sess.setString("href", eventHref);
            Long ct = (Long)this.sess.getUnique();
            if (this.debug) {
                this.debug("Count returned " + ct);
            }
            if (ct == null) {
                return 0L;
            }
            return ct;
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public long getUserTicketCount(String eventHref, String user) throws Throwable {
        try {
            this.sess.createQuery(getUserTicketCountQuery);
            this.sess.setString("href", eventHref);
            this.sess.setString("user", user);
            List counts = this.sess.getList();
            long total = 0L;
            for (Long l : counts) {
                total += l.longValue();
            }
            return total;
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public List<FormDef> getCalSuiteForms(String calsuite) throws Throwable {
        this.sess.createQuery(getCalSuiteFormsQuery);
        this.sess.setString("owner", calsuite);
        return this.sess.getList();
    }

    public FormDef getCalSuiteForm(String formName, String calsuite) throws Throwable {
        this.sess.createQuery(getCalSuiteFormQuery);
        this.sess.setString("formName", formName);
        this.sess.setString("owner", calsuite);
        return (FormDef)this.sess.getUnique();
    }

    public void add(DbItem val) throws Exception {
        try {
            this.sess.save((Object)val);
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public void update(DbItem val) throws Exception {
        try {
            this.sess.update((Object)val);
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    public void delete(DbItem val) throws Throwable {
        boolean opened = this.open();
        try {
            this.sess.delete((Object)val);
        }
        catch (HibException he) {
            throw new Exception(he);
        }
        finally {
            if (opened) {
                this.close();
            }
        }
    }

    protected void checkOpen() throws Throwable {
        if (!this.isOpen()) {
            throw new Exception("Session call when closed");
        }
    }

    protected synchronized void openSession() throws Throwable {
        if (this.isOpen()) {
            throw new Exception("Already open");
        }
        this.open = true;
        if (this.sess != null) {
            this.warn("Session is not null. Will close");
            this.close();
        }
        if (this.sess == null) {
            if (this.debug) {
                this.debug("New hibernate session for " + this.objTimestamp);
            }
            this.sess = new HibSessionImpl();
            try {
                this.sess.init(HibSessionFactory.getSessionFactory((List)this.sysInfo.getHibernateProperties()));
            }
            catch (HibException he) {
                throw new Exception(he);
            }
            if (this.debug) {
                this.debug("Open session for " + this.objTimestamp);
            }
        }
        this.beginTransaction();
    }

    protected synchronized void closeSession() throws Exception {
        if (!this.isOpen()) {
            if (this.debug) {
                this.debug("Close for " + this.objTimestamp + " closed session");
            }
            return;
        }
        if (this.debug) {
            this.debug("Close for " + this.objTimestamp);
        }
        try {
            if (this.sess != null) {
                if (this.sess.rolledback()) {
                    this.sess = null;
                    return;
                }
                if (this.sess.transactionStarted()) {
                    this.sess.rollback();
                }
                this.sess.close();
                this.sess = null;
            }
        }
        catch (Throwable t) {
            try {
                this.sess.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.sess = null;
        }
        finally {
            this.open = false;
        }
    }

    protected void beginTransaction() throws Throwable {
        this.checkOpen();
        if (this.debug) {
            this.debug("Begin transaction for " + this.objTimestamp);
        }
        try {
            this.sess.beginTransaction();
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    protected void endTransaction() throws Throwable {
        this.checkOpen();
        if (this.debug) {
            this.debug("End transaction for " + this.objTimestamp);
        }
        try {
            if (!this.sess.rolledback()) {
                this.sess.commit();
            }
        }
        catch (HibException he) {
            this.sess.rollback();
            throw new Exception(he);
        }
    }

    protected void rollbackTransaction() throws Throwable {
        try {
            this.checkOpen();
            this.sess.rollback();
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    private Long getMaxRegistrationId() throws Throwable {
        try {
            this.sess.createQuery(maxRegistrationIdQuery);
            return (Long)this.sess.getUnique();
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    private RegId getRegId() throws Throwable {
        try {
            this.sess.createQuery(regIdQuery);
            return (RegId)this.sess.getUnique();
        }
        catch (HibException he) {
            throw new Exception(he);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IdBatch getIdBatch(EventregProperties sysInfo) throws Throwable {
        EventregDb nidDb = new EventregDb();
        long regidBatchSize = sysInfo.getRegidBatchSize();
        if (regidBatchSize == 0L) {
            regidBatchSize = 50L;
        }
        nidDb.setSysInfo(sysInfo);
        try {
            String op;
            nidDb.open();
            RegId regId = nidDb.getRegId();
            IdBatch batch = new IdBatch();
            if (regId == null) {
                batch.start = nidDb.getMaxRegistrationId();
                batch.start = batch.start == null ? Long.valueOf(1L) : Long.valueOf(batch.start + 100L);
                regId = new RegId();
                op = "add";
            } else {
                batch.start = regId.getNextRegistrationId();
                op = "update";
            }
            batch.end = batch.start + regidBatchSize - 1L;
            regId.setNextRegistrationId(batch.end + 1L);
            try {
                if ("add".equals(op)) {
                    nidDb.add(regId);
                } else {
                    nidDb.update(regId);
                }
            }
            catch (Throwable t) {
                nidDb.warn("Exception trying to " + op + " id batch record");
                nidDb.warn("Message was " + t.getMessage());
                IdBatch idBatch = null;
                try {
                    nidDb.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return idBatch;
            }
            IdBatch idBatch = batch;
            return idBatch;
        }
        finally {
            try {
                nidDb.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static class IdBatch {
        Long start;
        Long end;

        private IdBatch() {
        }
    }
}

