/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webdav.servlet.shared;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import org.bedework.util.misc.Util;
import org.bedework.webdav.servlet.shared.UrlPrefixer;
import org.bedework.webdav.servlet.shared.UrlUnprefixer;

public class UrlHandler
implements UrlPrefixer,
UrlUnprefixer {
    private String urlPrefix;
    private final boolean relative;
    private String context;

    public UrlHandler(HttpServletRequest req, boolean relative) {
        String sp;
        this.relative = relative;
        String contextPath = req.getContextPath();
        if (contextPath == null || contextPath.equals(".")) {
            contextPath = "/";
        }
        if ((sp = req.getServletPath()) == null || sp.equals(".")) {
            sp = "/";
        }
        this.context = Util.buildPath((boolean)false, (String[])new String[]{contextPath, "/", sp});
        if (this.context.equals("/")) {
            this.context = "";
        }
        this.urlPrefix = req.getRequestURL().toString();
        int pos = !this.context.isEmpty() ? this.urlPrefix.indexOf(this.context) : this.urlPrefix.indexOf(req.getRequestURI());
        if (pos > 0) {
            this.urlPrefix = this.urlPrefix.substring(0, pos);
        }
    }

    public UrlHandler(String urlPrefix, String context, boolean relative) {
        this.relative = relative;
        this.context = context == null || context.equals("/") ? "" : (context.endsWith("/") ? context.substring(0, context.length() - 1) : context);
        this.urlPrefix = urlPrefix;
    }

    @Override
    public String prefix(String val) {
        String enc;
        if (val == null) {
            return null;
        }
        if (val.toLowerCase().startsWith("mailto:")) {
            return val;
        }
        try {
            enc = new URI(null, null, val, null).toString();
            enc = new URI(enc).toASCIIString();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        StringBuilder sb = new StringBuilder();
        if (!this.relative) {
            sb.append(this.getUrlPrefix());
        }
        if (!val.startsWith(this.context + "/")) {
            this.append(sb, this.context);
        }
        this.append(sb, enc);
        return sb.toString();
    }

    @Override
    public String unprefix(String val) {
        if (val == null) {
            return null;
        }
        if (val.startsWith(this.getUrlPrefix())) {
            val = val.substring(this.getUrlPrefix().length());
        }
        if (val.startsWith(this.context)) {
            val = val.substring(this.context.length());
        }
        return val;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    private boolean endsWithSlash(StringBuilder sb) {
        if (sb.isEmpty()) {
            return false;
        }
        return sb.charAt(sb.length() - 1) == '/';
    }

    private void append(StringBuilder sb, String val) {
        if (val.startsWith("/")) {
            if (!this.endsWithSlash(sb)) {
                sb.append(val);
            } else {
                sb.append(val.substring(1));
            }
        } else {
            if (!this.endsWithSlash(sb)) {
                sb.append("/");
            }
            sb.append(val);
        }
    }
}

