/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.notifier.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import org.bedework.notifier.NotifyEngine;
import org.bedework.notifier.NotifyRegistry;
import org.bedework.notifier.db.Subscription;
import org.bedework.notifier.exception.NoteException;
import org.bedework.notifier.web.MethodBase;
import org.bedework.util.misc.Util;

public class PostMethod
extends MethodBase {
    @Override
    public void init() {
    }

    @Override
    public void doMethod(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.getDb().startTransaction();
            List<String> resourceUri = this.getResourceUri(req);
            if (Util.isEmpty(resourceUri)) {
                throw new NoteException("Bad resource url - no connector specified");
            }
            String ruri = resourceUri.get(0);
            if ("notification".equals(ruri)) {
                this.processNotification(req, resp, resourceUri);
                return;
            }
            if ("subscribe".equals(ruri)) {
                this.processSubscribe(req, resp, resourceUri);
                return;
            }
            if ("unsubscribe".equals(ruri)) {
                this.processUnsubscribe(req, resp, resourceUri);
                return;
            }
            if (this.debug()) {
                this.debug("Unknown POST uri: " + ruri);
            }
            resp.setStatus(400);
        }
        catch (NoteException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new NoteException(t);
        }
        finally {
            this.getDb().endTransaction();
        }
    }

    private void processNotification(HttpServletRequest req, HttpServletResponse resp, List<String> resourceUri) {
        Map<?, ?> vals = this.getJson(req, resp);
        try {
            String system = PostMethod.must((String)"system", vals);
            String token = PostMethod.must((String)"token", vals);
            String href = PostMethod.may((String)"href", vals);
            String resourceName = PostMethod.may((String)"resourceName", vals);
            if (!NotifyEngine.authenticate((String)system, (String)token)) {
                resp.setStatus(400);
                return;
            }
            resp.setStatus(200);
            if (href == null) {
                return;
            }
            this.notifier.addNotificationMsg(new NotifyEngine.NotificationMsg(system, Util.buildPath((boolean)true, (String[])new String[]{href}), resourceName));
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            resp.setStatus(400);
        }
    }

    private void processSubscribe(HttpServletRequest req, HttpServletResponse resp, List<String> resourceUri) {
        Map<?, ?> vals = this.getJson(req, resp);
        try {
            String system = PostMethod.must((String)"system", vals);
            String token = PostMethod.must((String)"token", vals);
            if (!NotifyEngine.authenticate((String)system, (String)token)) {
                if (this.debug()) {
                    this.debug("Bad sys/token " + system + ", " + token);
                }
                resp.setStatus(400);
                return;
            }
            Subscription sub = NotifyRegistry.getConnector((String)system).subscribe(this.getDb(), vals);
            if (sub == null) {
                if (this.debug()) {
                    this.debug("Subscribe failed for " + system + ", " + token);
                }
                resp.setStatus(400);
                return;
            }
            resp.setStatus(200);
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            resp.setStatus(400);
        }
    }

    private void processUnsubscribe(HttpServletRequest req, HttpServletResponse resp, List<String> resourceUri) {
        Map<?, ?> vals = this.getJson(req, resp);
        try {
            String system = PostMethod.must((String)"system", vals);
            String token = PostMethod.must((String)"token", vals);
            if (!NotifyEngine.authenticate((String)system, (String)token)) {
                resp.setStatus(400);
                return;
            }
            Subscription sub = NotifyRegistry.getConnector((String)system).unsubscribe(this.getDb(), vals);
            if (sub == null) {
                resp.setStatus(400);
                return;
            }
            resp.setStatus(200);
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            resp.setStatus(400);
        }
    }
}

