/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.notifier.web;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.bedework.notifier.NotifyEngine;
import org.bedework.notifier.exception.NoteException;
import org.bedework.notifier.service.NotifyConf;
import org.bedework.notifier.web.MethodBase;
import org.bedework.notifier.web.PostMethod;
import org.bedework.util.http.service.HttpOut;
import org.bedework.util.jmx.ConfBase;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.servlet.io.CharArrayWrappedResponse;
import org.bedework.util.xml.XmlEmit;
import org.bedework.util.xml.tagdefs.WebdavTags;

public class NotifierServlet
extends HttpServlet
implements Logged,
HttpSessionListener,
ServletContextListener {
    protected boolean dumpContent;
    protected HashMap<String, MethodBase.MethodInfo> methods = new HashMap();
    private static final HashMap<String, Waiter> waiters = new HashMap();
    private final Configurator conf = new Configurator();
    private final BwLogger logger = new BwLogger();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.dumpContent = "true".equals(config.getInitParameter("dumpContent"));
        this.addMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        NotifyEngine notifier = null;
        boolean serverError = false;
        try {
            MethodBase method;
            String methodName;
            if (this.debug()) {
                this.debug("entry: " + req.getMethod());
                this.dumpRequest(req);
            }
            this.tryWait(req, true);
            notifier = NotifyEngine.getNotifier();
            if (req.getCharacterEncoding() == null) {
                req.setCharacterEncoding("UTF-8");
                if (this.debug()) {
                    this.debug("No charset specified in request; forced to UTF-8");
                }
            }
            if (this.debug() && this.dumpContent) {
                resp = new CharArrayWrappedResponse(resp);
            }
            if ((methodName = req.getHeader("X-HTTP-Method-Override")) == null) {
                methodName = req.getMethod();
            }
            if ((method = this.getMethod(notifier, methodName)) == null) {
                this.info("No method for '" + methodName + "'");
            } else {
                method.init(notifier, this.dumpContent);
                method.doMethod(req, resp);
            }
        }
        catch (Throwable t) {
            serverError = this.handleException(notifier, t, resp, serverError);
        }
        finally {
            if (notifier != null) {
                // empty if block
            }
            try {
                this.tryWait(req, false);
            }
            catch (Throwable methodName) {}
            if (this.debug() && this.dumpContent && resp instanceof CharArrayWrappedResponse) {
                CharArrayWrappedResponse wresp = (CharArrayWrappedResponse)resp;
                if (wresp.getUsedOutputStream()) {
                    this.debug("------------------------ response written to output stream -------------------");
                } else {
                    String str = wresp.toString();
                    this.debug("------------------------ Dump of response -------------------");
                    this.debug(str);
                    this.debug("---------------------- End dump of response -----------------");
                    byte[] bs = str.getBytes();
                    resp = (HttpServletResponse)wresp.getResponse();
                    this.debug("contentLength=" + bs.length);
                    resp.setContentLength(bs.length);
                    resp.getOutputStream().write(bs);
                }
            }
            try {
                HttpSession sess = req.getSession(false);
                if (sess != null) {
                    sess.invalidate();
                }
            }
            catch (Throwable sess) {}
        }
    }

    private boolean handleException(NotifyEngine notifier, Throwable t, HttpServletResponse resp, boolean serverError) {
        if (serverError) {
            return true;
        }
        try {
            if (t instanceof NoteException) {
                NoteException se = (NoteException)t;
                int status = se.getStatusCode();
                if (status == 500) {
                    this.error((Throwable)se);
                    serverError = true;
                }
                this.sendError(notifier, t, resp);
                return serverError;
            }
            this.error(t);
            this.sendError(notifier, t, resp);
            return true;
        }
        catch (Throwable t1) {
            return true;
        }
    }

    private void sendError(NotifyEngine notifier, Throwable t, HttpServletResponse resp) {
        try {
            if (t instanceof NoteException) {
                NoteException se = (NoteException)t;
                QName errorTag = se.getErrorTag();
                if (errorTag != null) {
                    if (this.debug()) {
                        this.debug("setStatus(" + se.getStatusCode() + ")");
                    }
                    resp.setStatus(se.getStatusCode());
                    resp.setContentType("text/xml; charset=UTF-8");
                    if (!this.emitError(notifier, errorTag, se.getMessage(), resp.getWriter())) {
                        StringWriter sw = new StringWriter();
                        this.emitError(notifier, errorTag, se.getMessage(), sw);
                        try {
                            if (this.debug()) {
                                this.debug("setStatus(" + se.getStatusCode() + ")");
                            }
                            resp.sendError(se.getStatusCode(), sw.toString());
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    if (this.debug()) {
                        this.debug("setStatus(" + se.getStatusCode() + ")");
                    }
                    resp.sendError(se.getStatusCode(), se.getMessage());
                }
            } else {
                if (this.debug()) {
                    this.debug("setStatus(500)");
                }
                resp.sendError(500, t.getMessage());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean emitError(NotifyEngine notifier, QName errorTag, String extra, Writer wtr) {
        try {
            XmlEmit xml = new XmlEmit();
            xml.startEmit(wtr);
            xml.openTag(WebdavTags.error);
            xml.closeTag(WebdavTags.error);
            xml.flush();
            return true;
        }
        catch (Throwable t1) {
            return false;
        }
    }

    protected void addMethods() {
        this.methods.put("POST", new MethodBase.MethodInfo(PostMethod.class, true));
    }

    public MethodBase getMethod(NotifyEngine notifier, String name) {
        MethodBase.MethodInfo mi = this.methods.get(name.toUpperCase());
        try {
            MethodBase mb = mi.getMethodClass().newInstance();
            mb.init(notifier, this.dumpContent);
            return mb;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new NoteException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryWait(HttpServletRequest req, boolean in) {
        Waiter wtr;
        Object object = waiters;
        synchronized (object) {
            String key = req.getRemoteUser();
            if (key == null) {
                return;
            }
            wtr = waiters.get(key);
            if (wtr == null) {
                if (!in) {
                    return;
                }
                wtr = new Waiter();
                wtr.active = true;
                waiters.put(key, wtr);
                return;
            }
        }
        object = wtr;
        synchronized (object) {
            if (!in) {
                wtr.active = false;
                wtr.notify();
                return;
            }
            ++wtr.waiting;
            while (wtr.active) {
                if (this.debug()) {
                    this.debug("in: waiters=" + wtr.waiting);
                }
                try {
                    wtr.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            --wtr.waiting;
            wtr.active = true;
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        String sessid = session.getId();
        if (sessid == null) {
            return;
        }
        HashMap<String, Waiter> hashMap = waiters;
        synchronized (hashMap) {
            waiters.remove(sessid);
        }
    }

    public void dumpRequest(HttpServletRequest req) {
        try {
            Enumeration hnames = req.getHeaderNames();
            String title = "Request headers";
            this.debug(title);
            while (hnames.hasMoreElements()) {
                String key = (String)hnames.nextElement();
                String val = req.getHeader(key);
                this.debug("  " + key + " = \"" + val + "\"");
            }
            Enumeration pnames = req.getParameterNames();
            title = "Request parameters";
            this.debug(title + " - global info and uris");
            this.debug("getRemoteAddr = " + req.getRemoteAddr());
            this.debug("getRequestURI = " + req.getRequestURI());
            this.debug("getRemoteUser = " + req.getRemoteUser());
            this.debug("getRequestedSessionId = " + req.getRequestedSessionId());
            this.debug("HttpUtils.getRequestURL(req) = " + String.valueOf(req.getRequestURL()));
            this.debug("contextPath=" + req.getContextPath());
            this.debug("query=" + req.getQueryString());
            this.debug("contentlen=" + req.getContentLength());
            this.debug("request=" + String.valueOf(req));
            this.debug("parameters:");
            this.debug(title);
            while (pnames.hasMoreElements()) {
                String key = (String)pnames.nextElement();
                String val = req.getParameter(key);
                this.debug("  " + key + " = \"" + val + "\"");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.conf.start();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.conf.stop();
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }

    static class Configurator
    extends ConfBase {
        NotifyConf notifyConf;

        Configurator() {
            super("org.bedework.notify:service=Notify", (String)null, null);
        }

        public String loadConfig() {
            return null;
        }

        public void start() {
            try {
                ConfBase.getManagementContext().start();
                this.notifyConf = new NotifyConf();
                this.register("notifyConf", "notifyConf", this.notifyConf);
                this.notifyConf.loadConfig();
                this.notifyConf.start();
                HttpOut ho = new HttpOut("notify", "httpConfig");
                this.register(new ObjectName(ho.getServiceName()), ho);
                ho.loadConfig();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void stop() {
            try {
                this.notifyConf.stop();
                ConfBase.getManagementContext().stop();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static class Waiter {
        boolean active;
        int waiting;

        Waiter() {
        }
    }
}

