/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.notifier.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.bedework.notifier.NotifyEngine;
import org.bedework.notifier.db.JsonUtil;
import org.bedework.notifier.db.NotifyDb;
import org.bedework.notifier.exception.NoteException;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.w3c.dom.Document;

public abstract class MethodBase
extends JsonUtil
implements Logged {
    protected boolean dumpContent;
    protected NotifyEngine notifier;
    private NotifyDb db;
    protected ObjectMapper om = new ObjectMapper();
    private final SimpleDateFormat httpDateFormatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss ");
    private final BwLogger logger = new BwLogger();

    public abstract void init();

    public abstract void doMethod(HttpServletRequest var1, HttpServletResponse var2) throws NoteException;

    public void init(NotifyEngine notifier, boolean dumpContent) {
        this.notifier = notifier;
        this.dumpContent = dumpContent;
        this.init();
    }

    public NotifyEngine getNotifier() {
        return this.notifier;
    }

    public NotifyDb getDb() {
        if (this.db != null) {
            return this.db;
        }
        this.db = NotifyEngine.getNewDb();
        return this.db;
    }

    public List<String> getResourceUri(HttpServletRequest req) {
        String uri = req.getServletPath();
        if (uri == null || uri.isEmpty()) {
            uri = "/";
        }
        return MethodBase.fixPath(uri);
    }

    public static List<String> fixPath(String path) {
        Object decoded;
        if (path == null) {
            return null;
        }
        try {
            decoded = URLDecoder.decode(path, StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            throw new NoteException("bad path: " + path);
        }
        if (decoded == null) {
            return null;
        }
        if (((String)decoded).indexOf(92) >= 0) {
            decoded = ((String)decoded).replace('\\', '/');
        }
        if (!((String)decoded).startsWith("/")) {
            decoded = "/" + (String)decoded;
        }
        while (((String)decoded).contains("//")) {
            decoded = ((String)decoded).replaceAll("//", "/");
        }
        StringTokenizer st = new StringTokenizer((String)decoded, "/");
        ArrayList<String> al = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals(".")) continue;
            if (s.equals("..")) {
                if (al.isEmpty()) {
                    return null;
                }
                al.remove(al.size() - 1);
                continue;
            }
            al.add(s);
        }
        return al;
    }

    protected void addHeaders(HttpServletResponse resp) {
        resp.addHeader("Allow", "POST, GET");
    }

    protected Map<?, ?> getJson(HttpServletRequest req, HttpServletResponse resp) {
        int len = req.getContentLength();
        if (len == 0) {
            return null;
        }
        try {
            return (Map)this.om.readValue((InputStream)req.getInputStream(), Object.class);
        }
        catch (Throwable t) {
            resp.setStatus(500);
            throw new NoteException(t);
        }
    }

    protected Document parseContent(HttpServletRequest req, HttpServletResponse resp) throws NoteException {
        int len = req.getContentLength();
        if (len == 0) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return null;
        }
        catch (Throwable t) {
            resp.setStatus(500);
            throw new NoteException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatHTTPDate(Timestamp val) {
        if (val == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = this.httpDateFormatter;
        synchronized (simpleDateFormat) {
            return this.httpDateFormatter.format(val) + "GMT";
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }

    public static class MethodInfo {
        private final Class<? extends MethodBase> methodClass;
        private final boolean requiresAuth;

        public MethodInfo(Class<? extends MethodBase> methodClass, boolean requiresAuth) {
            this.methodClass = methodClass;
            this.requiresAuth = requiresAuth;
        }

        public Class<? extends MethodBase> getMethodClass() {
            return this.methodClass;
        }

        public boolean getRequiresAuth() {
            return this.requiresAuth;
        }
    }
}

