/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.base.response;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.xml.namespace.QName;
import org.bedework.base.ToString;

public class Response
implements Serializable {
    private Status status = Status.ok;
    private String message;
    private QName errorTag;
    private final ConcurrentLinkedDeque<String> warnings = new ConcurrentLinkedDeque();
    private Throwable exception;
    private int id;

    public boolean hasWarning() {
        return this.warnings.isEmpty();
    }

    public void warning(String val) {
        this.warnings.add(val);
    }

    public Iterable<String> getWarnings() {
        return this.warnings;
    }

    public void setStatus(Status val) {
        this.status = val;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setMessage(String val) {
        this.message = val;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        if (this.exception != null) {
            return this.exception.getMessage();
        }
        return null;
    }

    public void setErrorTag(QName val) {
        this.errorTag = val;
    }

    public QName getErrorTag() {
        return this.errorTag;
    }

    public boolean isOk() {
        return this.status == Status.ok;
    }

    public boolean isNotFound() {
        return this.status == Status.notFound;
    }

    public boolean isError() {
        return !this.isOk() && !this.isNotFound();
    }

    public void setException(Throwable val) {
        this.exception = val;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setId(int val) {
        this.id = val;
    }

    public int getId() {
        return this.id;
    }

    public static Response ok() {
        return Response.ok(new Response(), null);
    }

    public static <T extends Response> T ok(T resp) {
        resp.setStatus(Status.ok);
        resp.setMessage(null);
        return resp;
    }

    public static <T extends Response> T ok(T resp, String msg) {
        resp.setStatus(Status.ok);
        resp.setMessage(msg);
        return resp;
    }

    public static <T extends Response> T notFound(T resp) {
        return Response.notFound(resp, null);
    }

    public static <T extends Response> T notFound(T resp, String msg) {
        resp.setStatus(Status.notFound);
        resp.setMessage(msg);
        return resp;
    }

    public static <T extends Response> T notOk(T resp, Status status) {
        resp.setStatus(status);
        resp.setMessage(null);
        return resp;
    }

    public static <T extends Response> T notOk(T resp, Status status, String msg) {
        resp.setStatus(status);
        resp.setMessage(msg);
        return resp;
    }

    public static <T extends Response> T notOk(T resp, Status status, QName errorTag) {
        resp.setStatus(status);
        resp.setErrorTag(errorTag);
        return resp;
    }

    public static <T extends Response> T fromResponse(T resp, Response from) {
        resp.setStatus(from.getStatus());
        resp.setMessage(from.getMessage());
        resp.setException(from.getException());
        return resp;
    }

    public static <T extends Response> T error(T resp, String msg) {
        return Response.notOk(resp, Status.failed, msg);
    }

    public static <T extends Response> T error(T resp, Throwable t) {
        resp.setException(t);
        return Response.error(resp, t.getLocalizedMessage());
    }

    public static <T extends Response> T invalid(T resp, String msg) {
        return Response.notOk(resp, Status.validationError, msg);
    }

    public void toStringSegment(ToString ts) {
        ts.append("status", (Object)this.getStatus()).append("message", this.getMessage()).append("id", this.getId());
    }

    public String toString() {
        ToString ts = new ToString(this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    public static enum Status {
        ok,
        notFound,
        validationError,
        processing,
        exists,
        forbidden,
        noAccess,
        limitExceeded,
        failed;

    }
}

