/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.base;

import java.util.Collection;

public class ToString {
    private StringBuilder sb;
    private int indents;
    private String delim = "";
    private int lastNewLinePos = 0;
    private boolean valuesOnly;
    private boolean delimitersOn = true;
    private static final int maxLen = 80;
    private static final String indentVal = "  ";
    private int lineCt;
    private int objStartLineCt;

    public ToString(Object o) {
        this.sb = new StringBuilder(o.getClass().getSimpleName()).append("{");
        ++this.indents;
    }

    private ToString() {
    }

    public static ToString valuesOnly() {
        ToString ts = new ToString();
        ts.valuesOnly = true;
        ts.sb = new StringBuilder();
        return ts;
    }

    public ToString(Object o, int indents) {
        this.sb = new StringBuilder();
        this.sb.append(indentVal.repeat(Math.max(0, indents)));
        this.sb.append(o.getClass().getSimpleName()).append("{");
        this.indents = Math.max(0, indents);
    }

    public ToString initClass(Object o) {
        this.sb.append(o.getClass().getSimpleName()).append("{");
        this.clearDelim();
        ++this.indents;
        this.objStartLineCt = this.lineCt;
        return this;
    }

    public StringBuilder getSb() {
        return this.sb;
    }

    public ToString delimitersOn() {
        this.delimitersOn = true;
        return this;
    }

    public ToString delimitersOff() {
        this.delimitersOn = false;
        return this;
    }

    public ToString clearDelim() {
        this.delim = "";
        return this;
    }

    public ToString delimit() {
        if (this.delimitersOn) {
            this.sb.append(this.delim);
            this.delim = ", ";
        }
        if (this.lineLength() > 80) {
            this.outputNewLine();
        }
        return this;
    }

    public ToString indentIn() {
        ++this.indents;
        return this;
    }

    public ToString indentOut() {
        if (this.indents > 0) {
            --this.indents;
        }
        return this;
    }

    public int lineLength() {
        return this.sb.length() - this.lastNewLinePos;
    }

    public ToString newLine() {
        this.sb.append(this.delim);
        this.delim = "";
        this.outputNewLine();
        return this;
    }

    public ToString appendQ(String value) {
        this.delimit();
        this.sb.append("\"").append(value).append("\"");
        return this;
    }

    public ToString appendParen(String value) {
        this.sb.append("(").append(value).append(")");
        return this;
    }

    public ToString append(String value) {
        this.delimit();
        this.sb.append(value);
        return this;
    }

    public ToString append(Object value) {
        return this.delimit().appendObject(value);
    }

    public ToString appendObject(Object value) {
        if (value instanceof ToStringProducer) {
            ((ToStringProducer)value).toStringWith(this);
        } else {
            this.sb.append(value);
        }
        return this;
    }

    public ToString append(String name, Iterable<?> val, boolean withNewLines) {
        this.nameEquals(name);
        this.sb.append("[");
        if (val == null) {
            this.sb.append("]");
            return this;
        }
        this.indentIn();
        for (Object o : val) {
            if (withNewLines) {
                this.newLine();
            }
            this.append(o);
        }
        this.indentOut().newLine();
        this.sb.append("]");
        return this;
    }

    public ToString append(String name, Object value) {
        return this.nameEquals(name).appendObject(value);
    }

    public ToString appendNotNull(String name, Object value) {
        if (value != null) {
            return this.append(name, value);
        }
        return this;
    }

    public ToString append(String name, Long value) {
        this.nameEquals(name);
        this.sb.append(value);
        return this;
    }

    public ToString appendNotNull(String name, Long value) {
        if (value != null) {
            return this.append(name, value);
        }
        return this;
    }

    public ToString append(String name, Collection<?> value) {
        this.nameEquals(name);
        if (value == null) {
            this.sb.append("null");
            return this;
        }
        this.sb.append("[");
        String saveDelim = this.delim;
        this.delim = "";
        for (Object o : value) {
            this.append(o);
        }
        this.sb.append("]");
        this.delim = saveDelim;
        return this;
    }

    public ToString appendNotNull(String name, Collection<?> value) {
        if (value != null) {
            return this.append(name, value);
        }
        return this;
    }

    public ToString append(String name, boolean value) {
        return this.append(name, String.valueOf(value));
    }

    public ToString append(String name, int value) {
        return this.append(name, String.valueOf(value));
    }

    public ToString append(Throwable t) {
        return this.append("Exception", t.getMessage());
    }

    public ToString nameEquals(String name) {
        this.delimit();
        this.sb.append(name);
        this.sb.append("=");
        return this;
    }

    public ToString closeClass() {
        this.indentOut();
        if (this.objStartLineCt != this.lineCt) {
            this.outputNewLine();
        }
        if (!this.valuesOnly) {
            this.sb.append("}");
        }
        return this;
    }

    public String toString() {
        return this.closeClass().getSb().toString();
    }

    private void outputNewLine() {
        this.sb.append("\n");
        this.lastNewLinePos = this.sb.length();
        ++this.lineCt;
        this.sb.append(indentVal.repeat(this.indents));
    }

    public static interface ToStringProducer {
        public void toStringWith(ToString var1);
    }
}

