/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.misc;

import javax.naming.NameNotFoundException;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;

public abstract class AbstractProcessorThread
extends Thread
implements Logged {
    public static final String statusDone = "Done";
    public static final String statusFailed = "Failed";
    public static final String statusRunning = "Running";
    public static final String statusStopped = "Stopped";
    public static final String statusUnstoppable = "Unstoppable";
    private String status = "Stopped";
    protected boolean running;
    private boolean showedTrace;
    private final BwLogger logger = new BwLogger();

    public AbstractProcessorThread(String name) {
        super(name);
    }

    public abstract void runInit();

    public abstract void end(String var1);

    public abstract void runProcess() throws Throwable;

    public abstract void close();

    public boolean handleException(Throwable val) {
        if (Util.causeIs(val, NameNotFoundException.class)) {
            this.error("Looks like JMX shut down.");
            this.error(val);
            this.running = false;
            return true;
        }
        return false;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String val) {
        this.status = val;
    }

    public void setRunning(boolean val) {
        this.running = val;
    }

    public boolean getRunning() {
        return this.running;
    }

    public static String checkStarted(AbstractProcessorThread processor) {
        if (processor == null) {
            return statusStopped;
        }
        if (!processor.isAlive()) {
            return statusStopped;
        }
        if (processor.running) {
            return statusRunning;
        }
        processor.interrupt();
        try {
            processor.join(5000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!processor.isAlive()) {
            return statusStopped;
        }
        return statusUnstoppable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.info("************************************************************");
        this.info(" * Starting " + this.getName());
        this.runInit();
        this.info("************************************************************");
        long lastErrorTime = 0L;
        long errorResetTime = 300000L;
        int errorCt = 0;
        int maxErrorCt = 5;
        while (this.running) {
            try {
                this.runProcess();
                this.running = false;
            }
            catch (InterruptedException ie) {
                this.running = false;
                break;
            }
            catch (Throwable t) {
                if (!this.handleException(t)) {
                    if (System.currentTimeMillis() - lastErrorTime > 300000L) {
                        errorCt = 0;
                    }
                    if (errorCt > 5) {
                        this.error("Too many errors: stopping");
                        this.running = false;
                        break;
                    }
                    lastErrorTime = System.currentTimeMillis();
                    ++errorCt;
                    if (!this.showedTrace) {
                        this.error(t);
                    } else {
                        this.error(t.getMessage());
                    }
                }
            }
            finally {
                this.close();
            }
            this.info("****************************************************");
            this.info(" * " + this.getName() + " terminated");
            if (this.running) {
                this.info(" * Will restart the process.");
            }
            this.info("****************************************************");
        }
    }

    public static boolean stopProcess(AbstractProcessorThread proc) {
        if (proc == null) {
            return true;
        }
        proc.info("************************************************************");
        proc.info(" * Stopping " + proc.getName());
        proc.info("************************************************************");
        proc.setRunning(false);
        proc.interrupt();
        boolean ok = true;
        try {
            proc.join(20000L);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable t) {
            proc.error("Error waiting for processor termination");
            proc.error(t);
            ok = false;
        }
        proc.info("************************************************************");
        proc.info(" * " + proc.getName() + " terminated");
        proc.info("************************************************************");
        return ok;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

