/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwlogs;

import java.util.ArrayList;
import java.util.List;
import org.bedework.base.ToString;

public class LogEntry {
    private static long startMillis;
    private static long lastMillis;
    protected String req;
    protected int curPos;
    public Long millis;
    public long sinceLastMillis;
    public long sinceStartMillis;
    public String dt;
    public String level;
    public String className;
    public String taskId;
    public String logText;
    public boolean unparsed;
    String logName;
    public List<LogEntry> entries = new ArrayList<LogEntry>();
    public LogEntry lastAdded;

    public void unparsed(String req) {
        this.unparsed = true;
        this.logText = req;
    }

    public Integer parse(String req, String logName, String logLevel) {
        try {
            this.req = req;
            this.logName = logName;
            this.dt = req.substring(0, 23);
            this.curPos = req.indexOf(" ", 24);
            this.level = req.substring(24, this.curPos);
            if (logLevel != null && !logLevel.equals(this.level)) {
                return null;
            }
            this.millis = this.millis();
            if (this.millis == null) {
                this.error("Unable to get millis for %s", req);
                return null;
            }
            if (startMillis != 0L) {
                this.sinceLastMillis = this.millis - lastMillis;
                this.sinceStartMillis = this.millis - startMillis;
            } else {
                startMillis = this.millis;
            }
            lastMillis = this.millis;
            this.className = this.className(req);
            this.taskId = this.taskId(req);
            this.logText = this.posValid() ? req.substring(this.curPos) : "";
            if (logName == null) {
                return this.curPos;
            }
            this.curPos = req.indexOf(logName + ":");
            if (this.curPos < 0) {
                this.error("No name found for %s", req);
                return null;
            }
            this.curPos += logName.length() + 2;
            return this.curPos;
        }
        catch (Throwable t) {
            this.error("Unable to parse %s", req);
            throw t;
        }
    }

    public void addLogEntry(LogEntry val) {
        this.entries.add(val);
        this.lastAdded = val;
    }

    public boolean sameTask(LogEntry otherEntry) {
        if (!this.taskId.equals(otherEntry.taskId)) {
            this.out("taskId mismatch", new Object[0]);
            return false;
        }
        return true;
    }

    public Long millis() {
        try {
            long hrs = Integer.parseInt(this.req.substring(11, 13));
            long mins = Integer.parseInt(this.req.substring(14, 16));
            long secs = Integer.parseInt(this.req.substring(17, 19));
            long millis = Integer.parseInt(this.req.substring(20, 23));
            return ((hrs * 60L + mins) * 60L + secs) * 1000L + millis;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    protected boolean posValid() {
        return this.curPos >= 0 && this.curPos < this.req.length();
    }

    private String className(String ln) {
        int cnPos = ln.indexOf("[");
        if (cnPos < 0) {
            return null;
        }
        this.curPos = ln.indexOf("]", ++cnPos);
        if (this.curPos < 0) {
            return null;
        }
        String res = ln.substring(cnPos, this.curPos);
        ++this.curPos;
        return res;
    }

    private String taskId(String ln) {
        int taskIdPos = ln.indexOf("] (");
        if (taskIdPos < 0) {
            return null;
        }
        this.curPos = ln.indexOf(")", taskIdPos += 3);
        if (this.curPos < 0) {
            return null;
        }
        String res = ln.substring(taskIdPos, this.curPos);
        this.curPos += 2;
        return res;
    }

    protected void error(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    protected void out(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    protected void toStringSegment(ToString ts) {
        ts.append("taskId", (Object)this.taskId);
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }
}

