/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.logging;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.logging.Level;
import org.bedework.util.logging.BwLogger;

public interface Logged {
    @JsonIgnore
    public BwLogger getLogger();

    default public void setLoggerClass() {
        this.getLogger().setLoggedClass(this.getClass());
    }

    default public void setLoggerClass(Class<?> cl) {
        this.getLogger().setLoggedClass(cl);
    }

    default public Level getLogLevel(String className) {
        return this.getLogger().getLogLevel(className);
    }

    default public boolean debug() {
        return this.getLogger().isDebugEnabled();
    }

    default public boolean trace() {
        return this.getLogger().isTraceEnabled();
    }

    @JsonIgnore
    default public boolean isMetricsDebugEnabled() {
        return this.getLogger().isMetricsDebugEnabled();
    }

    default public void enableErrorLogger() {
        this.getLogger().enableErrorLogger();
    }

    default public void enableAuditLogger() {
        this.getLogger().enableAuditLogger();
    }

    default public void enableMetricsLogger() {
        this.getLogger().enableMetricsLogger();
    }

    @JsonIgnore
    default public boolean isErrorLoggerEnabled() {
        return this.getLogger().isErrorLoggerEnabled();
    }

    @JsonIgnore
    default public boolean isAuditLoggerEnabled() {
        return this.getLogger().isAuditLoggerEnabled();
    }

    @JsonIgnore
    default public boolean isMetricsLoggerEnabled() {
        return this.getLogger().isMetricsLoggerEnabled();
    }

    default public void error(Throwable t) {
        this.getLogger().error(t);
    }

    default public void error(String msg) {
        this.getLogger().error(msg);
    }

    default public void error(String msg, Throwable t) {
        this.getLogger().error(msg, t);
    }

    default public void warn(String msg) {
        this.getLogger().warn(msg);
    }

    default public void info(String msg) {
        this.getLogger().info(msg);
    }

    default public void audit(String msg) {
        this.getLogger().audit(msg);
    }

    default public void metrics(String msg) {
        this.getLogger().metrics(msg);
    }

    default public void debug(String msg) {
        this.getLogger().debug(msg);
    }

    default public void debug(String msg, Object ... params) {
        this.getLogger().debug(msg, params);
    }

    default public void trace(String msg) {
        this.getLogger().trace(msg);
    }

    default public void trace(String msg, Object ... params) {
        this.getLogger().trace(msg, params);
    }
}

