/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwlogs;

import java.util.Map;
import org.bedework.bwlogs.ReqInOutLogEntry;

public class ContextInfo {
    public static final int numMilliBuckets = 20;
    public static final int milliBucketSize = 100;
    String context;
    long requests;
    long totalMillis;
    long subTrequests;
    long subTtotalMillis;
    long[] buckets = new long[20];
    long sessions;
    public long rTotalReq;
    final Map<String, Integer> longreqIpMap;

    public ContextInfo(String context, Map<String, Integer> longreqIpMap) {
        this.context = context;
        this.longreqIpMap = longreqIpMap;
    }

    public void reqOut(String ln, ReqInOutLogEntry rs, long millis, boolean showLong) {
        ++this.requests;
        this.totalMillis += millis;
        int bucket = (int)(millis / 100L);
        if (bucket >= 19) {
            bucket = 19;
            if (showLong) {
                String dt = ln.substring(0, ln.indexOf(" INFO"));
                this.outFmt("Long request %s %s %d: %s - %s %s", rs.ip, rs.taskId, millis, rs.dt, dt, rs.request);
            }
            int ct = this.longreqIpMap.computeIfAbsent(rs.ip, k -> 0);
            this.longreqIpMap.put(rs.ip, ++ct);
        }
        int n = bucket;
        this.buckets[n] = this.buckets[n] + 1L;
        if (bucket < 19) {
            ++this.subTrequests;
            this.subTtotalMillis += millis;
        }
    }

    public long getBucket(int i) {
        return this.buckets[i];
    }

    public long getRequests() {
        return this.requests;
    }

    public long getSessions() {
        return this.sessions;
    }

    public long getTotalMillis() {
        return this.totalMillis;
    }

    public long getSubTrequests() {
        return this.subTrequests;
    }

    public long getSubTtotalMillis() {
        return this.subTtotalMillis;
    }

    protected void outFmt(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }
}

