/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwlogs;

import java.util.HashMap;
import java.util.Map;
import org.bedework.util.misc.ToString;

public class AccessLogEntry {
    protected String req;
    protected int curPos;
    public String ip;
    public Long millis;
    public int hourOfDay;
    public String normDate;
    public String dt;
    public String method;
    public String path;
    public String status;
    public long length;
    public String userAgent;
    private static final Map<String, String> toMonth = new HashMap<String, String>();

    public static AccessLogEntry fromString(String req) {
        AccessLogEntry ale = new AccessLogEntry();
        if (ale.parse(req) == null) {
            return null;
        }
        return ale;
    }

    public Integer parse(String req) {
        this.req = req;
        this.ip = req.substring(0, req.indexOf(" "));
        this.curPos = req.indexOf("[[");
        if (this.curPos < 0) {
            return null;
        }
        int end = req.indexOf(" ", this.curPos);
        this.dt = req.substring(this.curPos + 2, end);
        this.millis = this.millis();
        if (this.millis == null) {
            this.error("Unable to get millis for %s", req);
            return null;
        }
        this.curPos = end + 1;
        if (!this.passQuote()) {
            return null;
        }
        end = this.blank();
        if (end < 0) {
            return null;
        }
        this.method = req.substring(this.curPos, end);
        this.curPos = end + 1;
        end = req.indexOf(" HTTP/1.1\"", this.curPos);
        if (end < 0) {
            return null;
        }
        this.path = req.substring(this.curPos, end);
        this.curPos = end + 10;
        end = req.indexOf(" ", this.curPos);
        this.status = req.substring(this.curPos, end);
        this.curPos = end + 1;
        end = req.indexOf(" ", this.curPos);
        if (req.charAt(this.curPos) != '-') {
            this.length = Integer.parseInt(req.substring(this.curPos, end));
        }
        this.curPos = end + 1;
        this.quoted();
        this.userAgent = this.quoted();
        return this.curPos;
    }

    private boolean passQuote() {
        while (this.req.charAt(this.curPos) != '\"') {
            ++this.curPos;
            if (this.posValid()) continue;
            return false;
        }
        ++this.curPos;
        return this.posValid();
    }

    private int blank() {
        return this.req.indexOf(" ", this.curPos);
    }

    private String quoted() {
        while (this.req.charAt(this.curPos) != '\"') {
            ++this.curPos;
            if (this.posValid()) continue;
            return null;
        }
        int end = this.req.indexOf("\"", this.curPos + 1);
        if (end < 0) {
            return null;
        }
        String res = this.req.substring(this.curPos + 1, end - 1);
        this.curPos = end + 1;
        return res;
    }

    public Long millis() {
        try {
            this.hourOfDay = Integer.parseInt(this.dt.substring(12, 14));
            long mins = Integer.parseInt(this.dt.substring(15, 17));
            long secs = Integer.parseInt(this.dt.substring(19, 20));
            this.normDate = this.dt.substring(7, 11) + "/" + toMonth.get(this.dt.substring(3, 6)) + "/" + this.dt.substring(0, 2);
            return (((long)this.hourOfDay * 60L + mins) * 60L + secs) * 1000L;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public boolean is404() {
        return this.isStatus("404");
    }

    public boolean is500() {
        return this.isStatus("500");
    }

    public boolean isStatus(String s) {
        return s.equals(this.status);
    }

    public boolean legacyFeeder() {
        if (this.method == null || this.path == null) {
            return false;
        }
        return "GET".equals(this.method) && this.path.startsWith("/feeder/") && (this.path.contains("?calPath=") || this.path.contains("&calPath="));
    }

    public boolean webCache() {
        if (this.method == null || this.path == null) {
            return false;
        }
        return "GET".equals(this.method) && this.path.startsWith("/webcache/v1.0/");
    }

    protected boolean posValid() {
        return this.curPos >= 0 && this.curPos < this.req.length();
    }

    protected void error(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    protected void out(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    protected void toStringSegment(ToString ts) {
        ts.append("ip", (Object)this.ip);
        ts.append("normDate", (Object)this.normDate);
        ts.append("millis", this.millis);
        ts.append("method", (Object)this.method);
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    static {
        toMonth.put("Jan", "01");
        toMonth.put("Feb", "02");
        toMonth.put("Mar", "03");
        toMonth.put("Apr", "04");
        toMonth.put("May", "05");
        toMonth.put("Jun", "06");
        toMonth.put("Jul", "07");
        toMonth.put("Aug", "08");
        toMonth.put("Sep", "09");
        toMonth.put("Oct", "10");
        toMonth.put("Nov", "11");
        toMonth.put("Dec", "12");
    }
}

