/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwlogs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bedework.util.misc.Util;

public class AccessPeriod {
    final Map<String, Integer> ipCounts = new HashMap<String, Integer>();
    final Map<String, Integer> ip2Counts = new HashMap<String, Integer>();
    final int periodSeconds;

    public AccessPeriod(int periodSeconds) {
        this.periodSeconds = periodSeconds;
    }

    public void addIp(String ip) {
        Integer i = this.ipCounts.getOrDefault(ip, 0);
        this.ipCounts.put(ip, i + 1);
        String ip2 = this.getIp2(ip);
        if (ip2 == null) {
            return;
        }
        i = this.ip2Counts.getOrDefault(ip2, 0);
        this.ip2Counts.put(ip2, i + 1);
    }

    public int totalRequests() {
        return this.ipCounts.values().stream().mapToInt(Number::intValue).sum();
    }

    public List<Map.Entry<String, Integer>> getSortedIpCounts() {
        return Util.sortMap(this.ipCounts);
    }

    public List<Map.Entry<String, Integer>> getSortedIp2Counts() {
        return Util.sortMap(this.ip2Counts);
    }

    public float perSecond() {
        return (float)this.totalRequests() / (float)this.periodSeconds;
    }

    public void add(AccessPeriod ap) {
        Integer i;
        Integer ct;
        for (String ip : ap.ipCounts.keySet()) {
            ct = ap.ipCounts.get(ip);
            i = this.ipCounts.getOrDefault(ip, 0);
            this.ipCounts.put(ip, i + ct);
        }
        for (String ip2 : ap.ip2Counts.keySet()) {
            ct = ap.ip2Counts.get(ip2);
            i = this.ip2Counts.getOrDefault(ip2, 0);
            this.ipCounts.put(ip2, i + ct);
        }
    }

    private String getIp2(String ip) {
        int pos = ip.indexOf(".");
        if (pos < 0) {
            return null;
        }
        if ((pos = ip.indexOf(".", pos + 1)) < 0) {
            return null;
        }
        return ip.substring(0, pos) + ".*";
    }
}

