/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwlogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bedework.bwlogs.AccessDay;
import org.bedework.bwlogs.AccessLogEntry;

public class AccessTracker {
    private final Map<String, AccessDay> dayValues = new HashMap<String, AccessDay>();

    public void updateFrom(AccessLogEntry ale) {
        AccessDay dayVal = this.dayValues.computeIfAbsent(ale.normDate, v -> new AccessDay());
        dayVal.updateFrom(ale);
    }

    public List<String> getSortedKeys() {
        ArrayList<String> days = new ArrayList<String>(this.dayValues.keySet());
        Collections.sort(days);
        return days;
    }

    public AccessDay getDay(String key) {
        return this.dayValues.get(key);
    }
}

