/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.sysevents.listeners;

import java.util.Properties;
import org.bedework.sysevents.NotificationException;
import org.bedework.sysevents.events.SysEvent;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.sysevents.listeners.SysEventActionClass;
import org.bedework.sysevents.listeners.SysEventListener;

public class SysEventListenerImpl
extends SysEventListener {
    private String actionClassName;
    private SysEventActionClass actionObject;
    protected SysEventBase.SysCode sysCode;
    protected Properties props;

    public SysEventListenerImpl(SysEventBase.SysCode code) {
        this.sysCode = code;
    }

    public SysEventListenerImpl(SysEventBase.SysCode code, SysEventActionClass actionObject) throws NotificationException {
        this.sysCode = code;
        this.setActionObject(actionObject);
    }

    @Override
    public void setActionClassName(String className) throws NotificationException {
        this.actionClassName = className;
    }

    @Override
    public void setActionObject(SysEventActionClass actionObject) throws NotificationException {
        this.actionObject = actionObject;
        if (actionObject == null) {
            this.actionClassName = null;
        } else {
            this.setActionClassName(actionObject.getClass().getName());
        }
    }

    @Override
    public void action(SysEvent ev) throws NotificationException {
        if (this.actionObject == null) {
            if (this.actionClassName == null) {
                throw new NotificationException("org.bedework.exception.noactionclassname");
            }
            Object o = null;
            try {
                o = Class.forName(this.actionClassName).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (o == null) {
                throw new NotificationException("org.bedework.exception.noactionclass", this.actionClassName);
            }
            if (!(o instanceof SysEventActionClass)) {
                throw new NotificationException("org.bedework.exception.notactionclass", this.actionClassName);
            }
            this.setActionObject(o);
        }
        this.actionObject.action(ev);
    }

    @Override
    public String toXml() throws NotificationException {
        return null;
    }
}

