/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.sysevents;

import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.bedework.calfacade.configs.SystemProperties;
import org.bedework.calsvci.CalSvcFactoryDefault;
import org.bedework.sysevents.JmsDefs;
import org.bedework.sysevents.NotificationException;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;

public class JmsConnectionHandler
implements Logged,
JmsDefs {
    private static final String propertiesFile = "/sysevents.properties";
    private static volatile Properties pr;
    private static final Object lockit;
    private Connection connection;
    private Queue ourQueue;
    private Session session;
    private MessageConsumer consumer;
    private BwLogger logger = new BwLogger();

    public void open(String queueName) throws NotificationException {
        this.open(queueName, this.getPr());
    }

    public void open(String queueName, Properties pr) throws NotificationException {
        try {
            InitialContext ctx = new InitialContext(pr);
            try {
                ConnectionFactory connFactory = (ConnectionFactory)ctx.lookup(pr.getProperty("org.bedework.connection.factory.name"));
                this.connection = connFactory.createConnection();
            }
            catch (Throwable t) {
                if (this.debug()) {
                    this.error(t);
                }
                throw new NotificationException(t);
            }
            try {
                this.session = this.connection.createSession(false, 1);
                String qn = pr.getProperty("org.bedework.jms.queue.prefix") + queueName;
                try {
                    this.ourQueue = (Queue)new InitialContext().lookup(qn);
                }
                catch (NamingException ne) {
                    this.ourQueue = (Queue)ctx.lookup(qn);
                }
            }
            catch (Throwable t) {
                if (this.debug()) {
                    this.error(t);
                }
                throw new NotificationException(t);
            }
        }
        catch (NotificationException ne) {
            throw ne;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new NotificationException(t);
        }
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Throwable t) {
            this.warn(t.getMessage());
        }
    }

    public Session getSession() {
        return this.session;
    }

    public MessageProducer getProducer() throws NotificationException {
        try {
            MessageProducer sender = this.session.createProducer((Destination)this.ourQueue);
            this.connection.start();
            return sender;
        }
        catch (JMSException je) {
            throw new NotificationException(je);
        }
    }

    public MessageConsumer getConsumer() throws NotificationException {
        try {
            this.consumer = this.session.createConsumer((Destination)this.ourQueue);
            this.connection.start();
            return this.consumer;
        }
        catch (JMSException je) {
            throw new NotificationException(je);
        }
    }

    public Message receive() throws NotificationException {
        try {
            return this.consumer.receive();
        }
        catch (JMSException je) {
            throw new NotificationException(je);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getPr() throws NotificationException {
        Object object = lockit;
        synchronized (object) {
            Properties properties;
            InputStream is;
            block24: {
                Properties properties2;
                block23: {
                    if (pr != null) {
                        return pr;
                    }
                    is = null;
                    try {
                        SystemProperties sysProps = CalSvcFactoryDefault.getSystemProperties();
                        pr = new Properties();
                        if (!Util.isEmpty((Collection)sysProps.getSyseventsProperties())) {
                            StringBuilder sb = new StringBuilder();
                            List ps = sysProps.getSyseventsProperties();
                            for (String p : ps) {
                                sb.append(p);
                                sb.append("\n");
                            }
                            pr.load(new StringReader(sb.toString()));
                            properties2 = pr;
                            break block23;
                        }
                        try {
                            ClassLoader cl = Thread.currentThread().getContextClassLoader();
                            is = cl.getResourceAsStream(propertiesFile);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (is == null) {
                            is = JmsConnectionHandler.class.getResourceAsStream(propertiesFile);
                        }
                        if (is == null) {
                            throw new NotificationException("Unable to load properties file \"/sysevents.properties\"");
                        }
                        pr.load(is);
                        properties = pr;
                        break block24;
                    }
                    catch (NotificationException cee) {
                        throw cee;
                    }
                    catch (Throwable t) {
                        this.error("getEnv error", t);
                        throw new NotificationException(t.getMessage());
                    }
                }
                return properties2;
            }
            return properties;
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    static {
        lockit = new Object();
    }
}

