/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.util;

import java.util.Collection;
import org.bedework.caldav.util.notifications.BaseNotificationType;
import org.bedework.caldav.util.notifications.CalendarChangesType;
import org.bedework.caldav.util.notifications.ChangedByType;
import org.bedework.caldav.util.notifications.ChangedPropertyType;
import org.bedework.caldav.util.notifications.ChangesType;
import org.bedework.caldav.util.notifications.CreatedType;
import org.bedework.caldav.util.notifications.DeletedDetailsType;
import org.bedework.caldav.util.notifications.DeletedType;
import org.bedework.caldav.util.notifications.NotificationType;
import org.bedework.caldav.util.notifications.RecurrenceType;
import org.bedework.caldav.util.notifications.ResourceChangeType;
import org.bedework.caldav.util.notifications.UpdatedType;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwLongString;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.calfacade.util.ChangeTableEntry;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.DateTimeUtil;

public class NotificationsInfo {
    public static String added(String currentAuth, BwEvent ev) {
        NotificationType note = NotificationsInfo.getNotification();
        note.setNotification((BaseNotificationType)NotificationsInfo.getAdded(currentAuth, ev));
        return note.toXml(true);
    }

    public static String deleted(String currentAuth, BwEvent ev) {
        NotificationType note = NotificationsInfo.getNotification();
        note.setNotification((BaseNotificationType)NotificationsInfo.getDeleted(currentAuth, ev));
        return note.toXml(true);
    }

    public static String updated(String currentAuth, BwEvent ev) {
        ResourceChangeType rc = NotificationsInfo.getUpdated(currentAuth, ev);
        if (rc == null) {
            return null;
        }
        NotificationType note = NotificationsInfo.getNotification();
        note.setNotification((BaseNotificationType)rc);
        return note.toXml(true);
    }

    public static ResourceChangeType getDeleted(String currentAuth, BwEvent ev) {
        ResourceChangeType rc = new ResourceChangeType();
        DeletedType del = new DeletedType();
        del.setHref(NotificationsInfo.getHref(ev));
        del.setChangedBy(NotificationsInfo.getChangedBy(currentAuth));
        DeletedDetailsType dd = new DeletedDetailsType();
        dd.setDeletedComponent(NotificationsInfo.getType(ev));
        dd.setDeletedSummary(ev.getSummary());
        if (ev.getDtstart() != null) {
            ChangedPropertyType start = new ChangedPropertyType();
            start.setName(PropertyIndex.PropertyInfoIndex.DTSTART.name());
            start.setDataFrom(String.valueOf(ev.getDtstart()));
            dd.getDeletedProps().add(start);
        }
        if (ev.getDtend() != null) {
            ChangedPropertyType end = new ChangedPropertyType();
            end.setName(PropertyIndex.PropertyInfoIndex.DTEND.name());
            end.setDataFrom(String.valueOf(ev.getDtend()));
            dd.getDeletedProps().add(end);
        }
        if (ev.getDuration() != null && !ev.getDuration().isEmpty()) {
            ChangedPropertyType dur = new ChangedPropertyType();
            dur.setName(PropertyIndex.PropertyInfoIndex.DURATION.name());
            dur.setDataFrom(ev.getDuration());
            dd.getDeletedProps().add(dur);
        }
        if (ev.getLocation() != null) {
            ChangedPropertyType loc = new ChangedPropertyType();
            loc.setName(PropertyIndex.PropertyInfoIndex.LOCATION.name());
            loc.setDataFrom(ev.getLocation().getAddress().getValue());
            dd.getDeletedProps().add(loc);
        }
        if (ev.getDescription() != null) {
            ChangedPropertyType desc = new ChangedPropertyType();
            desc.setName(PropertyIndex.PropertyInfoIndex.DESCRIPTION.name());
            desc.setDataFrom(ev.getDescription());
            dd.getDeletedProps().add(desc);
        }
        del.setDeletedDetails(dd);
        rc.setDeleted(del);
        return rc;
    }

    public static ResourceChangeType getAdded(String currentAuth, BwEvent ev) {
        ResourceChangeType rc = new ResourceChangeType();
        CreatedType cre = new CreatedType();
        cre.setHref(NotificationsInfo.getHref(ev));
        cre.setChangedBy(NotificationsInfo.getChangedBy(currentAuth));
        rc.setCreated(cre);
        return rc;
    }

    public static ResourceChangeType getUpdated(String currentAuth, BwEvent ev) {
        ChangeTable changes = ev.getChangeset(currentAuth);
        if (changes.isEmpty()) {
            return null;
        }
        ResourceChangeType rc = new ResourceChangeType();
        UpdatedType upd = new UpdatedType();
        upd.setHref(NotificationsInfo.getHref(ev));
        upd.setChangedBy(NotificationsInfo.getChangedBy(currentAuth));
        upd.getCalendarChanges().add(NotificationsInfo.instanceChanges(currentAuth, ev));
        rc.addUpdate(upd);
        return rc;
    }

    private NotificationsInfo() {
    }

    private static ChangedByType getChangedBy(String currentAuth) {
        ChangedByType cb = new ChangedByType();
        cb.setCommonName(currentAuth);
        cb.setDtstamp(DateTimeUtil.rfcDateTime());
        cb.setHref(currentAuth);
        return cb;
    }

    private static NotificationType getNotification() {
        NotificationType note = new NotificationType();
        note.setDtstamp(DateTimeUtil.rfcDateTime());
        return note;
    }

    private static CalendarChangesType instanceChanges(String currentAuth, BwEvent ev) {
        CalendarChangesType cc = new CalendarChangesType();
        RecurrenceType r = new RecurrenceType();
        r.setRecurrenceid(ev.getRecurrenceId());
        ChangesType c = new ChangesType();
        for (ChangeTableEntry cte : ev.getChangeset(currentAuth).getEntries()) {
            if (!cte.getChanged()) continue;
            if (cte.getIndex() == PropertyIndex.PropertyInfoIndex.XPROP) {
                ChangedPropertyType cp;
                if (!Util.isEmpty((Collection)cte.getRemovedValues())) {
                    for (BwXproperty xp : cte.getRemovedValues()) {
                        cp = new ChangedPropertyType();
                        cp.setName(xp.getName());
                        cp.setDataFrom(String.valueOf(xp));
                        c.getChangedProperty().add(cp);
                    }
                }
                if (Util.isEmpty((Collection)cte.getAddedValues())) continue;
                for (BwXproperty xp : cte.getAddedValues()) {
                    cp = new ChangedPropertyType();
                    cp.setName(xp.getName());
                    cp.setDataTo(String.valueOf(xp));
                    c.getChangedProperty().add(cp);
                }
                continue;
            }
            ChangedPropertyType cp = new ChangedPropertyType();
            cp.setName(cte.getIndex().name());
            cp.setDataFrom(NotificationsInfo.getDataFrom(cte));
            cp.setDataTo(NotificationsInfo.getDataTo(cte));
            c.getChangedProperty().add(cp);
        }
        r.getChanges().add(c);
        cc.getRecurrence().add(r);
        return cc;
    }

    private static String getDataFrom(ChangeTableEntry cte) {
        return NotificationsInfo.getData(cte, cte.getOldVal());
    }

    private static String getDataTo(ChangeTableEntry cte) {
        return NotificationsInfo.getData(cte, cte.getNewVal());
    }

    private static String getData(ChangeTableEntry cte, Object o) {
        if (o == null) {
            return null;
        }
        if (!cte.getIndex().getDbMultiValued()) {
            if (o instanceof BwString) {
                return ((BwString)o).getValue();
            }
            if (o instanceof BwLongString) {
                return ((BwLongString)o).getValue();
            }
            if (o instanceof BwLocation) {
                return ((BwLocation)o).getAddress().getValue();
            }
            if (o instanceof BwXproperty) {
                return ((BwXproperty)o).getValue();
            }
            return String.valueOf(o);
        }
        if (o instanceof BwString) {
            return ((BwString)o).getValue();
        }
        if (o instanceof BwLongString) {
            return ((BwLongString)o).getValue();
        }
        if (o instanceof BwLocation) {
            return ((BwLocation)o).getAddress().getValue();
        }
        if (o instanceof BwXproperty) {
            return ((BwXproperty)o).getValue();
        }
        return String.valueOf(o);
    }

    private static String getType(BwEvent ev) {
        try {
            return IcalDefs.entityTypeIcalNames[ev.getEntityType()];
        }
        catch (Throwable t) {
            return "X";
        }
    }

    private static String getHref(BwEvent ev) {
        return Util.buildPath((boolean)false, (String[])new String[]{ev.getColPath(), "/", ev.getName()});
    }
}

