/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.base;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.DateProperty;
import org.bedework.calfacade.BwDateTime;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class BwTimeRange
implements Logged {
    private BwDateTime start;
    private BwDateTime end;
    private BwLogger logger = new BwLogger();

    public BwTimeRange() {
    }

    public BwTimeRange(BwDateTime start, BwDateTime end) {
        this.start = start;
        this.end = end;
    }

    public void setStart(BwDateTime val) {
        this.start = val;
    }

    public BwDateTime getStart() {
        return this.start;
    }

    public void setEnd(BwDateTime val) {
        this.end = val;
    }

    public BwDateTime getEnd() {
        return this.end;
    }

    public void merge(BwTimeRange that) {
        if (this.getStart().before(that.getStart())) {
            this.setStart(that.getStart());
        }
        if (this.getEnd().after(that.getEnd())) {
            this.setEnd(that.getEnd());
        }
    }

    public boolean matches(Property candidate) {
        return candidate instanceof DateProperty;
    }

    public void dump(String indent) {
        this.debug(indent + this.toString());
    }

    protected void toStringSegment(StringBuffer sb) {
        if (this.start != null) {
            sb.append("start=");
            sb.append(this.start);
        }
        if (this.end != null) {
            if (this.start != null) {
                sb.append(" ");
            }
            sb.append("end=");
            sb.append(this.end);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<time-range ");
        this.toStringSegment(sb);
        sb.append("/>");
        return sb.toString();
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

