/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.parameter.Language;
import org.bedework.calfacade.annotations.ical.IcalProperty;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.base.SizedEntity;
import org.bedework.calfacade.locale.BwLocale;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.calfacade.util.QuotaUtil;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public class BwStringBase<T extends BwStringBase>
extends BwDbentity<T>
implements SizedEntity {
    private String lang;
    private String value;

    public BwStringBase() {
    }

    public BwStringBase(String lang, String value) {
        this.lang = lang;
        this.value = value;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LANG)
    public void setLang(String val) {
        this.lang = val;
    }

    public String getLang() {
        return this.lang;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.VALUE)
    public void setValue(String val) {
        this.value = val;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean hasDumpValue() {
        return this.getValue() != null && this.getValue().length() > 0;
    }

    protected static BwStringBase findLanguage(String lang, Collection<? extends BwStringBase> c) {
        if (c == null) {
            return null;
        }
        BwStringBase matched = null;
        BwStringBase def = null;
        int len = 0;
        if (lang != null) {
            len = lang.length();
        }
        for (BwStringBase bwStringBase : c) {
            if (def == null) {
                def = bwStringBase;
            }
            String slang = bwStringBase.getLang();
            if (lang == null) {
                if (slang != null && CalFacadeUtil.cmpObjval(BwLocale.getLang(), slang) != 0) continue;
                return bwStringBase;
            }
            if (CalFacadeUtil.cmpObjval(lang, slang) == 0) {
                return bwStringBase;
            }
            if (matched != null || len <= 0 || len >= slang.length() || !slang.startsWith(lang)) continue;
            matched = bwStringBase;
            def = bwStringBase;
        }
        return def;
    }

    public boolean update(BwStringBase from) {
        boolean changed = false;
        if (CalFacadeUtil.cmpObjval(this.getLang(), from.getLang()) != 0) {
            this.setLang(from.getLang());
            changed = true;
        }
        if (CalFacadeUtil.cmpObjval(this.getValue(), from.getValue()) != 0) {
            this.setValue(from.getValue());
            changed = true;
        }
        return changed;
    }

    public Parameter getLangPar() {
        if (this.getLang() == null) {
            return null;
        }
        return new Language(this.getLang());
    }

    public boolean checkNulls() {
        boolean changed = false;
        String str = Util.checkNull((String)this.getLang());
        if (CalFacadeUtil.compareStrings(str, this.getLang()) != 0) {
            this.setLang(str);
            changed = true;
        }
        if (CalFacadeUtil.compareStrings(str = Util.checkNull((String)this.getValue()), this.getValue()) != 0) {
            this.setValue(str);
            changed = true;
        }
        return changed;
    }

    @Override
    @JsonIgnore
    public int getSize() {
        return super.length() + QuotaUtil.size(this.getLang()) + QuotaUtil.size(this.getValue());
    }

    @Override
    public int compareTo(T that) {
        if (that == this) {
            return 0;
        }
        if (that == null) {
            return -1;
        }
        int res = CalFacadeUtil.cmpObjval(this.getLang(), ((BwStringBase)that).getLang());
        if (res != 0) {
            return res;
        }
        return CalFacadeUtil.cmpObjval(this.getValue(), ((BwStringBase)that).getValue());
    }

    @Override
    public int hashCode() {
        int hc = 7;
        if (this.getLang() != null) {
            hc *= this.getLang().hashCode();
        }
        if (this.getValue() != null) {
            hc *= this.getValue().hashCode();
        }
        return hc;
    }

    @Override
    protected void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.append("lang", (Object)this.getLang()).append("value", (Object)this.getValue());
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    @Override
    public Object clone() {
        return new BwStringBase<T>(this.getLang(), this.getValue());
    }
}

