/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.util.misc.ToString;

@Dump(elementName="group", keyFields={"account"})
@NoDump(value={"byteSize"})
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class BwGroup<T extends BwGroup<?>>
extends BwPrincipal<T> {
    private Collection<BwPrincipal<?>> groupMembers;
    private Set<String> memberHrefs;

    @Override
    @NoDump
    public int getKind() {
        return 2;
    }

    public void setGroupMembers(Collection<BwPrincipal<?>> val) {
        this.groupMembers = val;
    }

    @Dump(collectionElementName="member")
    public Collection<BwPrincipal<?>> getGroupMembers() {
        return this.groupMembers;
    }

    public void setMemberHrefs(Set<String> val) {
        this.memberHrefs = val;
    }

    @NoDump
    public Set<String> getMemberHrefs() {
        return this.memberHrefs;
    }

    public boolean isMember(String account, boolean group) {
        Collection<BwPrincipal<?>> ms = this.getGroupMembers();
        if (ms == null) {
            return false;
        }
        for (BwPrincipal<?> mbr : ms) {
            if (!mbr.getAccount().equals(account) || group != mbr instanceof BwGroup) continue;
            return true;
        }
        return false;
    }

    public boolean addGroupMember(BwPrincipal<?> mbr) {
        Collection<BwPrincipal<?>> ms = this.getGroupMembers();
        if (ms == null) {
            ms = new TreeSet();
            this.setGroupMembers(ms);
        }
        return ms.add(mbr);
    }

    @Override
    protected void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ArrayList<String> refs = new ArrayList<String>();
        Collection<BwPrincipal<?>> ms = this.getGroupMembers();
        if (ms != null) {
            for (BwPrincipal<?> mbr : ms) {
                refs.add(mbr.getPrincipalRef());
            }
        }
        ts.newLine().append("groupMembers", refs);
    }

    public boolean removeGroupMember(BwPrincipal<?> mbr) {
        Collection<BwPrincipal<?>> ms = this.getGroupMembers();
        if (ms == null) {
            return false;
        }
        return this.getGroupMembers().remove(mbr);
    }

    @Override
    public void copyTo(BwGroup<?> val) {
        super.copyTo(val);
        Collection<BwPrincipal<?>> ms = this.getGroupMembers();
        if (ms != null) {
            for (BwPrincipal<?> mbr : ms) {
                val.addGroupMember((BwPrincipal)mbr.clone());
            }
        }
    }

    public void shallowCopyTo(BwGroup<?> val) {
        super.copyTo(val);
    }

    public BwGroup<?> shallowClone() {
        BwGroup<T> g = new BwGroup<T>();
        this.shallowCopyTo(g);
        return g;
    }

    @Override
    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwGroup<T> g = new BwGroup<T>();
        this.copyTo(g);
        return g;
    }
}

