/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bedework.util.misc.Util;

public class FieldSplitter {
    final String fieldDelimiter;
    List<String> flds;

    public FieldSplitter(String fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public void setVal(String fld) {
        if (fld != null) {
            this.flds = new ArrayList<String>(Arrays.asList(fld.split(this.fieldDelimiter)));
        }
    }

    public void setFld(int i, String val) {
        String checkVal = val == null ? null : val.replace(this.fieldDelimiter, "-");
        if (this.flds == null) {
            this.flds = new ArrayList<String>(i + 1);
        }
        while (i > this.flds.size() - 1) {
            this.flds.add(null);
        }
        this.flds.set(i, checkVal);
    }

    public String getFld(int i) {
        if (this.flds == null) {
            return null;
        }
        if (i >= this.flds.size()) {
            return null;
        }
        String s = this.flds.get(i);
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    public void setFlds(List<String> vals) {
        if (Util.isEmpty(vals)) {
            this.setVal(null);
            return;
        }
        for (int i = 0; i < vals.size(); ++i) {
            this.setFld(i, vals.get(i));
        }
    }

    public List<String> getFlds() {
        return this.flds;
    }

    public String getCombined() {
        if (this.flds == null) {
            return null;
        }
        StringBuilder fld = new StringBuilder();
        for (String s : this.flds) {
            if (fld.length() != 0) {
                fld.append(this.fieldDelimiter);
            }
            if (s == null) continue;
            fld.append(s);
        }
        return fld.toString();
    }
}

