/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.util;

import java.util.Date;
import java.util.TreeSet;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwFreeBusyComponent;
import org.bedework.calfacade.util.EventPeriod;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.timezones.Timezones;

public class EventPeriods
implements Logged {
    private BwDateTime start;
    private String startTzid;
    private DateTime dtstart;
    private BwDateTime end;
    private String endTzid;
    private DateTime dtend;
    private Object[] periods = new Object[4];
    private BwLogger logger = new BwLogger();

    public EventPeriods(BwDateTime start, BwDateTime end) {
        this.start = start;
        this.end = end;
        this.startTzid = start.getTzid();
        this.endTzid = end.getTzid();
        try {
            this.dtstart = new DateTime(Timezones.getUtc((String)start.getDtval(), (String)this.startTzid));
            this.dtend = new DateTime(Timezones.getUtc((String)end.getDtval(), (String)this.endTzid));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        this.dtstart.setUtc(true);
        this.dtend.setUtc(true);
    }

    public void addPeriod(BwDateTime pstart, BwDateTime pend, int type) {
        DateTime pedt;
        DateTime psdt;
        if (pstart.after(this.end) || pend.before(this.start)) {
            return;
        }
        String dstart = pstart.before(this.start) ? this.start.getDate() : pstart.getDate();
        String dend = pend.after(this.end) ? this.end.getDate() : pend.getDate();
        try {
            psdt = new DateTime(dstart);
            pedt = new DateTime(dend);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        psdt.setUtc(true);
        pedt.setUtc(true);
        this.add(new EventPeriod(psdt, pedt, type));
    }

    public void addPeriod(DateTime pstart, DateTime pend, int type) {
        if (pstart.after((Date)this.dtend) || pend.before((Date)this.dtstart)) {
            return;
        }
        if (pstart.before((Date)this.dtstart)) {
            pstart = this.dtstart;
        }
        if (pend.after((Date)this.dtend)) {
            pend = this.dtend;
        }
        this.add(new EventPeriod(pstart, pend, type));
    }

    public BwFreeBusyComponent makeFreeBusyComponent(int type) {
        TreeSet eventPeriods = (TreeSet)this.periods[type];
        if (eventPeriods == null) {
            return null;
        }
        BwFreeBusyComponent fbc = new BwFreeBusyComponent();
        fbc.setType(type);
        Period p = null;
        for (EventPeriod ep : eventPeriods) {
            if (this.debug()) {
                this.trace(ep.toString());
            }
            if (p == null) {
                p = new Period(ep.getStart(), ep.getEnd());
                continue;
            }
            if (ep.getStart().after((Date)p.getEnd())) {
                fbc.addPeriod(p.getStart(), p.getEnd());
                p = new Period(ep.getStart(), ep.getEnd());
                continue;
            }
            if (!ep.getEnd().after((Date)p.getEnd())) continue;
            p = new Period(p.getStart(), ep.getEnd());
        }
        if (p != null) {
            fbc.addPeriod(p.getStart(), p.getEnd());
        }
        return fbc;
    }

    private void add(EventPeriod p) {
        TreeSet<EventPeriod> eps = (TreeSet<EventPeriod>)this.periods[p.getType()];
        if (eps == null) {
            this.periods[p.getType()] = eps = new TreeSet<EventPeriod>();
        }
        eps.add(p);
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

