/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.util;

import java.util.Date;
import net.fortuna.ical4j.model.DateTime;
import org.bedework.util.misc.ToString;

public class EventPeriod
implements Comparable<EventPeriod> {
    private DateTime start;
    private DateTime end;
    private int type;
    private int numBusy;
    private int numTentative;

    public EventPeriod(DateTime start, DateTime end, int type) {
        this.start = start;
        this.end = end;
        this.type = type;
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public void setType(int val) {
        this.type = val;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public int compareTo(EventPeriod that) {
        if (this.type < that.type) {
            return -1;
        }
        if (this.type > that.type) {
            return 1;
        }
        int res = this.start.compareTo((Date)that.start);
        if (res != 0) {
            return res;
        }
        return this.end.compareTo((Date)that.end);
    }

    public void setNumBusy(int val) {
        this.numBusy = val;
    }

    public int getNumBusy() {
        return this.numBusy;
    }

    public void setNumTentative(int val) {
        this.numTentative = val;
    }

    public int getNumTentative() {
        return this.numTentative;
    }

    public boolean equals(Object o) {
        if (o instanceof EventPeriod) {
            return this.compareTo((EventPeriod)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return 7 * (this.type + 1) * (this.start.hashCode() + 1) * (this.end.hashCode() + 1);
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append("start", (Object)this.start);
        ts.append("end", (Object)this.end);
        ts.append("type", this.type);
        return ts.toString();
    }
}

