/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.bedework.calfacade.base.BwCloneable;

public class CalFacadeUtil
implements Serializable {
    private CalFacadeUtil() {
    }

    public static <T extends BwCloneable> boolean updateCollection(boolean cloned, Collection<T> from, Collection<T> to) {
        return CalFacadeUtil.updateCollection(cloned, from, to, null, null);
    }

    public static <T extends BwCloneable> boolean updateCollection(boolean cloned, Collection<T> from, Collection<T> to, Collection<T> added, Collection<T> removed) {
        boolean changed = false;
        if (from != null) {
            for (Object o : from) {
                if (to.contains(o)) continue;
                if (added != null) {
                    added.add(o);
                }
                if (cloned) {
                    to.add((BwCloneable)o.clone());
                } else {
                    to.add(o);
                }
                changed = true;
            }
        }
        Collection deleted = Objects.requireNonNullElseGet(removed, ArrayList::new);
        for (BwCloneable o : to) {
            if (from != null && from.contains(o)) continue;
            deleted.add(o);
        }
        int numDeleted = deleted.size();
        if (numDeleted != 0) {
            changed = true;
            if (numDeleted == to.size()) {
                to.clear();
            } else {
                for (BwCloneable o : deleted) {
                    to.remove(o);
                }
            }
        }
        return changed;
    }

    public static int compareStrings(String s1, String s2) {
        if (s1 == null) {
            if (s2 != null) {
                return -1;
            }
            return 0;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static boolean eqObjval(Object thisone, Object thatone) {
        if (thisone == null) {
            return thatone == null;
        }
        if (thatone == null) {
            return false;
        }
        return thisone.equals(thatone);
    }

    public static <T extends Comparable<T>> int cmpObjval(T thisone, T thatone) {
        if (thisone == null) {
            if (thatone == null) {
                return 0;
            }
            return -1;
        }
        if (thatone == null) {
            return 1;
        }
        return thisone.compareTo(thatone);
    }

    public static <T extends Comparable<T>> int cmpObjval(Collection<T> thisone, Collection<T> thatone) {
        int thatLen;
        if (thisone == null) {
            if (thatone == null) {
                return 0;
            }
            return -1;
        }
        if (thatone == null) {
            return 1;
        }
        int thisLen = thisone.size();
        int res = Integer.compare(thisLen, thatLen = thatone.size());
        if (res != 0) {
            return res;
        }
        Iterator<T> thatIt = thatone.iterator();
        for (Comparable c : thisone) {
            res = CalFacadeUtil.cmpObjval(c, (Comparable)thatIt.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static String getTimeFromMinutes(int minutes) {
        return CalFacadeUtil.pad2(minutes / 60) + CalFacadeUtil.pad2(minutes % 60);
    }

    private static String pad2(int val) {
        if (val > 9) {
            return String.valueOf(val);
        }
        return "0" + val;
    }
}

