/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.svc.prefs;

import java.io.Serializable;
import java.util.Collection;
import java.util.TreeSet;
import org.bedework.calfacade.base.DumpEntity;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.util.misc.ToString;

public class CollectionPref<T extends Comparable<T>>
extends DumpEntity<T>
implements Serializable {
    protected boolean autoAdd = true;
    protected Collection<T> preferred;

    public void setAutoAdd(boolean val) {
        this.autoAdd = val;
    }

    public boolean getAutoAdd() {
        return this.autoAdd;
    }

    public void setPreferred(Collection<T> val) {
        this.preferred = val;
    }

    public Collection<T> getPreferred() {
        return this.preferred;
    }

    public boolean add(T val) {
        Collection<T> c = this.getPreferred();
        if (c == null) {
            c = new TreeSet<T>();
            this.setPreferred(c);
        }
        if (c.contains(val)) {
            return false;
        }
        c.add(val);
        return true;
    }

    public boolean remove(T val) {
        Collection<T> c = this.getPreferred();
        if (c == null || !c.contains(val)) {
            return false;
        }
        return c.remove(val);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        CollectionPref that = (CollectionPref)obj;
        if (that.getAutoAdd() != this.getAutoAdd()) {
            return false;
        }
        return CalFacadeUtil.eqObjval(this.getPreferred(), that.getPreferred());
    }

    public int hashCode() {
        Collection<T> c;
        int h = 1;
        if (this.getAutoAdd()) {
            h = 2;
        }
        if ((c = this.getPreferred()) != null) {
            h *= c.hashCode();
        }
        return h;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append("autoAdd", this.getAutoAdd());
        ts.append("preferred", this.getPreferred());
        return ts.toString();
    }

    public Object clone() {
        CollectionPref<T> cp = new CollectionPref<T>();
        cp.setAutoAdd(this.getAutoAdd());
        Collection<T> c = this.getPreferred();
        if (c != null) {
            cp.setPreferred(new TreeSet<T>(c));
        }
        return cp;
    }
}

