/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.svc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.access.CurrentAccess;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventAnnotation;
import org.bedework.calfacade.BwEventProxy;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.base.BwUnversionedDbentity;
import org.bedework.calfacade.svc.EventOverride;
import org.bedework.calfacade.svc.SchedulingInfo;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.Response;

public class EventInfo
extends BwUnversionedDbentity<EventInfo>
implements Comparable<EventInfo>,
Comparator<EventInfo>,
Serializable {
    private EventInfo retrievedEvent;
    private EventInfo parent;
    protected BwEvent event;
    private SchedulingInfo schedulingInfo;
    protected boolean editable;
    protected boolean fromRef;
    public boolean recurrenceSeen;
    public static final int kindEntry = 0;
    public static final int kindAdded = 1;
    public static final int kindUndeletable = 2;
    private int kind;
    private static final String[] kindStr = new String[]{"entry", "reffed", "subscribed"};
    private boolean newEvent;
    private boolean instanceOnly;
    private String prevStag;
    private String prevCtoken;
    private Collection<BwAlarm> alarms = null;
    private Set<EventOverride> overrides;
    private Set<EventOverride> retrievedOverrides;
    private Set<String> overrideIds;
    private Set<EventInfo> containedItems;
    private CurrentAccess currentAccess;
    private String replyAttendeeURI;
    private String inboxEventName;
    private UpdateResult updResult;
    private boolean replyUpdate;

    public EventInfo(BwEvent event) {
        this.setEvent(event);
    }

    public EventInfo(BwEvent event, Set<EventInfo> overrides) {
        this.setEvent(event);
        this.overrides = new TreeSet<EventOverride>();
        for (EventInfo oei : overrides) {
            if (oei.getEvent().getRecurrenceId() == null) {
                throw new RuntimeException("No recurrence id in override");
            }
            this.overrides.add(new EventOverride(oei));
            oei.parent = this;
        }
        this.retrievedOverrides = new TreeSet<EventOverride>(this.overrides);
    }

    @Override
    public void setId(int val) {
        this.getEvent().setId(val);
    }

    @Override
    @JsonIgnore
    public int getId() {
        return this.getEvent().getId();
    }

    @Override
    public void setHref(String val) {
        this.getEvent().setHref(val);
    }

    @Override
    public String getHref() {
        return this.getEvent().getHref();
    }

    public BwEvent getEvent() {
        return this.event;
    }

    public EventInfo getParent() {
        return this.parent;
    }

    public void setRetrievedEvent(EventInfo val) {
        this.retrievedEvent = val;
    }

    public EventInfo getRetrievedEvent() {
        return this.retrievedEvent;
    }

    public void setEditable(boolean val) {
        this.editable = val;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public boolean getFromRef() {
        return this.fromRef;
    }

    public void setKind(int val) {
        this.kind = val;
    }

    public int getKind() {
        return this.kind;
    }

    public void setNewEvent(boolean val) {
        this.newEvent = val;
    }

    public boolean getNewEvent() {
        return this.newEvent;
    }

    public SchedulingInfo getSchedulingInfo() {
        if (this.schedulingInfo != null) {
            return this.schedulingInfo;
        }
        SchedulingInfo si = new SchedulingInfo();
        BwEvent ev = this.getEvent();
        si.setMasterSuppressed(this.getEvent().getSuppressed());
        if (!ev.getSuppressed()) {
            si.setMaxAttendees(ev.getNumAttendees());
            si.setOrganizer(ev.getOrganizer());
        }
        if (this.getNumOverrides() > 0) {
            for (EventInfo oei : this.getOverrides()) {
                BwEvent oev = oei.getEvent();
                si.setMaxAttendees(Math.max(si.getMaxAttendees(), oev.getNumAttendees()));
                if (si.getOrganizer() != null) continue;
                si.setOrganizer(oev.getOrganizer());
            }
        }
        this.schedulingInfo = si;
        return this.schedulingInfo;
    }

    public void setReplyUpdate(boolean val) {
        this.replyUpdate = val;
    }

    public boolean getReplyUpdate() {
        return this.replyUpdate;
    }

    public void setInstanceOnly(boolean val) {
        this.instanceOnly = val;
    }

    public boolean getInstanceOnly() {
        return this.instanceOnly;
    }

    public void setPrevStag(String val) {
        this.prevStag = val;
    }

    public String getPrevStag() {
        return this.prevStag;
    }

    public void setPrevCtoken(String val) {
        this.prevCtoken = val;
    }

    public String getPrevCtoken() {
        return this.prevCtoken;
    }

    public String getRecurrenceId() {
        if (this.event == null) {
            return null;
        }
        return this.event.getRecurrenceId();
    }

    public void setCurrentAccess(CurrentAccess val) {
        this.currentAccess = val;
    }

    public CurrentAccess getCurrentAccess() {
        return this.currentAccess;
    }

    public ChangeTable getChangeset(String userHref) {
        if (this.event == null) {
            return null;
        }
        return this.event.getChangeset(userHref);
    }

    public void clearChangeset() {
        if (this.event == null) {
            return;
        }
        this.event.clearChangeset();
    }

    public UpdateResult getUpdResult() {
        if (this.updResult == null) {
            this.updResult = new UpdateResult();
        }
        return this.updResult;
    }

    public boolean getOverridesChanged() {
        if (this.overrides == null && this.retrievedOverrides == null) {
            return false;
        }
        if (this.getNumOverrides() != this.retrievedOverrides.size()) {
            return true;
        }
        if (this.getNumOverrides() == 0) {
            return false;
        }
        for (EventOverride oe : this.overrides) {
            if (this.retrievedOverrides.contains(oe)) continue;
            return true;
        }
        return false;
    }

    public void setAlarms(Collection<BwAlarm> val) {
        this.alarms = val;
    }

    public Collection<BwAlarm> getAlarms() {
        return this.alarms;
    }

    public int getNumAlarms() {
        Collection<BwAlarm> as = this.getAlarms();
        if (as == null) {
            return 0;
        }
        return as.size();
    }

    public void clearAlarms() {
        Collection<BwAlarm> as = this.getAlarms();
        if (as != null) {
            as.clear();
        }
    }

    public void addAlarm(BwAlarm val) {
        Collection<BwAlarm> as = this.getAlarms();
        if (as == null) {
            as = new TreeSet<BwAlarm>();
        }
        if (!as.contains(val)) {
            as.add(val);
        }
    }

    public void setOverrideIds(Set<String> val) {
        this.overrideIds = val;
    }

    public Set<String> getOverrideIds() {
        return this.overrideIds;
    }

    public Set<EventInfo> getOverrides() {
        if (this.overrides == null) {
            return null;
        }
        TreeSet<EventInfo> eis = new TreeSet<EventInfo>();
        for (EventOverride eo : this.overrides) {
            eis.add(eo.getEventInfo());
        }
        return eis;
    }

    public int getNumOverrides() {
        Set<EventInfo> os = this.getOverrides();
        if (os == null) {
            return 0;
        }
        return os.size();
    }

    public void addOverride(EventInfo val) {
        if (val.getEvent().getRecurrenceId() == null) {
            throw new RuntimeException("No recurrence id in override");
        }
        if (this.overrides == null) {
            this.overrides = new TreeSet<EventOverride>();
        }
        EventOverride eo = new EventOverride(val);
        this.overrides.add(eo);
        val.parent = this;
    }

    public Collection<BwEventProxy> getOverrideProxies() {
        if (this.getNumOverrides() == 0) {
            return null;
        }
        TreeSet<BwEventProxy> proxies = new TreeSet<BwEventProxy>();
        for (EventInfo ei : this.getOverrides()) {
            BwEventProxy proxy = (BwEventProxy)ei.getEvent();
            proxies.add(proxy);
        }
        return proxies;
    }

    public Collection<BwEventProxy> getDeletedOverrideProxies(String userHref) {
        TreeSet<BwEventProxy> proxies = new TreeSet<BwEventProxy>();
        if (this.retrievedOverrides == null || this.instanceOnly) {
            return proxies;
        }
        for (EventOverride eo : this.retrievedOverrides) {
            if (this.overrides.contains(eo)) continue;
            BwEventProxy proxy = (BwEventProxy)eo.getEvent();
            if (proxy.getRef().unsaved()) {
                throw new RuntimeException("Unsaved override in delete list");
            }
            if (proxy.getXproperty("X-PERUSER-INSTANCE") == null) {
                proxies.add(proxy);
                continue;
            }
            BwXproperty pu = proxy.findPeruserXprop(userHref, "X-PERUSER-PROP-TRANSP");
            if (pu != null) {
                proxy.removeXproperty(pu);
            }
            ArrayList<BwAlarm> toRemove = new ArrayList<BwAlarm>();
            for (BwAlarm a : proxy.getAlarms()) {
                if (!a.getOwnerHref().equals(userHref)) continue;
                toRemove.add(a);
            }
            for (BwAlarm a : toRemove) {
                proxy.removeAlarm(a);
            }
            if (Util.isEmpty(proxy.getXproperties("X-PERUSER-PROP-TRANSP")) && Util.isEmpty(proxy.getAlarms())) {
                proxies.add(proxy);
            }
            ChangeTable chg = this.getChangeset(userHref);
            if (pu != null) {
                chg.addValue(PropertyIndex.PropertyInfoIndex.XPROP, pu);
            }
            if (Util.isEmpty(toRemove)) continue;
            for (BwAlarm a : toRemove) {
                chg.addValue(PropertyIndex.PropertyInfoIndex.VALARM, a);
            }
        }
        return proxies;
    }

    public EventInfo findOverride(String rid) {
        return this.findOverride(rid, true);
    }

    public EventInfo findOverride(String rid, boolean create) {
        if (this.overrides != null) {
            for (EventOverride eo : this.overrides) {
                if (!eo.getEvent().getRecurrenceId().equals(rid)) continue;
                return eo.getEventInfo();
            }
        }
        if (!create) {
            return null;
        }
        BwEventProxy proxy = BwEventProxy.makeAnnotation(this.getEvent(), null, true);
        proxy.setRecurring(Boolean.FALSE);
        EventInfo oei = new EventInfo(proxy);
        proxy.setRecurrenceId(rid);
        oei.setNewEvent(true);
        this.addOverride(oei);
        return oei;
    }

    public boolean removeOverride(String rid) {
        EventOverride ov = null;
        if (Util.isEmpty(this.overrides)) {
            return false;
        }
        for (EventOverride eo : this.overrides) {
            if (!eo.getEvent().getRecurrenceId().equals(rid)) continue;
            ov = eo;
            break;
        }
        if (ov == null) {
            return false;
        }
        this.overrides.remove(ov);
        return true;
    }

    public void setReplyAttendeeURI(String val) {
        this.replyAttendeeURI = val;
    }

    public String getReplyAttendeeURI() {
        return this.replyAttendeeURI;
    }

    public void setInboxEventName(String val) {
        this.inboxEventName = val;
    }

    public String getInboxEventName() {
        return this.inboxEventName;
    }

    public void setOnlyAttendee(EventInfo outEi, String attUri) {
        if (!this.getEvent().getSuppressed()) {
            BwEvent ev = this.getEvent();
            BwEvent outEv = outEi.getEvent();
            if (!Util.isEmpty(outEv.getAttendees())) {
                outEv.getAttendees().clear();
            }
            BwAttendee att = ev.findAttendee(attUri);
            outEv.addAttendee((BwAttendee)att.clone());
        }
        if (this.getNumOverrides() > 0) {
            for (EventInfo oei : this.getOverrides()) {
                BwEvent ev = oei.getEvent();
                EventInfo oOutEi = outEi.findOverride(ev.getRecurrenceId());
                BwEvent outEv = oOutEi.getEvent();
                if (!Util.isEmpty(outEv.getAttendees())) {
                    outEv.getAttendees().clear();
                }
                BwAttendee att = ev.findAttendee(attUri);
                outEv.addAttendee((BwAttendee)att.clone());
            }
        }
    }

    public void setContainedItems(Set<EventInfo> val) {
        this.containedItems = val;
    }

    public Set<EventInfo> getContainedItems() {
        return this.containedItems;
    }

    public void addContainedItem(EventInfo val) {
        Set<EventInfo> cis = this.getContainedItems();
        if (cis == null) {
            cis = new TreeSet<EventInfo>();
            this.setContainedItems(cis);
        }
        cis.add(val);
        val.parent = this;
    }

    public int getNumContainedItems() {
        Set<EventInfo> cis = this.getContainedItems();
        if (cis == null) {
            return 0;
        }
        return cis.size();
    }

    @Override
    public int compare(EventInfo e1, EventInfo e2) {
        if (e1 == e2) {
            return 0;
        }
        return e1.getEvent().compare(e1.getEvent(), e2.getEvent());
    }

    @Override
    public int compareTo(EventInfo that) {
        return this.compare(this, that);
    }

    @Override
    public int hashCode() {
        return this.getEvent().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventInfo)) {
            return false;
        }
        return this.compareTo((EventInfo)obj) == 0;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        if (this.getEvent() == null) {
            ts.append("eventId", (Object)null);
        } else {
            ts.append("eventId", this.getEvent().getId());
        }
        ts.append("editable", this.getEditable());
        ts.append("kind", (Object)kindStr[this.getKind()]);
        if (this.getAlarms() != null) {
            for (BwAlarm alarm : this.getAlarms()) {
                ts.append("alarm", (Object)alarm.toString());
            }
        }
        ts.append("recurrenceId", (Object)this.getEvent().getRecurrenceId());
        return ts.toString();
    }

    private void setEvent(BwEvent val) {
        this.event = val;
        this.fromRef = val instanceof BwEventAnnotation;
        this.setPrevStag(val.getStag());
        this.setPrevCtoken(val.getCtoken());
    }

    public static class UpdateResult
    extends Response {
        public boolean hasChanged;
        public boolean sequenceChange;
        public boolean doReschedule;
        public boolean adding;
        public boolean deleting;
        public boolean reply;
        public int locationsAdded;
        public int locationsRemoved;
        public int contactsAdded;
        public int sponsorsRemoved;
        public int categoriesAdded;
        public int categoriesRemoved;
        public Collection<BwEventProxy> failedOverrides;
        public List<String> deletedInstances;
        public Collection<BwAttendee> deletedAttendees;
        public String fromAttUri;
        public Integer pollWinner;
        public ScheduleResult schedulingResult;
    }
}

