/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.mail;

import java.net.URLDecoder;
import java.net.URLEncoder;
import org.bedework.calfacade.mail.Attachment;

public class FileAttachment
implements Attachment {
    private String dataPath;
    private String originalName;

    public FileAttachment() {
    }

    public FileAttachment(String dataPath, String originalName) {
        this.dataPath = dataPath;
        this.originalName = originalName;
    }

    public void setDataPath(String val) {
        this.dataPath = val;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setOriginalName(String val) {
        this.originalName = val;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public static FileAttachment fromString(String val) {
        FileAttachment mma;
        if (!val.startsWith("FileAttachment[")) {
            throw new RuntimeException("FileAttachment.fromString, bad value: " + val);
        }
        int start = val.indexOf("[");
        int gap = val.indexOf(" ");
        int end = val.indexOf("]");
        if (gap < 0 || end < 0) {
            throw new RuntimeException("FileAttachment.fromString, bad value: " + val);
        }
        try {
            mma = new FileAttachment(URLDecoder.decode(val.substring(start + 1, gap), "UTF-8"), URLDecoder.decode(val.substring(gap + 1, end), "UTF-8"));
        }
        catch (Throwable t) {
            throw new RuntimeException("FileAttachment.fromString, bad value: " + val);
        }
        return mma;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FileAttachment[");
        try {
            sb.append(URLEncoder.encode(this.dataPath, "UTF-8"));
            sb.append(" ");
            sb.append(URLEncoder.encode(this.originalName, "UTF-8"));
            sb.append("]");
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return sb.toString();
    }

    public boolean equals(Object val) {
        if (this == val) {
            return true;
        }
        if (!(val instanceof FileAttachment)) {
            return false;
        }
        FileAttachment that = (FileAttachment)val;
        return that.getDataPath().equals(this.getDataPath()) && that.getOriginalName().equals(this.getOriginalName());
    }

    public static void main(String[] args) {
        try {
            FileAttachment mma = new FileAttachment("easy/path/to/file", "easyname");
            System.out.println("Try an easy one");
            System.out.println(mma);
            FileAttachment mma1 = FileAttachment.fromString(mma.toString());
            System.out.println(mma1);
            System.out.println(mma1.getDataPath());
            System.out.println(mma1.getOriginalName());
            System.out.println("equals: " + mma.equals(mma1));
            mma = new FileAttachment("harder/pa th/to/file[]", "name with blank[s] and space(s)");
            System.out.println("\nTry a harder one");
            System.out.println(mma);
            mma1 = FileAttachment.fromString(mma.toString());
            System.out.println(mma1);
            System.out.println(mma1.getDataPath());
            System.out.println(mma1.getOriginalName());
            System.out.println("equals: " + mma.equals(mma1));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

