/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.locale;

import java.util.Collection;
import java.util.Locale;

public class BwLocale {
    private static ThreadLocal<BwLocale> threadCb = new ThreadLocal();
    private Locale currentLocale;

    public static void setLocale(Locale val) {
        BwLocale.getLocales().setCurrentLocale(val);
    }

    public static Locale getLocale() {
        return BwLocale.getLocales().getCurrentLocale();
    }

    public void setCurrentLocale(Locale val) {
        this.currentLocale = val;
    }

    public Locale getCurrentLocale() {
        if (this.currentLocale == null) {
            return Locale.getDefault();
        }
        return this.currentLocale;
    }

    public static BwLocale getLocales() {
        BwLocale loc = threadCb.get();
        if (loc == null) {
            loc = new BwLocale();
            threadCb.set(loc);
        }
        return loc;
    }

    public static Locale matchLocales(Collection<Locale> locales, Locale locale) {
        Locale possible = null;
        for (Locale l : locales) {
            if (l.equals(locale)) {
                return l;
            }
            if (possible != null || l.getLanguage() != locale.getLanguage()) continue;
            possible = l;
        }
        return possible;
    }

    public static String getLang() {
        Locale loc = BwLocale.getLocales().getCurrentLocale();
        String l = loc.getLanguage();
        if (l == null) {
            l = Locale.ENGLISH.getLanguage();
        }
        return l;
    }
}

