/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.indexing;

import java.util.ArrayList;
import java.util.List;
import org.bedework.calfacade.indexing.IndexStatistics;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.response.Response;

public class ReindexResponse
extends Response {
    private final String docType;
    private String indexName;
    private long processed;
    private long recurring;
    private long totalFailed;
    private final IndexStatistics stats;
    private List<Failure> failures;

    public ReindexResponse(String docType) {
        this.docType = docType;
        this.stats = new IndexStatistics(docType);
    }

    public String getDocType() {
        return this.docType;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String val) {
        this.indexName = val;
    }

    public long getProcessed() {
        return this.processed;
    }

    public void incProcessed() {
        ++this.processed;
    }

    public long getRecurring() {
        return this.recurring;
    }

    public void incRecurring() {
        ++this.recurring;
    }

    public long getTotalFailed() {
        return this.totalFailed;
    }

    public void incTotalFailed() {
        ++this.totalFailed;
    }

    public IndexStatistics getStats() {
        return this.stats;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public void addFailure(Failure val) {
        if (this.failures == null) {
            this.failures = new ArrayList<Failure>();
        }
        this.failures.add(val);
    }

    public void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.append("docType", (Object)this.getDocType());
        ts.append("indexName", (Object)this.getIndexName());
        ts.append("processed", Long.valueOf(this.getProcessed()));
        ts.append("recurring", Long.valueOf(this.getRecurring()));
        ts.append("totalFailed", Long.valueOf(this.getTotalFailed()));
        ts.append("failures", this.getFailures());
        ts.append("stats", (Object)this.getStats());
    }

    public static class Failure
    extends Response {
        private String hitInfo;
        private String source;

        public String getHitInfo() {
            return this.hitInfo;
        }

        public void setHitInfo(String val) {
            this.hitInfo = val;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String val) {
            this.source = val;
        }
    }
}

