/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.indexing;

import java.util.HashMap;
import java.util.Map;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.util.misc.ToString;

public class IndexStatistics {
    private String name;
    private final Map<BwIndexer.IndexedType, Long> counts = new HashMap<BwIndexer.IndexedType, Long>(BwIndexer.IndexedType.values().length);

    public IndexStatistics(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public long getCount(BwIndexer.IndexedType type) {
        return this.counts.getOrDefault((Object)type, 0L);
    }

    public synchronized void inc(BwIndexer.IndexedType type) {
        this.counts.put(type, this.getCount(type) + 1L);
    }

    public synchronized void inc(BwIndexer.IndexedType type, long val) {
        this.counts.put(type, this.getCount(type) + val);
    }

    public void toStringSegment(ToString ts) {
        ts.append("name", (Object)this.getName());
        for (BwIndexer.IndexedType it : this.counts.keySet()) {
            ts.append(it.name(), this.counts.get((Object)it));
        }
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }
}

