/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.indexing;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.caldav.util.filter.FilterBase;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwEventProperty;
import org.bedework.calfacade.BwFilterDef;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwResourceContent;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.filter.SortTerm;
import org.bedework.calfacade.indexing.IndexStatsResponse;
import org.bedework.calfacade.indexing.ReindexResponse;
import org.bedework.calfacade.indexing.SearchResult;
import org.bedework.calfacade.indexing.SearchResultEntry;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.response.GetEntitiesResponse;
import org.bedework.util.misc.response.GetEntityResponse;

public interface BwIndexer
extends Serializable {
    public static final String docTypeUnknown = "unknown";
    public static final String docTypePrincipal = "principal";
    public static final String docTypePreferences = "preferences";
    public static final String docTypeCollection = "collection";
    public static final String docTypeCategory = "category";
    public static final String docTypeLocation = "location";
    public static final String docTypeContact = "contact";
    public static final String docTypeFilter = "filter";
    public static final String docTypeEvent = "event";
    public static final String docTypeResource = "resource";
    public static final String docTypeResourceContent = "resourceContent";
    public static final String[] allDocTypes = new String[]{"unknown", "principal", "preferences", "collection", "category", "location", "contact", "filter", "event", "resource", "resourceContent"};
    public static final String[] masterDocTypes = new String[]{"masterEvent", null, "masterTask", "masterJournal", null, null, "masterAvailable", "masterVpoll"};
    public static final String[] overrideDocTypes = new String[]{"overrideEvent", null, "overrideTask", "overrideJournal", null, null, "overrideAvailable", "overrideVpoll"};
    public static final String[] masterOverrideEventTypes = new String[]{"masterEvent", "masterTask", "overrideEvent", "overrideTask", "masterAvailable", "overrideAvailable"};

    public void close();

    public boolean getPublic();

    public void markTransaction() throws CalFacadeException;

    public String currentChangeToken() throws CalFacadeException;

    public ReindexResponse reindex();

    public ReindexResponse getReindexStatus(String var1);

    public IndexStatsResponse getIndexStats(String var1);

    public SearchResult search(String var1, boolean var2, FilterBase var3, List<SortTerm> var4, FilterBase var5, String var6, String var7, int var8, DeletedState var9, RecurringRetrievalMode var10) throws CalFacadeException;

    public List<SearchResultEntry> getSearchResult(SearchResult var1, Position var2, int var3) throws CalFacadeException;

    public List<SearchResultEntry> getSearchResult(SearchResult var1, int var2, int var3, int var4) throws CalFacadeException;

    public void unindexTombstoned(String var1, String var2) throws CalFacadeException;

    public void unindexContained(String var1) throws CalFacadeException;

    public void unindexEntity(BwEventProperty<?> var1) throws CalFacadeException;

    public void unindexEntity(String var1) throws CalFacadeException;

    public void indexEntity(Object var1) throws CalFacadeException;

    public void indexEntity(Object var1, boolean var2, boolean var3) throws CalFacadeException;

    public void setBatchSize(int var1);

    public void endBwBatch();

    public void flush();

    public String getDocType();

    public String newIndex() throws CalFacadeException;

    public Set<IndexInfo> getIndexInfo() throws CalFacadeException;

    public List<String> purgeIndexes() throws CalFacadeException;

    public int setAlias(String var1) throws CalFacadeException;

    public GetEntityResponse<EventInfo> fetchEvent(String var1);

    public GetEntitiesResponse<EventInfo> fetchEvent(String var1, String var2);

    public List<EventInfo> fetchEvents(String var1, String var2, int var3, int var4) throws CalFacadeException;

    public BwCategory fetchCat(String var1, PropertyIndex.PropertyInfoIndex ... var2) throws CalFacadeException;

    public List<BwCategory> fetchAllCats() throws CalFacadeException;

    public GetEntityResponse<BwCalendar> fetchCol(String var1, int var2, PropertyIndex.PropertyInfoIndex ... var3) throws CalFacadeException;

    public Collection<BwCalendar> fetchChildren(String var1) throws CalFacadeException;

    public Collection<BwCalendar> fetchChildren(String var1, boolean var2) throws CalFacadeException;

    public Collection<BwCalendar> fetchChildrenDeep(String var1) throws CalFacadeException;

    public BwPrincipal fetchPrincipal(String var1) throws CalFacadeException;

    public GetEntitiesResponse<BwGroup> fetchGroups(boolean var1);

    public GetEntitiesResponse<BwAdminGroup> fetchAdminGroups();

    public GetEntitiesResponse<BwGroup> fetchGroups(boolean var1, String var2);

    public GetEntitiesResponse<BwAdminGroup> fetchAdminGroups(String var1);

    public BwPreferences fetchPreferences(String var1) throws CalFacadeException;

    public BwFilterDef fetchFilter(String var1) throws CalFacadeException;

    public List<BwFilterDef> fetchFilters(FilterBase var1, int var2) throws CalFacadeException;

    public BwResource fetchResource(String var1) throws CalFacadeException;

    public List<BwResource> fetchResources(String var1, String var2, int var3, int var4) throws CalFacadeException;

    public BwResourceContent fetchResourceContent(String var1) throws CalFacadeException;

    public BwContact fetchContact(String var1, PropertyIndex.PropertyInfoIndex ... var2) throws CalFacadeException;

    public List<BwContact> fetchAllContacts() throws CalFacadeException;

    public GetEntitiesResponse<BwContact> findContacts(FilterBase var1, int var2, int var3);

    public BwLocation fetchLocation(String var1, PropertyIndex.PropertyInfoIndex ... var2) throws CalFacadeException;

    public GetEntityResponse<BwLocation> fetchLocationByKey(String var1, String var2);

    public GetEntitiesResponse<BwLocation> findLocations(FilterBase var1, int var2, int var3);

    public List<BwLocation> fetchAllLocations() throws CalFacadeException;

    public GetEntitiesResponse<BwCategory> findCategories(FilterBase var1, int var2, int var3);

    public static class IndexInfo
    implements Comparable<IndexInfo>,
    Serializable {
        private final String indexName;
        private Set<String> aliases;

        public IndexInfo(String indexName) {
            this.indexName = indexName;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public void setAliases(Set<String> val) {
            this.aliases = val;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }

        public void addAlias(String val) {
            if (this.aliases == null) {
                this.aliases = new TreeSet<String>();
            }
            this.aliases.add(val);
        }

        @Override
        public int compareTo(IndexInfo o) {
            return this.getIndexName().compareTo(o.getIndexName());
        }
    }

    public static enum Position {
        previous,
        current,
        next;

    }

    public static enum DeletedState {
        onlyDeleted,
        noDeleted,
        includeDeleted;

    }

    public static enum IndexedType {
        unreachableEntities("unknown"),
        principals("principal"),
        preferences("preferences"),
        collections("collection"),
        categories("category"),
        locations("location"),
        contacts("contact"),
        filters("filter"),
        events("event"),
        resources("resource"),
        resourceContents("resourceContent");

        private final String docType;

        private IndexedType(String docType) {
            this.docType = docType;
        }

        public String getDocType() {
            return this.docType;
        }
    }
}

