/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.filter;

import java.util.List;
import org.bedework.calfacade.ical.BwIcalPropertyInfo;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public class SortTerm {
    private List<PropertyIndex.PropertyInfoIndex> properties;
    private boolean ascending;

    public SortTerm(List<PropertyIndex.PropertyInfoIndex> properties, boolean ascending) {
        this.properties = properties;
        this.ascending = ascending;
    }

    public List<PropertyIndex.PropertyInfoIndex> getProperties() {
        return this.properties;
    }

    public String getPropertyRef() {
        if (Util.isEmpty(this.properties)) {
            return null;
        }
        String delim = "";
        StringBuilder sb = new StringBuilder();
        for (PropertyIndex.PropertyInfoIndex pii : this.properties) {
            BwIcalPropertyInfo.BwIcalPropertyInfoEntry ipie = BwIcalPropertyInfo.getPinfo(pii);
            if (ipie == null) {
                return null;
            }
            sb.append(delim);
            sb.append(ipie.getJname());
            delim = ".";
        }
        return sb.toString();
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append(this.getProperties());
        ts.append("ascending", this.isAscending());
        return ts.toString();
    }
}

