/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.filter;

import java.util.ArrayList;
import java.util.List;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.ical.BwIcalPropertyInfo;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.xml.tagdefs.WebdavTags;

public class RetrieveList {
    private static final String etagName = WebdavTags.getetag.toString();

    public static List<BwIcalPropertyInfo.BwIcalPropertyInfoEntry> getRetrieveList(List<String> retrieveList) throws CalFacadeException {
        if (retrieveList == null) {
            return null;
        }
        ArrayList<BwIcalPropertyInfo.BwIcalPropertyInfoEntry> retrieveListFields = new ArrayList<BwIcalPropertyInfo.BwIcalPropertyInfoEntry>(retrieveList.size() + BwIcalPropertyInfo.requiredPindexes.size());
        for (String pname : retrieveList) {
            PropertyIndex.PropertyInfoIndex pi;
            if (pname.equals(etagName)) {
                pi = PropertyIndex.PropertyInfoIndex.ETAG;
            } else {
                pi = PropertyIndex.PropertyInfoIndex.fromName((String)pname);
                if (pi == null) continue;
            }
            BwIcalPropertyInfo.BwIcalPropertyInfoEntry ipie = BwIcalPropertyInfo.getPinfo(pi);
            if (ipie == null || ipie.getMultiValued()) {
                return null;
            }
            retrieveListFields.add(ipie);
        }
        for (PropertyIndex.PropertyInfoIndex pi : BwIcalPropertyInfo.requiredPindexes) {
            retrieveListFields.add(BwIcalPropertyInfo.getPinfo(pi));
        }
        return retrieveListFields;
    }
}

