/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.base;

import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.annotations.ical.IcalProperty;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public abstract class BwShareableContainedDbentity<T>
extends BwShareableDbentity<T> {
    private String colPath;

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.COLLECTION, required=true, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, vavailabilityProperty=true)
    public void setColPath(String val) {
        this.colPath = val;
    }

    public String getColPath() {
        return this.colPath;
    }

    protected void setColPath(String dir, String namePart) {
        BwPrincipal principal;
        if (this.getPublick().booleanValue()) {
            this.setColPath(Util.buildPath((boolean)true, (String[])new String[]{"/public", "/", ".bedework", "/", dir, "/", namePart}));
            return;
        }
        try {
            principal = BwPrincipal.makePrincipal(this.getOwnerHref());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        if (principal == null) {
            throw new RuntimeException("Cannot make principalfrom " + this.getOwnerHref());
        }
        String homeDir = principal.getKind() == 1 ? "user" : Util.pathElement((int)1, (String)principal.getPrincipalRef());
        this.setColPath(Util.buildPath((boolean)true, (String[])new String[]{"/", homeDir, "/", principal.getAccount(), "/", ".bedework", "/", dir, "/", namePart}));
    }

    @Override
    protected void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.append("collection", (Object)this.getColPath());
    }

    @Override
    public void shallowCopyTo(BwShareableContainedDbentity<?> val) {
        super.shallowCopyTo((BwShareableDbentity<?>)val);
        val.setColPath(this.getColPath());
    }

    @Override
    public void copyTo(BwShareableContainedDbentity<?> val) {
        super.copyTo((BwShareableDbentity<?>)val);
        val.setColPath(this.getColPath());
    }
}

