/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

@Dump(elementName="resourceContent", keyFields={"colPath", "name", "encodedContent"})
public class BwResourceContent
extends BwDbentity<BwResourceContent> {
    private String colPath;
    private String name;
    private Blob value;
    private byte[] byteValue;

    public void setColPath(String val) {
        this.colPath = val;
    }

    public String getColPath() {
        return this.colPath;
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(Blob val) {
        this.value = val;
    }

    @NoDump
    public Blob getValue() {
        return this.value;
    }

    @Override
    public void setHref(String val) {
    }

    @Override
    public String getHref() {
        return Util.buildPath((boolean)false, (String[])new String[]{this.getColPath(), "/", this.getName()});
    }

    public InputStream getBinaryStream() throws CalFacadeException {
        if (this.getValue() != null) {
            try {
                return this.getValue().getBinaryStream();
            }
            catch (Throwable t) {
                throw new CalFacadeException(t);
            }
        }
        if (this.byteValue != null) {
            return new ByteArrayInputStream(this.byteValue);
        }
        return null;
    }

    public void setByteValue(byte[] val) {
        this.byteValue = val;
    }

    public byte[] getByteValue() {
        return this.byteValue;
    }

    public String getEncodedContent() {
        try {
            int len;
            Blob b = this.getValue();
            if (b == null) {
                return null;
            }
            int chunkSize = 1024;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Base64OutputStream b64out = new Base64OutputStream((OutputStream)baos);
            InputStream str = b.getBinaryStream();
            while ((len = str.read(buffer)) != -1) {
                b64out.write(buffer, 0, len);
            }
            b64out.close();
            return new String(baos.toByteArray());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @NoDump
    public String getStringContent() {
        try {
            int len;
            Blob b = this.getValue();
            if (b == null) {
                return null;
            }
            int chunkSize = 1024;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream str = b.getBinaryStream();
            while ((len = str.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            return new String(baos.toByteArray());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void copyTo(BwResourceContent val) {
        val.setColPath(this.getColPath());
        val.setName(this.getName());
        val.setValue(this.getValue());
    }

    @Override
    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    public int compareTo(BwResourceContent that) {
        if (this == that) {
            return 0;
        }
        return CalFacadeUtil.cmpObjval(this.getColPath(), that.getColPath());
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.append("path", (Object)this.getColPath());
        ts.append("name", (Object)this.getName());
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwResourceContent nobj = new BwResourceContent();
        this.copyTo(nobj);
        return nobj;
    }
}

