/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.sql.Timestamp;
import java.util.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.property.LastModified;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwResourceContent;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.annotations.NoWrap;
import org.bedework.calfacade.annotations.ical.NoProxy;
import org.bedework.calfacade.base.BwShareableContainedDbentity;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.DateTimeUtil;

@Dump(elementName="resource", keyFields={"name"})
public class BwResource
extends BwShareableContainedDbentity<BwResource> {
    private String name;
    private String created;
    private String lastmod;
    private int sequence;
    private String contentType;
    private String encoding;
    private long contentLength;
    public static final String tombstoned = "--TOMBSTONED--";
    public static final String tombstonedSuffix = "(--TOMBSTONED--)";
    private String prevLastmod;
    private int prevSeq;
    private BwResourceContent content;

    @Override
    public void setHref(String val) {
    }

    @Override
    public String getHref() {
        return Util.buildPath((boolean)false, (String[])new String[]{this.getColPath(), "/", this.getName()});
    }

    public BwResource() {
        Date dt = new Date();
        this.setCreated(DateTimeUtil.isoDateTimeUTC((Date)dt));
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getName() {
        return this.name;
    }

    public void setCreated(String val) {
        this.created = val;
    }

    public String getCreated() {
        return this.created;
    }

    public void setLastmod(String val) {
        this.lastmod = val;
    }

    public String getLastmod() {
        return this.lastmod;
    }

    public void setSequence(int val) {
        this.sequence = val;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setContentType(String val) {
        this.contentType = val;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setEncoding(String val) {
        this.encoding = val;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setContentLength(long val) {
        this.contentLength = val;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    @NoDump
    public String getContentTypeStripped() {
        String ct = this.getContentType();
        if (ct == null || !ct.contains("\t")) {
            return ct;
        }
        return ct.substring(0, ct.indexOf("\t"));
    }

    @NoDump
    public String getContentTypeExtra() {
        String ct = this.getContentType();
        if (ct == null || !ct.contains("\t")) {
            return null;
        }
        return ct.substring(ct.indexOf("\t") + 1);
    }

    public void copyTo(BwResource val) {
        super.copyTo(val);
        val.setName(this.getName());
        val.setContentType(this.getContentType());
        val.setEncoding(this.getEncoding());
        val.setContentLength(this.getContentLength());
    }

    public void updateLastmod(Timestamp val) {
        DateTime dt = new DateTime((Date)val);
        this.setLastmod(new LastModified(dt).getValue());
        this.setSequence(val.getNanos() / 100000);
    }

    @NoDump
    public void setPrevLastmod(String val) {
        this.prevLastmod = val;
    }

    public String getPrevLastmod() {
        return this.prevLastmod;
    }

    public void setPrevSeq(int val) {
        this.prevSeq = val;
    }

    @NoDump
    public int getPrevSeq() {
        return this.prevSeq;
    }

    public void setContent(BwResourceContent val) {
        this.content = val;
    }

    @Dump(compound=true)
    public BwResourceContent getContent() {
        return this.content;
    }

    @NoDump
    public String getEtag() {
        return "\"" + this.getEtagValue() + "\"";
    }

    @NoDump
    public String getEtagValue() {
        return this.getLastmod() + "-" + BwEvent.hex4(this.getSequence());
    }

    @NoDump
    public String getPreviousEtag() {
        if (this.getPrevLastmod() == null) {
            return null;
        }
        return "\"" + this.getPrevLastmod() + "-" + BwEvent.hex4(this.getPrevSeq()) + "\"";
    }

    public void tombstone() {
        if (this.getTombstoned()) {
            return;
        }
        this.setEncoding(tombstoned);
    }

    @NoProxy
    @NoDump
    @NoWrap
    public boolean getTombstoned() {
        return tombstoned.equals(this.getEncoding());
    }

    @Override
    public int hashCode() {
        return this.getColPath().hashCode() * this.getName().hashCode();
    }

    @Override
    public int compareTo(BwResource that) {
        if (this == that) {
            return 0;
        }
        int res = Util.cmpObjval((Comparable)((Object)this.getColPath()), (Comparable)((Object)that.getColPath()));
        if (res != 0) {
            return res;
        }
        return Util.cmpObjval((Comparable)((Object)this.getName()), (Comparable)((Object)that.getName()));
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.append("name", (Object)this.getName());
        ts.append("getContentType", (Object)this.getContentType());
        ts.append("encoding", (Object)this.getEncoding());
        ts.append("length", Long.valueOf(this.getContentLength()));
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwResource nobj = new BwResource();
        this.copyTo(nobj);
        return nobj;
    }
}

