/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.LastModified;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttachment;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwDuration;
import org.bedework.calfacade.BwEventAnnotation;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwFreeBusyComponent;
import org.bedework.calfacade.BwGeo;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwLongString;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwRelatedTo;
import org.bedework.calfacade.BwRequestStatus;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.PollItmId;
import org.bedework.calfacade.annotations.CloneForOverride;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.annotations.NoWrap;
import org.bedework.calfacade.annotations.Wrapper;
import org.bedework.calfacade.annotations.ical.IcalProperties;
import org.bedework.calfacade.annotations.ical.IcalProperty;
import org.bedework.calfacade.annotations.ical.Immutable;
import org.bedework.calfacade.annotations.ical.NoProxy;
import org.bedework.calfacade.base.BwShareableContainedDbentity;
import org.bedework.calfacade.base.EventEntity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Uid;
import org.bedework.util.misc.Util;

@Wrapper(quotas=true)
@Dump(elementName="event", keyFields={"colPath", "uid", "recurrenceId"}, firstFields={"ownerHref"})
public class BwEvent
extends BwShareableContainedDbentity<BwEvent>
implements EventEntity {
    private int entityType = 0;
    private String name;
    private Set<BwString> summaries;
    private Set<BwLongString> descriptions;
    private String classification;
    private Set<BwString> comments;
    private Set<BwString> resources;
    private BwDateTime dtstart;
    private BwDateTime dtend;
    private String duration;
    private Boolean noStart;
    private char endType = (char)68;
    private String link;
    private BwGeo geo;
    public static final String statusTentative = "TENTATIVE";
    public static final String statusConfirmed = "CONFIRMED";
    public static final String statusCancelled = "CANCELLED";
    public static final String statusNeedsAction = "NEEDS-ACTION";
    public static final String statusComplete = "COMPLETE";
    public static final String statusInProcess = "IN-PROCESS";
    public static final String statusDraft = "DRAFT";
    public static final String statusFinal = "FINAL";
    public static final String statusUnavailable = "BUSY-UNAVAILABLE";
    public static final String statusMasterSuppressed = "MASTER-SUPPRESSED";
    private String status;
    private String cost;
    private boolean deleted;
    private Boolean tombstoned = Boolean.FALSE;
    private String dtstamp;
    private String lastmod;
    private String created;
    private String stag;
    private Integer priority;
    private Set<BwCategory> categories;
    private Set<BwContact> contacts;
    private BwLocation location;
    private BwOrganizer organizer;
    private String transparency;
    private Integer percentComplete;
    private String completed;
    private Set<BwAttachment> attachments;
    private Set<BwAttendee> attendees;
    private Boolean recurring;
    private String uid;
    private String ctoken;
    private Set<BwAlarm> alarms;
    private String recurrenceId;
    private Set<String> rrules;
    private Set<String> exrules;
    private Set<BwDateTime> rdates;
    private Set<BwDateTime> exdates;
    private int sequence;
    private int scheduleMethod;
    private String originator;
    private Set<String> recipients;
    public static final int scheduleStateNotProcessed = 0;
    public static final int scheduleStateProcessed = 1;
    public static final int scheduleStateExternalDone = 2;
    private int scheduleState;
    private Set<BwRequestStatus> requestStatuses;
    private Boolean organizerSchedulingObject = Boolean.FALSE;
    private Boolean attendeeSchedulingObject = Boolean.FALSE;
    private BwRelatedTo relatedTo;
    private List<BwXproperty> xproperties;
    private List<BwFreeBusyComponent> freeBusyPeriods;
    public static final int busyTypeBusy = 0;
    public static final int busyTypeBusyUnavailable = 1;
    public static final int busyTypeBusyTentative = 2;
    private int busyType = 1;
    public static final String[] busyTypeStrings = new String[]{"BUSY", "BUSY-UNAVAILABLE", "BUSY-TENTATIVE"};
    private Set<String> availableUids;
    private Collection<BwEventAnnotation> overrides;
    private String color;
    private boolean significantChange = true;
    boolean forceUTC;
    private BwEvent parent;
    private Set<String> categoryUids;
    private Set<String> contactHrefs;
    private String locationHref;
    private ChangeTable changeSet;
    private static final String mailTo = "mailto:";

    protected BwEvent() {
    }

    @Immutable
    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ENTITY_TYPE, jname="entityType", required=true, eventProperty=true, todoProperty=true, journalProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.DOCTYPE, jname="_type", required=true, eventProperty=true, todoProperty=true, journalProperty=true)})
    public void setEntityType(int val) {
        this.entityType = val;
    }

    public int getEntityType() {
        return this.entityType;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.NAME, required=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setName(String val) {
        this.name = val;
    }

    public String getName() {
        return this.name;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CLASS, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setClassification(String val) {
        this.classification = val;
    }

    public String getClassification() {
        return this.classification;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.URL, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    public void setLink(String val) {
        this.link = val;
    }

    public String getLink() {
        return this.link;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.PUBLISH_URL, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    @NoProxy
    public void setPublishUrl(String val) {
        this.replaceXproperty("X-BEDEWORK-PUBLISH-URL", val);
    }

    @NoProxy
    @NoDump
    public String getPublishUrl() {
        return this.getXproperty("X-BEDEWORK-PUBLISH-URL");
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.GEO, eventProperty=true, todoProperty=true)
    public void setGeo(BwGeo val) {
        this.geo = val;
    }

    @Dump(compound=true)
    public BwGeo getGeo() {
        return this.geo;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.DELETED)
    public void setDeleted(boolean val) {
        this.deleted = val;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.TOMBSTONED, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setTombstoned(Boolean val) {
        this.tombstoned = val;
    }

    public Boolean getTombstoned() {
        return this.tombstoned;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.STATUS, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setStatus(String val) {
        this.status = val;
    }

    public String getStatus() {
        return this.status;
    }

    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.COST, eventProperty=true, todoProperty=true, journalProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.XBEDEWORK_COST, eventProperty=true, todoProperty=true, journalProperty=true)})
    public void setCost(String val) {
        this.cost = val;
    }

    public String getCost() {
        return this.cost;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ORGANIZER, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    public void setOrganizer(BwOrganizer val) {
        this.organizer = val;
    }

    @Dump(elementName="organizer", compound=true)
    public BwOrganizer getOrganizer() {
        return this.organizer;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.DTSTAMP, required=true, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    public void setDtstamp(String val) {
        this.dtstamp = val;
    }

    public String getDtstamp() {
        return this.dtstamp;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LAST_MODIFIED, jname="lastModified", eventProperty=true, todoProperty=true, journalProperty=true, timezoneProperty=true)
    public void setLastmod(String val) {
        this.lastmod = val;
    }

    public String getLastmod() {
        return this.lastmod;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CREATED, required=true, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    public void setCreated(String val) {
        this.created = val;
    }

    public String getCreated() {
        return this.created;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.SCHEDULE_TAG, jname="scheduleTag", eventProperty=true, todoProperty=true)
    public void setStag(String val) {
        this.stag = val;
    }

    public String getStag() {
        return this.stag;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.PRIORITY, eventProperty=true, todoProperty=true)
    public void setPriority(Integer val) {
        this.priority = val;
    }

    public Integer getPriority() {
        return this.priority;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.SEQUENCE, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setSequence(int val) {
        this.sequence = val;
    }

    public int getSequence() {
        return this.sequence;
    }

    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LOCATION, reschedule=true, eventProperty=true, todoProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LOCATION_STR, jname="locationStr", required=true, eventProperty=true, todoProperty=true)})
    public void setLocation(BwLocation val) {
        this.location = val;
    }

    public BwLocation getLocation() {
        return this.location;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.UID, required=true, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    public void setUid(String val) {
        this.uid = val;
    }

    public String getUid() {
        return this.uid;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.TRANSP, jname="transp", eventProperty=true)
    public void setTransparency(String val) {
        this.transparency = val;
    }

    public String getTransparency() {
        return this.transparency;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.PERCENT_COMPLETE, jname="percentComplete", todoProperty=true)
    public void setPercentComplete(Integer val) {
        this.percentComplete = val;
    }

    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.COMPLETED, todoProperty=true)
    public void setCompleted(String val) {
        this.completed = val;
    }

    public String getCompleted() {
        return this.completed;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.SCHEDULE_METHOD, jname="scheduleMethod", eventProperty=true, todoProperty=true)
    public void setScheduleMethod(int val) {
        this.scheduleMethod = val;
    }

    public int getScheduleMethod() {
        return this.scheduleMethod;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ORIGINATOR, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true)
    public void setOriginator(String val) {
        this.originator = val;
    }

    public String getOriginator() {
        return this.originator;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.SCHEDULE_STATE, jname="scheduleState", eventProperty=true, todoProperty=true)
    public void setScheduleState(int val) {
        if (val != 0 && val != 1 && val != 2) {
            throw new RuntimeException("org.bedework.badvalue");
        }
        this.scheduleState = val;
    }

    public int getScheduleState() {
        return this.scheduleState;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ORGANIZER_SCHEDULING_OBJECT, jname="organizerSchedulingObject", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    @NoProxy
    public void setOrganizerSchedulingObject(Boolean val) {
        this.organizerSchedulingObject = val;
    }

    @NoProxy
    public Boolean getOrganizerSchedulingObject() {
        return this.organizerSchedulingObject;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ATTENDEE_SCHEDULING_OBJECT, jname="attendeeSchedulingObject", eventProperty=true, todoProperty=true, journalProperty=true)
    @NoProxy
    public void setAttendeeSchedulingObject(Boolean val) {
        this.attendeeSchedulingObject = val;
    }

    @NoProxy
    public Boolean getAttendeeSchedulingObject() {
        return this.attendeeSchedulingObject;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.RELATED_TO, jname="relatedTo", nested=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setRelatedTo(BwRelatedTo val) {
        this.relatedTo = val;
    }

    @Dump(compound=true)
    public BwRelatedTo getRelatedTo() {
        return this.relatedTo;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.XPROP, jname="xprop", adderName="xproperty", nested=true, keyindex=PropertyIndex.PropertyInfoIndex.NAME, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true)
    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CALSCALE, jname="calscale", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.AFFECTS_FREE_BUSY, jname="affectsFreeBusy", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ALIAS_URI, jname="aliasURI", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CALTYPE, jname="caltype", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.COL_PROPERTIES, jname="colProperties", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.COLPATH, jname="colPath", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CONCEPT, jname="concepts", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=false), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.DISPLAY, jname="display", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.FILTER_EXPR, jname="filterExpr", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.IGNORE_TRANSP, jname="ignoreTransp", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LAST_REFRESH, jname="lastRefresh", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LAST_REFRESH_STATUS, jname="lastRefreshStatus", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.REFRESH_RATE, jname="refreshRate", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.REMOTE_ID, jname="remoteId", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.REMOTE_PW, jname="remotePw", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.UNREMOVEABLE, jname="unremoveable", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.X_BEDEWORK_CONTACT, jname="xbwcontact", adderName="xproperty", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.X_BEDEWORK_LOCATION, jname="xbwlocation", adderName="xproperty", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.X_BEDEWORK_CATEGORIES, jname="xbwcategories", adderName="xproperty", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.EVENTREG_END, jname="eventregEnd", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.EVENTREG_MAX_TICKETS, jname="eventregMaxTickets", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.EVENTREG_MAX_TICKETS_PER_USER, jname="eventregMaxTicketsPerUser", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.EVENTREG_START, jname="eventregStart", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.EVENTREG_WAIT_LIST_LIMIT, jname="eventregWaitListLimit", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.IMAGE, jname="image", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.INSTANCE, jname="instance", annotationRequired=true, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.METHOD, jname="method", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.PARAMETERS, jname="pars", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.PRODID, jname="prodid", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.SUGGESTED_TO, jname="suggestedTo", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.THUMBIMAGE, jname="thumbimage", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.TAG, jname="tag", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.TOPICAL_AREA, jname="topicalArea", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.UNKNOWN_PROPERTY, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.URI, jname="uri", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.VERSION, jname="version", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.VIEW, jname="view", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.VPATH, jname="vpath", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true)})
    public void setXproperties(List<BwXproperty> val) {
        this.xproperties = val;
    }

    @Override
    @Dump(collectionElementName="xproperty", compound=true)
    public List<BwXproperty> getXproperties() {
        return this.xproperties;
    }

    @Override
    @NoProxy
    @NoDump
    public int getNumXproperties() {
        List<BwXproperty> c = this.getXproperties();
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    @Override
    @NoProxy
    @NoDump
    public List<BwXproperty> getXproperties(String val) {
        ArrayList<BwXproperty> res = new ArrayList<BwXproperty>();
        List<BwXproperty> xs = this.getXproperties();
        if (xs == null) {
            return res;
        }
        for (BwXproperty x : xs) {
            if (x == null || !x.getName().equals(val)) continue;
            res.add(x);
        }
        return res;
    }

    @Override
    @NoProxy
    @NoDump
    public List<BwXproperty> getXicalProperties(String val) {
        ArrayList<BwXproperty> res = new ArrayList<BwXproperty>();
        List<BwXproperty> xs = this.getXproperties();
        if (xs == null) {
            return res;
        }
        for (BwXproperty x : xs) {
            List<BwXproperty.Xpar> xpars;
            BwXproperty.Xpar xp;
            if (x == null || !x.getName().equals("X-BEDEWORK-ICAL-PROP") || !(xp = (xpars = x.getParameters()).get(0)).getValue().equals(val)) continue;
            res.add(x);
        }
        return res;
    }

    @Override
    @NoProxy
    @NoDump
    public int removeXproperties(String val) {
        List<BwXproperty> xs = this.getXproperties(val);
        if (xs.size() == 0) {
            return 0;
        }
        for (BwXproperty x : xs) {
            this.removeXproperty(x);
        }
        return xs.size();
    }

    @Override
    @NoProxy
    public void addXproperty(BwXproperty val) {
        List<BwXproperty> c = this.getXproperties();
        if (c == null) {
            c = new ArrayList<BwXproperty>();
            this.setXproperties(c);
        }
        if (!c.contains(val)) {
            c.add(val);
        }
    }

    @Override
    @NoProxy
    public void removeXproperty(BwXproperty val) {
        List<BwXproperty> c = this.getXproperties();
        if (c == null) {
            return;
        }
        c.remove(val);
    }

    @Override
    @NoProxy
    public List<BwXproperty> cloneXproperty() {
        if (this.getNumXproperties() == 0) {
            return null;
        }
        ArrayList<BwXproperty> xs = new ArrayList<BwXproperty>();
        for (BwXproperty x : this.getXproperties()) {
            if (x == null) continue;
            xs.add((BwXproperty)x.clone());
        }
        return xs;
    }

    @NoProxy
    @NoDump
    @NoWrap
    public String getXproperty(String name) {
        BwXproperty prop = this.findXproperty(name);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    @NoProxy
    @NoDump
    @NoWrap
    public BwXproperty findXproperty(String name) {
        List<BwXproperty> props = this.getXproperties();
        if (props == null) {
            return null;
        }
        for (BwXproperty prop : props) {
            if (prop == null || !name.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    @NoProxy
    public boolean replaceXproperty(String name, String val) {
        BwXproperty prop = this.findXproperty(name);
        if (prop == null) {
            BwXproperty xp = new BwXproperty(name, null, val);
            this.addXproperty(xp);
            if (this.changeSet != null) {
                this.changeSet.addValue(PropertyIndex.PropertyInfoIndex.XPROP, xp);
            }
            return true;
        }
        if (val == null) {
            this.removeXproperty(prop);
            return true;
        }
        if (prop.getValue().equals(val)) {
            return false;
        }
        prop.setValue(val);
        if (this.changeSet != null) {
            BwXproperty xp = new BwXproperty(name, null, val);
            this.changeSet.changed(PropertyIndex.PropertyInfoIndex.XPROP, prop, xp);
        }
        return true;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.REQUEST_STATUS, adderName="requestStatus", jname="requestStatus", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    public void setRequestStatuses(Set<BwRequestStatus> val) {
        this.requestStatuses = val;
    }

    public Set<BwRequestStatus> getRequestStatuses() {
        return this.requestStatuses;
    }

    @NoProxy
    @NoDump
    public int getNumRequestStatuses() {
        Set<BwRequestStatus> c = this.getRequestStatuses();
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    @NoProxy
    public void addRequestStatus(BwRequestStatus val) {
        Set<BwRequestStatus> rs = this.getRequestStatuses();
        if (rs == null) {
            rs = new TreeSet<BwRequestStatus>();
            this.setRequestStatuses(rs);
        }
        rs.add(val);
    }

    @NoProxy
    public boolean removeRequestStatus(BwRequestStatus val) {
        Set<BwRequestStatus> rs = this.getRequestStatuses();
        if (rs == null) {
            return false;
        }
        return rs.remove(val);
    }

    @NoProxy
    public Set<BwRequestStatus> cloneRequestStatuses() {
        Set<BwRequestStatus> rs = this.getRequestStatuses();
        if (rs == null) {
            return null;
        }
        TreeSet<BwRequestStatus> nrs = new TreeSet<BwRequestStatus>();
        for (BwRequestStatus o : rs) {
            nrs.add((BwRequestStatus)o.clone());
        }
        return nrs;
    }

    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CTOKEN, required=true, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ETAG, jname="etag", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LASTMODSEQ, jname="lastModifiedSeq", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)})
    public void setCtoken(String val) {
        this.ctoken = val;
    }

    public String getCtoken() {
        if (this.ctoken == null || this.ctoken.length() == 16) {
            return this.getLastmod() + "-0000";
        }
        return this.ctoken;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.RECURRING)
    public void setRecurring(Boolean val) {
        this.recurring = val;
    }

    @Override
    public Boolean getRecurring() {
        return this.recurring;
    }

    @Override
    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.RECURRENCE_ID, jname="recurrenceId", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.RANGE)})
    public void setRecurrenceId(String val) {
        this.recurrenceId = val;
    }

    @Override
    public String getRecurrenceId() {
        return this.recurrenceId;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.RRULE, jname="rrule", adderName="rrule", reschedule=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setRrules(Set<String> val) {
        this.rrules = val;
    }

    @Override
    @Dump(collectionElementName="rrule")
    public Set<String> getRrules() {
        return this.rrules;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.EXRULE, jname="exrule", adderName="exrule", reschedule=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setExrules(Set<String> val) {
        this.exrules = val;
    }

    @Override
    public Set<String> getExrules() {
        return this.exrules;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.RDATE, jname="rdate", adderName="rdate", reschedule=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setRdates(Set<BwDateTime> val) {
        this.rdates = val;
        if (!Util.isEmpty(val)) {
            this.setRecurring(true);
        }
    }

    @Override
    @Dump(collectionElementName="rdate")
    public Set<BwDateTime> getRdates() {
        return this.rdates;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.EXDATE, jname="exdate", adderName="exdate", reschedule=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setExdates(Set<BwDateTime> val) {
        this.exdates = val;
    }

    @Override
    @Dump(collectionElementName="exdate")
    public Set<BwDateTime> getExdates() {
        return this.exdates;
    }

    @Override
    @NoProxy
    public boolean isRecurringEntity() {
        return this.testRecurring() || this.hasExdates() || this.hasRdates() || this.hasExrules() || this.hasRrules();
    }

    @Override
    @NoProxy
    public boolean testRecurring() {
        if (this.getRecurring() == null) {
            return false;
        }
        return this.getRecurring();
    }

    @Override
    @NoProxy
    public boolean hasRrules() {
        return !Util.isEmpty(this.getRrules());
    }

    @Override
    @NoProxy
    public void addRrule(String val) {
        Set<String> c = this.getRrules();
        if (c == null) {
            c = new TreeSet<String>();
            this.setRrules(c);
        }
        if (!c.contains(val)) {
            c.add(val);
            this.setRecurring(true);
        }
    }

    @Override
    @NoProxy
    public boolean hasExrules() {
        return !Util.isEmpty(this.getExrules());
    }

    @Override
    @NoProxy
    public void addExrule(String val) {
        Set<String> c = this.getExrules();
        if (c == null) {
            c = new TreeSet<String>();
            this.setExrules(c);
        }
        c.add(val);
    }

    @Override
    @NoProxy
    public boolean hasRdates() {
        return !Util.isEmpty(this.getRdates());
    }

    @Override
    @NoProxy
    public void addRdate(BwDateTime val) {
        Set<BwDateTime> c = this.getRdates();
        if (c == null) {
            c = new TreeSet<BwDateTime>();
            this.setRdates(c);
        }
        if (!c.contains(val)) {
            c.add(val);
            this.setRecurring(true);
        }
    }

    @Override
    @NoProxy
    public boolean hasExdates() {
        return !Util.isEmpty(this.getExdates());
    }

    @Override
    @NoProxy
    public void addExdate(BwDateTime val) {
        Set<BwDateTime> c = this.getExdates();
        if (c == null) {
            c = new TreeSet<BwDateTime>();
            this.setExdates(c);
        }
        c.add(val);
    }

    @Override
    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.DTSTART, presenceField="dtval", required=true, reschedule=true, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.INDEX_START, jname="indexStart", presenceField="dtval", required=true, reschedule=true, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true)})
    @NoProxy
    public void setDtstart(BwDateTime val) {
        this.dtstart = val;
    }

    @Override
    public BwDateTime getDtstart() {
        return this.dtstart;
    }

    @Override
    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.DTEND, presenceField="dtval", required=true, reschedule=true, eventProperty=true, freeBusyProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.INDEX_END, jname="indexEnd", presenceField="dtval", required=true, reschedule=true, eventProperty=true, freeBusyProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.DUE, presenceField="dtval", reschedule=true, todoProperty=true)})
    @NoProxy
    public void setDtend(BwDateTime val) {
        this.dtend = val;
    }

    @Override
    public BwDateTime getDtend() {
        return this.dtend;
    }

    @Override
    @NoProxy
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.END_TYPE, jname="endType", required=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setEndType(char val) {
        this.endType = val;
    }

    @Override
    public char getEndType() {
        return this.endType;
    }

    @Override
    @NoProxy
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.DURATION, required=true, reschedule=true, eventProperty=true, todoProperty=true, freeBusyProperty=true)
    public void setDuration(String val) {
        this.duration = val;
    }

    @Override
    public String getDuration() {
        return this.duration;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ESTIMATED_DURATION, todoProperty=true)
    @NoProxy
    public void setEstimatedDuration(String val) {
        this.replaceXproperty("X-BW-ESTIMATED-DURATION", val);
    }

    @NoProxy
    @NoDump
    public String getEstimatedDuration() {
        return this.getXproperty("X-BW-ESTIMATED-DURATION");
    }

    @Override
    @NoProxy
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.NO_START, jname="noStart", required=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setNoStart(Boolean val) {
        this.noStart = val;
    }

    @Override
    public Boolean getNoStart() {
        return this.noStart;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.VALARM, jname="alarm", adderName="alarm", eventProperty=true, todoProperty=true)
    public void setAlarms(Set<BwAlarm> val) {
        this.alarms = val;
    }

    @Override
    @Dump(collectionElementName="alarm", compound=true)
    public Set<BwAlarm> getAlarms() {
        return this.alarms;
    }

    @Override
    @NoProxy
    @NoDump
    public int getNumAlarms() {
        Set<BwAlarm> c = this.getAlarms();
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    @Override
    @NoProxy
    public void addAlarm(BwAlarm val) {
        Set<BwAlarm> rs = this.getAlarms();
        if (rs == null) {
            rs = new TreeSet<BwAlarm>();
            this.setAlarms(rs);
        }
        rs.add(val);
    }

    @Override
    @NoProxy
    public boolean removeAlarm(BwAlarm val) {
        Set<BwAlarm> rs = this.getAlarms();
        if (rs == null) {
            return false;
        }
        return rs.remove(val);
    }

    @Override
    @NoProxy
    public Set<BwAlarm> cloneAlarms() {
        Set<BwAlarm> rs = this.getAlarms();
        if (rs == null) {
            return null;
        }
        TreeSet<BwAlarm> nrs = new TreeSet<BwAlarm>();
        for (BwAlarm al : rs) {
            nrs.add((BwAlarm)al.clone());
        }
        return nrs;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ATTACH, adderName="attachment", eventProperty=true, todoProperty=true, journalProperty=true)
    public void setAttachments(Set<BwAttachment> val) {
        this.attachments = val;
    }

    @Override
    @Dump(collectionElementName="attachment", compound=true)
    public Set<BwAttachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @NoProxy
    @NoDump
    public int getNumAttachments() {
        Set<BwAttachment> as = this.getAttachments();
        if (as == null) {
            return 0;
        }
        return as.size();
    }

    @Override
    @NoProxy
    public void addAttachment(BwAttachment val) {
        Set<BwAttachment> as = this.getAttachments();
        if (as == null) {
            as = new TreeSet<BwAttachment>();
            this.setAttachments(as);
        }
        as.add(val);
    }

    @Override
    @NoProxy
    public boolean removeAttachment(BwAttachment val) {
        Set<BwAttachment> as = this.getAttachments();
        if (as == null) {
            return false;
        }
        return as.remove(val);
    }

    @Override
    @NoProxy
    public Set<BwAttachment> copyAttachments() {
        if (this.getNumAttachments() == 0) {
            return null;
        }
        return new TreeSet<BwAttachment>(this.getAttachments());
    }

    @Override
    @NoProxy
    public Set<BwAttachment> cloneAttachments() {
        if (this.getNumAttachments() == 0) {
            return null;
        }
        TreeSet<BwAttachment> ts = new TreeSet<BwAttachment>();
        for (BwAttachment att : this.getAttachments()) {
            ts.add((BwAttachment)att.clone());
        }
        return ts;
    }

    @Override
    @NoProxy
    public void clearAttachments() {
        if (this.getNumAttachments() == 0) {
            return;
        }
        this.getAttachments().clear();
    }

    @Override
    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ATTENDEE, jname="attendee", adderName="attendee", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.VOTER, jname="voter", adderName="voter", vpollProperty=true)})
    public void setAttendees(Set<BwAttendee> val) {
        this.attendees = val;
    }

    @Override
    @Dump(collectionElementName="attendee", compound=true)
    @CloneForOverride(cloneCollectionType="TreeSet", cloneElementType="BwAttendee")
    public Set<BwAttendee> getAttendees() {
        return this.attendees;
    }

    @Override
    @NoProxy
    @NoDump
    public int getNumAttendees() {
        Set<BwAttendee> as = this.getAttendees();
        if (as == null) {
            return 0;
        }
        return as.size();
    }

    @Override
    @NoProxy
    public void addAttendee(BwAttendee val) {
        Set<BwAttendee> as = this.getAttendees();
        if (as == null) {
            as = new TreeSet<BwAttendee>();
            this.setAttendees(as);
        }
        as.add(val);
    }

    @Override
    @NoProxy
    public boolean removeAttendee(BwAttendee val) {
        Set<BwAttendee> as = this.getAttendees();
        if (as == null) {
            return false;
        }
        return as.remove(val);
    }

    @Override
    @NoProxy
    public Set<BwAttendee> copyAttendees() {
        if (this.getNumAttendees() == 0) {
            return null;
        }
        return new TreeSet<BwAttendee>(this.getAttendees());
    }

    @Override
    @NoProxy
    public Set<BwAttendee> cloneAttendees() {
        if (this.getNumAttendees() == 0) {
            return null;
        }
        TreeSet<BwAttendee> ts = new TreeSet<BwAttendee>();
        for (BwAttendee att : this.getAttendees()) {
            ts.add((BwAttendee)att.clone());
        }
        return ts;
    }

    @NoProxy
    public BwAttendee findAttendee(String uri) {
        if (this.getNumAttendees() == 0) {
            return null;
        }
        int uriLen = uri.length();
        boolean hasMailTo = false;
        int uriStart = 0;
        if (uri.toLowerCase().startsWith(mailTo)) {
            hasMailTo = true;
            uriStart = 7;
        }
        while (uri.charAt(uriLen - 1) == '/') {
            if (--uriLen > uriStart) continue;
            return null;
        }
        String uriSeg = uri.substring(uriStart, uriLen);
        for (BwAttendee att : this.getAttendees()) {
            String auri = att.getAttendeeUri();
            int auriLen = auri.length();
            int auriStart = 0;
            if (hasMailTo) {
                if (!auri.toLowerCase().startsWith(mailTo)) {
                    return null;
                }
                auriStart = uriStart;
            }
            while (auri.charAt(auriLen - 1) == '/') {
                if (--auriLen > auriStart) continue;
                return null;
            }
            if (auriLen != uriLen || !uriSeg.regionMatches(0, auri, auriStart, uriLen - auriStart)) continue;
            return att;
        }
        return null;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.RECIPIENT, jname="recipient", adderName="recipient", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    public void setRecipients(Set<String> val) {
        this.recipients = val;
    }

    @Override
    @Dump(collectionElementName="recipient")
    public Set<String> getRecipients() {
        return this.recipients;
    }

    @Override
    @NoProxy
    @NoDump
    public int getNumRecipients() {
        Set<String> rs = this.getRecipients();
        if (rs == null) {
            return 0;
        }
        return rs.size();
    }

    @Override
    @NoProxy
    public void addRecipient(String val) {
        Set<String> rs = this.getRecipients();
        if (rs == null) {
            rs = new TreeSet<String>();
            this.setRecipients(rs);
        }
        rs.add(val);
    }

    @Override
    @NoProxy
    public boolean removeRecipient(String val) {
        Set<String> rs = this.getRecipients();
        if (rs == null) {
            return false;
        }
        return rs.remove(val);
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CATEGORIES, adderName="category", jname="categories", eventProperty=true, todoProperty=true, journalProperty=true)
    public void setCategories(Set<BwCategory> val) {
        this.categories = val;
    }

    @Override
    public Set<BwCategory> getCategories() {
        return this.categories;
    }

    @Override
    @NoProxy
    @NoDump
    public int getNumCategories() {
        Set<BwCategory> c = this.getCategories();
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    @Override
    @NoProxy
    public boolean addCategory(BwCategory val) {
        if (val == null) {
            throw new RuntimeException("Attempting to store null");
        }
        Set<BwCategory> cats = this.getCategories();
        if (cats == null) {
            cats = new TreeSet<BwCategory>();
            this.setCategories(cats);
        }
        if (!cats.contains(val)) {
            cats.add(val);
            return true;
        }
        return false;
    }

    @Override
    @NoProxy
    public boolean removeCategory(BwCategory val) {
        Set<BwCategory> cats = this.getCategories();
        if (cats == null) {
            return false;
        }
        return cats.remove(val);
    }

    @Override
    @NoProxy
    public boolean hasCategory(BwCategory val) {
        Set<BwCategory> cats = this.getCategories();
        if (cats == null) {
            return false;
        }
        return cats.contains(val);
    }

    @Override
    @NoProxy
    public Set<BwCategory> copyCategories() {
        if (this.getNumCategories() == 0) {
            return null;
        }
        return new TreeSet<BwCategory>(this.getCategories());
    }

    @Override
    @NoProxy
    public Set<BwCategory> cloneCategories() {
        if (this.getNumCategories() == 0) {
            return null;
        }
        TreeSet<BwCategory> ts = new TreeSet<BwCategory>();
        for (BwCategory cat : this.getCategories()) {
            ts.add((BwCategory)cat.clone());
        }
        return ts;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.COMMENT, adderName="comment", analyzed=true, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true, timezoneProperty=true)
    public void setComments(Set<BwString> val) {
        this.comments = val;
    }

    @Override
    public Set<BwString> getComments() {
        return this.comments;
    }

    @Override
    @NoProxy
    @NoDump
    public int getNumComments() {
        Set<BwString> rs = this.getComments();
        if (rs == null) {
            return 0;
        }
        return rs.size();
    }

    @Override
    @NoProxy
    public void addComment(String lang, String val) {
        this.addComment(new BwString(lang, val));
    }

    @Override
    @NoProxy
    public void addComment(BwString val) {
        Set<BwString> rs = this.getComments();
        if (rs == null) {
            rs = new TreeSet<BwString>();
            this.setComments(rs);
        }
        rs.add(val);
    }

    @Override
    @NoProxy
    public boolean removeComment(BwString val) {
        Set<BwString> rs = this.getComments();
        if (rs == null) {
            return false;
        }
        return rs.remove(val);
    }

    @NoProxy
    public void setContact(BwContact val) {
        Set<BwContact> c = this.getContacts();
        if (c != null && !c.isEmpty()) {
            c.clear();
        }
        if (val != null) {
            this.addContact(val);
        }
    }

    @NoProxy
    @NoDump
    public BwContact getContact() {
        Set<BwContact> c = this.getContacts();
        if (c == null || c.isEmpty()) {
            return null;
        }
        return c.iterator().next();
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CONTACT, adderName="contact", eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    public void setContacts(Set<BwContact> val) {
        this.contacts = val;
    }

    @Override
    public Set<BwContact> getContacts() {
        return this.contacts;
    }

    @Override
    @NoProxy
    @NoDump
    public int getNumContacts() {
        Set<BwContact> c = this.getContacts();
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    @Override
    @NoProxy
    public void addContact(BwContact val) {
        Set<BwContact> cs = this.getContacts();
        if (cs == null) {
            cs = new TreeSet<BwContact>();
            this.setContacts(cs);
        }
        cs.add(val);
    }

    @Override
    @NoProxy
    public boolean removeContact(BwContact val) {
        Set<BwContact> cs = this.getContacts();
        if (cs == null) {
            return false;
        }
        return cs.remove(val);
    }

    @Override
    @NoProxy
    public boolean hasContact(BwContact val) {
        Set<BwContact> cs = this.getContacts();
        if (cs == null) {
            return false;
        }
        return cs.contains(val);
    }

    @Override
    @NoProxy
    public Set<BwContact> copyContacts() {
        if (this.getNumContacts() == 0) {
            return null;
        }
        return new TreeSet<BwContact>(this.getContacts());
    }

    @Override
    @NoProxy
    public Set<BwContact> cloneContacts() {
        if (this.getNumContacts() == 0) {
            return null;
        }
        TreeSet<BwContact> ts = new TreeSet<BwContact>();
        for (BwContact cat : this.getContacts()) {
            ts.add((BwContact)cat.clone());
        }
        return ts;
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.DESCRIPTION, jname="description", adderName="description", analyzed=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setDescriptions(Set<BwLongString> val) {
        this.descriptions = val;
    }

    @Override
    @Dump(collectionElementName="description")
    public Set<BwLongString> getDescriptions() {
        return this.descriptions;
    }

    @Override
    @NoProxy
    @NoDump
    public int getNumDescriptions() {
        Set<BwLongString> rs = this.getDescriptions();
        if (rs == null) {
            return 0;
        }
        return rs.size();
    }

    @Override
    @NoProxy
    public void addDescription(String lang, String val) {
        this.addDescription(new BwLongString(lang, val));
    }

    @Override
    @NoProxy
    public void addDescription(BwLongString val) {
        Set<BwLongString> rs = this.getDescriptions();
        if (rs == null) {
            rs = new TreeSet<BwLongString>();
            this.setDescriptions(rs);
        }
        rs.add(val);
    }

    @Override
    @NoProxy
    public boolean removeDescription(BwLongString val) {
        Set<BwLongString> rs = this.getDescriptions();
        if (rs == null) {
            return false;
        }
        return rs.remove(val);
    }

    @Override
    @NoProxy
    public void updateDescriptions(String lang, String val) {
        BwLongString s = this.findDescription(lang);
        if (val == null) {
            if (s != null) {
                this.removeDescription(s);
            }
        } else if (s == null) {
            this.addDescription(lang, val);
        } else if (CalFacadeUtil.cmpObjval(val, s.getValue()) != 0) {
            this.removeDescription(s);
            this.addDescription(lang, val);
        }
    }

    @Override
    @NoProxy
    public BwLongString findDescription(String lang) {
        return BwLongString.findLang(lang, this.getDescriptions());
    }

    @Override
    @NoProxy
    public void setDescription(String val) {
        this.updateDescriptions(null, val);
    }

    @Override
    @NoProxy
    @NoDump
    public String getDescription() {
        BwLongString s = this.findDescription(null);
        if (s == null) {
            return null;
        }
        return s.getValue();
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.RESOURCES, adderName="resources", analyzed=true, eventProperty=true, todoProperty=true)
    public void setResources(Set<BwString> val) {
        this.resources = val;
    }

    @Override
    public Set<BwString> getResources() {
        return this.resources;
    }

    @Override
    @NoProxy
    @NoDump
    public int getNumResources() {
        Set<BwString> rs = this.getResources();
        if (rs == null) {
            return 0;
        }
        return rs.size();
    }

    @Override
    @NoProxy
    public void addResource(String lang, String val) {
        this.addResource(new BwString(lang, val));
    }

    @Override
    @NoProxy
    public void addResource(BwString val) {
        Set<BwString> rs = this.getResources();
        if (rs == null) {
            rs = new TreeSet<BwString>();
            this.setResources(rs);
        }
        rs.add(val);
    }

    @Override
    @NoProxy
    public boolean removeResource(BwString val) {
        Set<BwString> rs = this.getResources();
        if (rs == null) {
            return false;
        }
        return rs.remove(val);
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.SUMMARY, jname="summary", adderName="summary", analyzed=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setSummaries(Set<BwString> val) {
        this.summaries = val;
    }

    @Override
    @Dump(collectionElementName="summary")
    public Set<BwString> getSummaries() {
        return this.summaries;
    }

    @Override
    @NoProxy
    @NoDump
    public int getNumSummaries() {
        Set<BwString> rs = this.getSummaries();
        if (rs == null) {
            return 0;
        }
        return rs.size();
    }

    @NoProxy
    public void addSummary(String lang, String val) {
        this.addSummary(new BwString(lang, val));
    }

    @Override
    @NoProxy
    public void addSummary(BwString val) {
        Set<BwString> rs = this.getSummaries();
        if (rs == null) {
            rs = new TreeSet<BwString>();
            this.setSummaries(rs);
        }
        rs.add(val);
    }

    @Override
    @NoProxy
    public boolean removeSummary(BwString val) {
        Set<BwString> c = this.getSummaries();
        if (c == null) {
            return false;
        }
        return c.remove(val);
    }

    @Override
    @NoProxy
    public void updateSummaries(String lang, String val) {
        BwString s = this.findSummary(lang);
        if (val == null) {
            if (s != null) {
                this.removeSummary(s);
            }
        } else if (s == null) {
            this.addSummary(new BwString(lang, val));
        } else if (CalFacadeUtil.cmpObjval(val, s.getValue()) != 0) {
            this.removeSummary(s);
            this.addSummary(new BwString(lang, val));
        }
    }

    @Override
    @NoProxy
    public BwString findSummary(String lang) {
        return BwString.findLang(lang, this.getSummaries());
    }

    @Override
    @NoProxy
    public void setSummary(String val) {
        this.updateSummaries(null, val);
    }

    @Override
    @NoProxy
    @NoDump
    public String getSummary() {
        BwString s = this.findSummary(null);
        if (s == null) {
            return null;
        }
        return s.getValue();
    }

    @NoProxy
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.FREEBUSY, freeBusyProperty=true)
    public void setFreeBusyPeriods(List<BwFreeBusyComponent> val) {
        this.freeBusyPeriods = val;
    }

    @NoProxy
    public List<BwFreeBusyComponent> getFreeBusyPeriods() {
        return this.freeBusyPeriods;
    }

    @NoProxy
    public void addFreeBusyPeriod(BwFreeBusyComponent val) {
        List<BwFreeBusyComponent> fbps = this.getFreeBusyPeriods();
        if (fbps == null) {
            fbps = new ArrayList<BwFreeBusyComponent>();
            this.setFreeBusyPeriods(fbps);
        }
        fbps.add(val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CALSUITE, jname="calSuite", eventProperty=true, todoProperty=true, vpollProperty=true)
    @NoProxy
    public void setCalSuite(String val) {
        this.replaceXproperty("X-BEDEWORK-CALSUITE", val);
    }

    @NoProxy
    public String getCalSuite() {
        return this.getXproperty("X-BEDEWORK-CALSUITE");
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.POLL_WINNER, jname="pollWinner", vpollProperty=true)
    @NoDump
    public void setPollWinner(Integer val) {
        if (val == null) {
            BwXproperty x = this.findXproperty("X-BW-POLL-WINNER");
            if (x != null) {
                this.removeXproperty(x);
            }
        } else {
            this.replaceXproperty("X-BW-POLL-WINNER", String.valueOf(val));
        }
    }

    public Integer getPollWinner() {
        List<BwXproperty> props = this.getXproperties("X-BW-POLL-WINNER");
        if (Util.isEmpty(props)) {
            return null;
        }
        if (props.size() > 1) {
            return null;
        }
        BwXproperty p = props.get(0);
        return Integer.valueOf(p.getValue());
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.POLL_ITEM_ID, eventProperty=true, todoProperty=true, journalProperty=true)
    @NoDump
    public void setPollItemId(Integer val) {
        if (val == null) {
            BwXproperty x = this.findXproperty("X-BW-POLL-ITEMID");
            if (x != null) {
                this.removeXproperty(x);
            }
        } else {
            PollItmId pid = new PollItmId(val);
            this.replaceXproperty("X-BW-POLL-ITEMID", pid.getVal());
        }
    }

    public Integer getPollItemId() {
        List<BwXproperty> props = this.getXproperties("X-BW-POLL-ITEMID");
        if (Util.isEmpty(props)) {
            return null;
        }
        if (props.size() > 1) {
            return null;
        }
        BwXproperty p = props.get(0);
        PollItmId pid = new PollItmId(p.getValue());
        return pid.getId();
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.POLL_MODE, vpollProperty=true)
    public void setPollMode(String val) {
        this.replaceXproperty("X-BW-POLL-MODE", val);
    }

    public String getPollMode() {
        return this.getXproperty("X-BW-POLL-MODE");
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.POLL_PROPERTIES, vpollProperty=true)
    public void setPollProperties(String val) {
        this.replaceXproperty("X-BW-POLL-PROPERTIES", val);
    }

    public String getPollProperties() {
        return this.getXproperty("X-BW-POLL-PROPERTIES");
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ACCEPT_RESPONSE, vpollProperty=true)
    public void setPollAcceptResponse(String val) {
        this.replaceXproperty("X-BW-POLL-ACCEPT_RESPONSE", val);
    }

    public String getPollAcceptResponse() {
        return this.getXproperty("X-BW-POLL-ACCEPT_RESPONSE");
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.POLL_ITEM, vpollProperty=true)
    @NoProxy
    public Set<String> getPollItems() {
        List<BwXproperty> props = this.getXproperties("X-BW-POLL-ITEM");
        if (Util.isEmpty(props)) {
            return null;
        }
        TreeSet<String> vals = new TreeSet<String>();
        for (BwXproperty p : props) {
            vals.add(p.getValue());
        }
        return vals;
    }

    @NoProxy
    public void clearPollItems() {
        List<BwXproperty> props = this.getXproperties("X-BW-POLL-ITEM");
        if (Util.isEmpty(props)) {
            return;
        }
        for (BwXproperty p : props) {
            this.removeXproperty(p);
        }
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.VVOTER, vpollProperty=true)
    @NoProxy
    public Set<String> getVoters() {
        List<BwXproperty> props = this.getXproperties("X-BW-POLL-VOTER");
        if (Util.isEmpty(props)) {
            return null;
        }
        TreeSet<String> vals = new TreeSet<String>();
        for (BwXproperty p : props) {
            vals.add(p.getValue());
        }
        return vals;
    }

    @NoProxy
    public void clearVoters() {
        List<BwXproperty> props = this.getXproperties("X-BW-POLL-VOTER");
        if (Util.isEmpty(props)) {
            return;
        }
        for (BwXproperty p : props) {
            this.removeXproperty(p);
        }
    }

    @NoProxy
    public void addVoter(String val) {
        Set<String> vs = this.getVoters();
        if (vs == null || !vs.contains(val)) {
            BwXproperty xp = new BwXproperty("X-BW-POLL-VOTER", null, val);
            this.addXproperty(xp);
            if (this.changeSet != null) {
                this.changeSet.addValue(PropertyIndex.PropertyInfoIndex.XPROP, xp);
            }
        }
    }

    @NoProxy
    public void addPollItem(String val) {
        Set<String> pis = this.getPollItems();
        if (pis == null || !pis.contains(val)) {
            BwXproperty xp = new BwXproperty("X-BW-POLL-ITEM", null, val);
            this.addXproperty(xp);
            if (this.changeSet != null) {
                this.changeSet.addValue(PropertyIndex.PropertyInfoIndex.XPROP, xp);
            }
        }
    }

    public void setPollCandidate(boolean val) {
        this.replaceXproperty("X-BW-POLL-CANDIDATE", String.valueOf(val));
    }

    public boolean getPollCandidate() {
        return Boolean.parseBoolean(this.getXproperty("X-BW-POLL-CANDIDATE"));
    }

    @NoProxy
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.BUSYTYPE, vavailabilityProperty=true)
    public void setBusyType(int val) {
        this.busyType = val;
    }

    @NoProxy
    public int getBusyType() {
        return this.busyType;
    }

    @NoProxy
    public void setAvailableUids(Set<String> val) {
        this.availableUids = val;
    }

    @NoProxy
    public Set<String> getAvailableUids() {
        return this.availableUids;
    }

    @NoProxy
    public void addAvailableUid(String val) {
        Set<String> avls = this.getAvailableUids();
        if (avls == null) {
            avls = new TreeSet<String>();
            this.setAvailableUids(avls);
        }
        avls.add(val);
    }

    @NoProxy
    public BwXproperty setPeruserTransparency(String userHref, String val) {
        if (userHref.equals(this.getOwnerHref())) {
            this.setTransparency(val);
            return null;
        }
        BwXproperty pu = this.findPeruserXprop(userHref, "X-PERUSER-PROP-TRANSP");
        if (pu == null) {
            pu = new BwXproperty("X-PERUSER-PROP-TRANSP", "X-PERUSER-OWNER=" + userHref, val);
            this.addXproperty(pu);
            return pu;
        }
        pu.setValue(val);
        return null;
    }

    @NoProxy
    public String getPeruserTransparency(String userHref) {
        if (userHref == null || userHref.equals(this.getOwnerHref())) {
            return this.getTransparency();
        }
        BwXproperty pu = this.findPeruserXprop(userHref, "X-PERUSER-PROP-TRANSP");
        if (pu == null) {
            return this.getTransparency();
        }
        return pu.getValue();
    }

    @NoProxy
    public BwXproperty findPeruserXprop(String userHref, String name) {
        List<BwXproperty> pus = this.getXproperties(name);
        for (BwXproperty pu : pus) {
            if (!userHref.equals(pu.getParam("X-PERUSER-OWNER"))) continue;
            return pu;
        }
        return null;
    }

    @NoProxy
    @NoDump
    @NoWrap
    public List<SuggestedTo> getSuggested() {
        ArrayList<SuggestedTo> ss = new ArrayList<SuggestedTo>();
        for (BwXproperty xp : this.getXproperties("X-BEDEWORK-SUGGESTED-TO")) {
            SuggestedTo st = SuggestedTo.make(xp.getValue());
            if (st == null) continue;
            ss.add(st);
        }
        return ss;
    }

    @NoProxy
    @NoDump
    @NoWrap
    public BwXproperty addSuggested(SuggestedTo val) {
        BwXproperty res = new BwXproperty("X-BEDEWORK-SUGGESTED-TO", null, val.toString());
        this.addXproperty(res);
        return res;
    }

    @NoProxy
    @NoDump
    @NoWrap
    public boolean isSchedulingAssistant() {
        return Boolean.parseBoolean(this.getXproperty("X-BEDEWORK-SCHED-ASSIST"));
    }

    @NoProxy
    @NoDump
    @NoWrap
    public String getBusyTypeString() {
        int b = this.getBusyType();
        if (b < 0 || b >= busyTypeStrings.length) {
            return null;
        }
        return busyTypeStrings[b];
    }

    @NoProxy
    @NoWrap
    public void setBusyTypeString(String val) {
        if (val == null) {
            return;
        }
        String uval = val.toUpperCase();
        for (int i = 0; i < busyTypeStrings.length; ++i) {
            if (!uval.equals(busyTypeStrings[i])) continue;
            this.setBusyType(i);
            return;
        }
    }

    @NoProxy
    @NoWrap
    public static int fromBusyTypeString(String val) {
        if (val == null) {
            return 1;
        }
        String uval = val.toUpperCase();
        for (int i = 0; i < busyTypeStrings.length; ++i) {
            if (!uval.equals(busyTypeStrings[i])) continue;
            return i;
        }
        return 1;
    }

    @NoProxy
    @NoWrap
    public boolean inDateTimeRange(String start, String end) {
        if (this.getEntityType() == 2 && this.getNoStart().booleanValue()) {
            return true;
        }
        String evStart = this.getDtstart().getDate();
        String evEnd = this.getDtend().getDate();
        int evstSt = end == null ? -1 : evStart.compareTo(end);
        if (evstSt >= 0) {
            return false;
        }
        int evendSt = start == null ? 1 : evEnd.compareTo(start);
        return evendSt > 0 || evStart.equals(evEnd) && evendSt >= 0;
    }

    @NoDump
    public boolean getSchedulingObject() {
        return this.getAttendeeSchedulingObject() != false || this.getOrganizerSchedulingObject() != false;
    }

    @NoProxy
    @NoWrap
    public void setOverrides(Collection<BwEventAnnotation> val) {
        this.overrides = val;
    }

    @NoProxy
    @NoWrap
    @Dump(collectionElementName="event", compound=true)
    public Collection<BwEventAnnotation> getOverrides() {
        return this.overrides;
    }

    @NoProxy
    @NoWrap
    public void setColor(String val) {
        this.color = val;
    }

    @NoProxy
    @NoWrap
    @NoDump
    public String getColor() {
        return this.color;
    }

    @NoProxy
    @NoWrap
    @NoDump
    public void setSignificantChange(boolean val) {
        this.significantChange = val;
    }

    @NoProxy
    @NoWrap
    @NoDump
    public boolean getSignificantChange() {
        return this.significantChange;
    }

    @NoProxy
    @NoWrap
    public void setForceUTC(boolean val) {
        this.forceUTC = val;
    }

    @NoProxy
    @NoWrap
    @NoDump
    public boolean getForceUTC() {
        return this.forceUTC;
    }

    @NoProxy
    @NoWrap
    @NoDump
    public void setParent(BwEvent val) {
        this.parent = val;
    }

    @NoProxy
    @NoWrap
    @NoDump
    public BwEvent getParent() {
        return this.parent;
    }

    @Override
    @NoProxy
    @NoWrap
    @NoDump
    public void setCategoryHrefs(Set<String> val) {
        this.categoryUids = val;
    }

    @Override
    @NoProxy
    @NoWrap
    @NoDump
    public Set<String> getCategoryHrefs() {
        return this.categoryUids;
    }

    @Override
    @NoProxy
    @NoWrap
    @NoDump
    public void setContactHrefs(Set<String> val) {
        this.contactHrefs = val;
    }

    @Override
    @NoProxy
    @NoWrap
    @NoDump
    public Set<String> getContactHrefs() {
        return this.contactHrefs;
    }

    @NoProxy
    @NoWrap
    @NoDump
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LOCATION_HREF, jname="locationHref", required=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public void setLocationHref(String val) {
        this.locationHref = val;
    }

    @NoProxy
    @NoWrap
    @NoDump
    public String getLocationHref() {
        return this.locationHref;
    }

    @NoProxy
    @NoWrap
    @NoDump
    public ChangeTable getChangeset(String userHref) {
        if (this.changeSet == null) {
            this.changeSet = new ChangeTable(userHref);
        }
        return this.changeSet;
    }

    @NoProxy
    @NoWrap
    @NoDump
    public void clearChangeset() {
        if (this.changeSet == null) {
            return;
        }
        this.changeSet.clear();
    }

    @Override
    @NoProxy
    @NoDump
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.HREF, jname="href", required=true, eventProperty=true, todoProperty=true, journalProperty=true)
    public String getHref() {
        return Util.buildPath((boolean)false, (String[])new String[]{this.getColPath(), "/", this.getName()});
    }

    @NoProxy
    @NoDump
    public String getEncodedHref() {
        String href = Util.buildPath((boolean)false, (String[])new String[]{this.getColPath(), "/", this.getName()});
        if (this.getRecurrenceId() == null) {
            return href;
        }
        return href + "%23" + this.getRecurrenceId();
    }

    @NoProxy
    @NoDump
    public Set<String> getTimeZoneIds() {
        List<BwFreeBusyComponent> fbcs;
        Set<BwDateTime> dts;
        TreeSet<String> ids = new TreeSet<String>();
        BwDateTime dt = this.getDtstart();
        if (dt != null && dt.getTzid() != null) {
            ids.add(dt.getTzid());
        }
        if ((dt = this.getDtend()) != null && dt.getTzid() != null) {
            ids.add(dt.getTzid());
        }
        if ((dts = this.getRdates()) != null) {
            for (BwDateTime rdt : dts) {
                if (rdt.getTzid() == null) continue;
                ids.add(rdt.getTzid());
            }
        }
        if ((dts = this.getExdates()) != null) {
            for (BwDateTime rdt : dts) {
                if (rdt.getTzid() == null) continue;
                ids.add(rdt.getTzid());
            }
        }
        if ((fbcs = this.getFreeBusyPeriods()) != null) {
            for (BwFreeBusyComponent fbc : fbcs) {
                for (Period p : fbc.getPeriods()) {
                    DateTime fdt = p.getStart();
                    if (fdt.getTimeZone() != null) {
                        ids.add(fdt.getTimeZone().getID());
                    }
                    if ((fdt = p.getEnd()).getTimeZone() == null) continue;
                    ids.add(fdt.getTimeZone().getID());
                }
            }
        }
        return ids;
    }

    @NoProxy
    public void updateLastmod() {
        this.setLastmod(new LastModified(new DateTime(true)).getValue());
    }

    @NoProxy
    public void updateDtstamp() {
        this.setDtstamp(new DtStamp(new DateTime(true)).getValue());
    }

    @NoProxy
    public void updateStag(Timestamp val) {
        DateTime dt = new DateTime((Date)val);
        this.setStag(new LastModified(dt).getValue() + "-" + BwEvent.hex4FromNanos(val.getNanos()));
    }

    @NoProxy
    public void setDtstamps(Timestamp val) {
        DateTime dt = new DateTime((Date)val);
        this.setDtstamp(new DtStamp(dt).getValue());
        this.setLastmod(new LastModified(dt).getValue());
        this.setCtoken(this.getLastmod() + "-" + BwEvent.hex4FromNanos(val.getNanos()));
        if (this.getCreated() == null) {
            this.setCreated(new Created(dt).getValue());
        }
    }

    @NoProxy
    public BwEvent makeFreeBusyEvent() {
        BwEvent res = new BwEvent();
        res.setEntityType(this.getEntityType());
        res.setColPath(this.getColPath());
        res.setName(this.getName());
        res.setUid(this.getUid());
        res.setRecurrenceId(this.getRecurrenceId());
        res.setRecurring(false);
        res.setTombstoned(false);
        res.setDtend(this.getDtend());
        res.setDtstart(this.getDtstart());
        res.setDuration(this.getDuration());
        res.setEndType(this.getEndType());
        res.setTransparency(this.getTransparency());
        res.setStatus(this.getStatus());
        res.setAttendeeSchedulingObject(this.getAttendeeSchedulingObject());
        res.setOrganizerSchedulingObject(this.getOrganizerSchedulingObject());
        if (this.getAttendeeSchedulingObject().booleanValue()) {
            for (BwAttendee att : this.getAttendees()) {
                res.addAttendee((BwAttendee)att.clone());
            }
        }
        res.setOwnerHref(this.getOwnerHref());
        if (this.getEntityType() == 4) {
            List<BwFreeBusyComponent> fbcs = this.getFreeBusyPeriods();
            ArrayList<BwFreeBusyComponent> newfbcs = new ArrayList<BwFreeBusyComponent>();
            for (BwFreeBusyComponent fbc : fbcs) {
                newfbcs.add((BwFreeBusyComponent)fbc.clone());
            }
            res.setFreeBusyPeriods(newfbcs);
        }
        res.setXproperties(this.getXproperties("X-PERUSER-PROP-TRANSP"));
        return res;
    }

    @NoProxy
    public BwDuration makeDurationBean() {
        return BwDuration.makeDuration(this.getDuration());
    }

    @NoProxy
    public int calculateByteSize() {
        int sz = 40;
        return sz += 4;
    }

    @Override
    @NoProxy
    protected void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.newLine();
        ts.append("entityType", this.getEntityType());
        ts.append("deleted", this.getDeleted());
        ts.newLine();
        ts.append("dtstamp", (Object)this.getDtstamp());
        ts.newLine();
        ts.append("dtstart", (Object)this.getDtstart());
        ts.newLine();
        ts.append("dtend", (Object)this.getDtend());
        ts.newLine();
        ts.append("status", (Object)this.getStatus());
        ts.newLine();
        ts.append("lastmod", (Object)this.getLastmod());
        ts.append("created", (Object)this.getCreated());
        ts.append("stag", (Object)this.getStag());
        ts.newLine();
        ts.append("priority", (Object)this.getPriority());
        if (this.getPercentComplete() != null) {
            ts.append("percentComplete", (Object)this.getPercentComplete());
        }
        if (this.getCompleted() != null) {
            ts.append("completed", (Object)this.getCompleted());
        }
        ts.append("classification", (Object)this.getClassification());
        if (this.getGeo() != null) {
            ts.append("geo", (Object)this.getGeo());
        }
        ts.newLine();
        ts.append("uid", (Object)this.getUid());
        ts.newLine();
        ts.append("name", (Object)this.getName());
        ts.newLine();
        ts.append("ctoken", (Object)this.getCtoken());
        ts.newLine();
        ts.append("\n, getRecurring", (Object)this.getRecurring());
        if (this.getRecurrenceId() != null) {
            ts.append("recurrenceId", (Object)this.getRecurrenceId());
        } else {
            if (this.hasRrules()) {
                ts.append("rrules", this.getRrules());
            }
            if (this.hasExrules()) {
                ts.append("exrules", this.getExrules());
            }
            if (this.hasExdates()) {
                ts.append("exdates", this.getExdates());
            }
            if (this.hasRdates()) {
                ts.append("rdates", this.getRdates());
            }
        }
        ts.newLine();
        ts.append("organizer", (Object)this.getOrganizer());
        if (this.getNumRecipients() > 0) {
            ts.append("recipients", this.getRecipients());
        }
        if (this.getNumCategories() > 0) {
            ts.newLine();
            ts.append("categories", this.getCategories());
        }
        if (this.getNumComments() > 0) {
            ts.newLine();
            ts.append("comments", this.getComments());
        }
        if (this.getNumContacts() > 0) {
            ts.newLine();
            ts.append("contacts", this.getContacts());
        }
        if (this.getNumSummaries() > 0) {
            ts.newLine();
            ts.append("summary", this.getSummaries());
        }
        if (this.getNumDescriptions() > 0) {
            ts.newLine();
            ts.append("description", this.getDescriptions());
        }
        if (this.getNumResources() > 0) {
            ts.newLine();
            ts.append("resource", this.getResources());
        }
        if (this.getNumAttendees() > 0) {
            ts.newLine();
            ts.append("attendee", this.getAttendees(), true);
        }
        ts.newLine();
        ts.append("sequence", this.getSequence());
        ts.append("scheduleMethod", this.getScheduleMethod());
        ts.newLine();
        ts.append("originator", (Object)this.getOriginator());
        ts.append("scheduleState", this.getScheduleState());
        if (this.getNumRequestStatuses() > 0) {
            ts.append("requestStatuses", this.getRequestStatuses());
        }
        if (this.getRelatedTo() != null) {
            ts.append("relatedTo", (Object)this.getRelatedTo());
        }
        if (this.getNumAlarms() > 0) {
            ts.newLine();
            ts.append("alarms", this.getAlarms(), true);
        }
        ts.append("pollItemId", (Object)this.getPollItemId());
        ts.append("pollCandidate", this.getPollCandidate());
        if (this.getEntityType() == 7) {
            ts.append("pollWinner", (Object)this.getPollWinner());
            ts.append("pollMode", (Object)this.getPollMode());
            ts.append("pollProperties", (Object)this.getPollProperties());
            ts.append("pollAcceptResponse", (Object)this.getPollAcceptResponse());
            ts.append("pollItems", this.getPollItems());
        }
    }

    @NoProxy
    public void copyTo(BwEvent ev) {
        super.copyTo(ev);
        ev.setEntityType(this.getEntityType());
        ev.setName(this.getName());
        ev.setClassification(this.getClassification());
        ev.setDtstart(this.getDtstart());
        ev.setDtend(this.getDtend());
        ev.setEndType(this.getEndType());
        ev.setDuration(this.getDuration());
        ev.setNoStart(this.getNoStart());
        ev.setLink(this.getLink());
        ev.setGeo(this.getGeo());
        ev.setDeleted(this.getDeleted());
        ev.setStatus(this.getStatus());
        ev.setCost(this.getCost());
        BwOrganizer org = this.getOrganizer();
        if (org != null) {
            org = (BwOrganizer)org.clone();
        }
        ev.setOrganizer(org);
        ev.setDtstamp(this.getDtstamp());
        ev.setLastmod(this.getLastmod());
        ev.setCreated(this.getCreated());
        ev.setStag(this.getStag());
        ev.setPriority(this.getPriority());
        ev.setSequence(this.getSequence());
        ev.setLocation(this.getLocation());
        ev.setUid(this.getUid());
        ev.setTransparency(this.getTransparency());
        ev.setPercentComplete(this.getPercentComplete());
        ev.setCompleted(this.getCompleted());
        ev.setCategories(this.copyCategories());
        ev.setContacts(this.copyContacts());
        ev.setAttendees(this.cloneAttendees());
        ev.setCtoken(this.getCtoken());
        ev.setRecurrenceId(this.getRecurrenceId());
        ev.setRecurring(this.getRecurring());
        if (ev.isRecurringEntity()) {
            ev.setRrules(this.clone(this.getRrules()));
            ev.setExrules(this.clone(this.getExrules()));
            ev.setRdates(this.clone(this.getRdates()));
            ev.setExdates(this.clone(this.getExdates()));
        }
        ev.setScheduleMethod(this.getScheduleMethod());
        ev.setOriginator(this.getOriginator());
        if (this.getNumComments() > 0) {
            ev.setComments(null);
            for (BwString bwString : this.getComments()) {
                ev.addComment((BwString)bwString.clone());
            }
        }
        if (this.getNumSummaries() > 0) {
            ev.setSummaries(null);
            for (BwString bwString : this.getSummaries()) {
                ev.addSummary((BwString)bwString.clone());
            }
        }
        if (this.getNumDescriptions() > 0) {
            ev.setDescriptions((Set<BwLongString>)null);
            for (BwLongString bwLongString : this.getDescriptions()) {
                ev.addDescription((BwLongString)bwLongString.clone());
            }
        }
        if (this.getNumResources() > 0) {
            ev.setResources(null);
            for (BwString bwString : this.getResources()) {
                ev.addResource((BwString)bwString.clone());
            }
        }
        if (this.getNumXproperties() > 0) {
            ev.setXproperties(null);
            for (BwXproperty bwXproperty : this.getXproperties()) {
                ev.addXproperty((BwXproperty)bwXproperty.clone());
            }
        }
        ev.setScheduleState(this.getScheduleState());
        BwRelatedTo rt = this.getRelatedTo();
        if (rt != null) {
            ev.setRelatedTo((BwRelatedTo)rt.clone());
        }
        ev.setPollCandidate(this.getPollCandidate());
    }

    @NoProxy
    public BwEvent cloneTombstone() {
        BwEventObj ev = new BwEventObj();
        super.copyTo(ev);
        ev.setEntityType(this.getEntityType());
        ev.setName(this.getName());
        ev.setDtstart(this.getDtstart());
        ev.setDtend(this.getDtend());
        ev.setEndType(this.getEndType());
        ev.setDuration(this.getDuration());
        ev.setNoStart(this.getNoStart());
        ev.setDeleted(this.getDeleted());
        ev.setDtstamp(this.getDtstamp());
        ev.setLastmod(this.getLastmod());
        ev.setCreated(this.getCreated());
        ev.setStag(this.getStag());
        ev.setUid(this.getUid());
        ev.setRecurring(false);
        ev.setTombstoned(true);
        return ev;
    }

    @NoProxy
    public static boolean validTransparency(String val) {
        if (val == null) {
            return false;
        }
        if ("OPAQUE".equals(val)) {
            return true;
        }
        return "TRANSPARENT".equals(val);
    }

    @NoProxy
    @NoDump
    public void setSuppressed(boolean val) {
        if (val) {
            this.setStatus(statusMasterSuppressed);
        } else {
            this.setStatus(null);
        }
    }

    @NoProxy
    @NoDump
    public boolean getSuppressed() {
        String s = this.getStatus();
        if (s == null) {
            return false;
        }
        return s.equals(statusMasterSuppressed);
    }

    @NoProxy
    public void assignGuid(String systemId) {
        if (this.getName() != null && this.getUid() != null) {
            return;
        }
        String guidPrefix = "CAL-" + Uid.getUid();
        if (this.getName() == null) {
            this.setName(guidPrefix + ".ics");
        }
        if (this.getUid() != null) {
            return;
        }
        this.setUid(guidPrefix + systemId);
    }

    @Override
    @NoProxy
    public int compare(BwEvent e1, BwEvent e2) {
        if (e1 == e2) {
            return 0;
        }
        int res = CalFacadeUtil.cmpObjval(e1.getDtstart(), e2.getDtstart());
        if (res != 0) {
            return res;
        }
        res = CalFacadeUtil.cmpObjval(e1.getColPath(), e2.getColPath());
        if (res != 0) {
            return res;
        }
        res = CalFacadeUtil.cmpObjval(e1.getName(), e2.getName());
        if (res != 0) {
            return res;
        }
        res = CalFacadeUtil.cmpObjval(e1.getRecurrenceId(), e2.getRecurrenceId());
        if (res != 0) {
            return res;
        }
        return e1.getUid().compareTo(e2.getUid());
    }

    @Override
    @NoProxy
    public int compareTo(BwEvent o2) {
        return this.compare(this, o2);
    }

    @Override
    @NoProxy
    public int hashCode() {
        return this.getUid().hashCode();
    }

    @NoProxy
    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    @Override
    @NoProxy
    public Object clone() {
        BwEvent ev = new BwEvent();
        this.copyTo(ev);
        return ev;
    }

    @NoDump
    public long getMicrosecsVersion() throws CalFacadeException {
        try {
            String[] ct = this.getCtoken().split("-");
            return new LastModified(ct[0]).getDate().getTime() * 1000000L + (long)Integer.parseInt(ct[1], 16) * 100L;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    @NoProxy
    public static String hex4(int val) {
        String formatted = Integer.toHexString(val % 32001);
        StringBuilder buf = new StringBuilder("0000");
        buf.replace(4 - formatted.length(), 4, formatted);
        return buf.toString();
    }

    @NoProxy
    public static String hex4FromNanos(int val) {
        String formatted = Integer.toHexString(val / 100000);
        StringBuilder buf = new StringBuilder("0000");
        buf.replace(4 - formatted.length(), 4, formatted);
        return buf.toString();
    }

    private <T extends Set<?>> T clone(T c) {
        if (c == null) {
            return null;
        }
        return (T)new TreeSet(c);
    }

    public static class SuggestedTo {
        private final char status;
        private final String groupHref;
        private final String suggestedByHref;
        public static final char accepted = 'A';
        public static final char rejected = 'R';
        public static final char pending = 'P';

        public SuggestedTo(char status, String groupHref, String suggestedByHref) {
            this.status = status;
            this.groupHref = groupHref;
            this.suggestedByHref = suggestedByHref;
        }

        public static SuggestedTo make(String val) {
            if (val.length() < 6 || val.charAt(1) != ':') {
                return null;
            }
            try {
                return new SuggestedTo(val);
            }
            catch (Throwable ignored) {
                return null;
            }
        }

        public SuggestedTo(String val) {
            if (val.length() > 6 && val.charAt(1) == ':') {
                String hrefs;
                int pos;
                this.status = val.charAt(0);
                if ((this.status == 'A' || this.status == 'R' || this.status == 'P') && (pos = (hrefs = val.substring(2)).indexOf(":")) > 0 && pos < hrefs.length() - 1) {
                    this.groupHref = hrefs.substring(0, pos);
                    this.suggestedByHref = hrefs.substring(pos + 1);
                    return;
                }
            }
            throw new RuntimeException("Bad suggested value: " + val);
        }

        public char getStatus() {
            return this.status;
        }

        public String getGroupHref() {
            return this.groupHref;
        }

        public String getSuggestedByHref() {
            return this.suggestedByHref;
        }

        public String toString() {
            return String.valueOf(this.getStatus()) + ":" + this.getGroupHref() + ":" + this.getSuggestedByHref();
        }
    }

    public static enum ProxiedFieldIndex {
        pfiEntityType,
        pfiName,
        pfiClassification,
        pfiLink,
        pfiGeo,
        pfiDeleted,
        pfiStatus,
        pfiCost,
        pfiOrganizer,
        pfiDtstamp,
        pfiLastmod,
        pfiCreated,
        pfiPriority,
        pfiSequence,
        pfiLocation,
        pfiUid,
        pfiTransparency,
        pfiPercentComplete,
        pfiCompleted,
        pfiScheduleMethod,
        pfiOriginator,
        pfiScheduleState,
        pfiRelatedTo,
        pfiXproperties,
        pfiRequestStatuses,
        pfiRecurring,
        pfiRecurrenceId,
        pfiRrules,
        pfiExrules,
        pfiRdates,
        pfiExdates,
        pfiLatestDate,
        pfiExpanded,
        pfiDtstart,
        pfiDtend,
        pfiEndType,
        pfiDuration,
        pfiNoStart,
        pfiAlarms,
        pfiAttachments,
        pfiAttendees,
        pfiRecipients,
        pfiCategories,
        pfiComments,
        pfiContacts,
        pfiDescriptions,
        pfiResources,
        pfiSummaries,
        pfiStag,
        pfiTombstoned,
        pfiOrganizerSchedulingObject,
        pfiAttendeeSchedulingObject,
        pfiCtoken,
        pfiPollItemId,
        pfiPollMode,
        pfiPollProperties,
        pfiPollAcceptResponse,
        pfiPollCandidate,
        pfiPollWinner;

    }
}

